/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.kafka.model.BrokerSoftwareInfo;
import software.amazon.awssdk.services.kafka.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BrokerNodeInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BrokerNodeInfo> {
    private static final SdkField<String> ATTACHED_ENI_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BrokerNodeInfo.getter(BrokerNodeInfo::attachedENIId)).setter(BrokerNodeInfo.setter(Builder::attachedENIId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachedENIId").build()}).build();
    private static final SdkField<Double> BROKER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(BrokerNodeInfo.getter(BrokerNodeInfo::brokerId)).setter(BrokerNodeInfo.setter(Builder::brokerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("brokerId").build()}).build();
    private static final SdkField<String> CLIENT_SUBNET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BrokerNodeInfo.getter(BrokerNodeInfo::clientSubnet)).setter(BrokerNodeInfo.setter(Builder::clientSubnet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientSubnet").build()}).build();
    private static final SdkField<String> CLIENT_VPC_IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BrokerNodeInfo.getter(BrokerNodeInfo::clientVpcIpAddress)).setter(BrokerNodeInfo.setter(Builder::clientVpcIpAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientVpcIpAddress").build()}).build();
    private static final SdkField<BrokerSoftwareInfo> CURRENT_BROKER_SOFTWARE_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(BrokerNodeInfo.getter(BrokerNodeInfo::currentBrokerSoftwareInfo)).setter(BrokerNodeInfo.setter(Builder::currentBrokerSoftwareInfo)).constructor(BrokerSoftwareInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentBrokerSoftwareInfo").build()}).build();
    private static final SdkField<List<String>> ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(BrokerNodeInfo.getter(BrokerNodeInfo::endpoints)).setter(BrokerNodeInfo.setter(Builder::endpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHED_ENI_ID_FIELD, BROKER_ID_FIELD, CLIENT_SUBNET_FIELD, CLIENT_VPC_IP_ADDRESS_FIELD, CURRENT_BROKER_SOFTWARE_INFO_FIELD, ENDPOINTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String attachedENIId;
    private final Double brokerId;
    private final String clientSubnet;
    private final String clientVpcIpAddress;
    private final BrokerSoftwareInfo currentBrokerSoftwareInfo;
    private final List<String> endpoints;

    private BrokerNodeInfo(BuilderImpl builder) {
        this.attachedENIId = builder.attachedENIId;
        this.brokerId = builder.brokerId;
        this.clientSubnet = builder.clientSubnet;
        this.clientVpcIpAddress = builder.clientVpcIpAddress;
        this.currentBrokerSoftwareInfo = builder.currentBrokerSoftwareInfo;
        this.endpoints = builder.endpoints;
    }

    public String attachedENIId() {
        return this.attachedENIId;
    }

    public Double brokerId() {
        return this.brokerId;
    }

    public String clientSubnet() {
        return this.clientSubnet;
    }

    public String clientVpcIpAddress() {
        return this.clientVpcIpAddress;
    }

    public BrokerSoftwareInfo currentBrokerSoftwareInfo() {
        return this.currentBrokerSoftwareInfo;
    }

    public List<String> endpoints() {
        return this.endpoints;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attachedENIId());
        hashCode = 31 * hashCode + Objects.hashCode(this.brokerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientSubnet());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientVpcIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentBrokerSoftwareInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoints());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BrokerNodeInfo)) {
            return false;
        }
        BrokerNodeInfo other = (BrokerNodeInfo)obj;
        return Objects.equals(this.attachedENIId(), other.attachedENIId()) && Objects.equals(this.brokerId(), other.brokerId()) && Objects.equals(this.clientSubnet(), other.clientSubnet()) && Objects.equals(this.clientVpcIpAddress(), other.clientVpcIpAddress()) && Objects.equals(this.currentBrokerSoftwareInfo(), other.currentBrokerSoftwareInfo()) && Objects.equals(this.endpoints(), other.endpoints());
    }

    public String toString() {
        return ToString.builder((String)"BrokerNodeInfo").add("AttachedENIId", (Object)this.attachedENIId()).add("BrokerId", (Object)this.brokerId()).add("ClientSubnet", (Object)this.clientSubnet()).add("ClientVpcIpAddress", (Object)this.clientVpcIpAddress()).add("CurrentBrokerSoftwareInfo", (Object)this.currentBrokerSoftwareInfo()).add("Endpoints", this.endpoints()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttachedENIId": {
                return Optional.ofNullable(clazz.cast(this.attachedENIId()));
            }
            case "BrokerId": {
                return Optional.ofNullable(clazz.cast(this.brokerId()));
            }
            case "ClientSubnet": {
                return Optional.ofNullable(clazz.cast(this.clientSubnet()));
            }
            case "ClientVpcIpAddress": {
                return Optional.ofNullable(clazz.cast(this.clientVpcIpAddress()));
            }
            case "CurrentBrokerSoftwareInfo": {
                return Optional.ofNullable(clazz.cast(this.currentBrokerSoftwareInfo()));
            }
            case "Endpoints": {
                return Optional.ofNullable(clazz.cast(this.endpoints()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BrokerNodeInfo, T> g) {
        return obj -> g.apply((BrokerNodeInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String attachedENIId;
        private Double brokerId;
        private String clientSubnet;
        private String clientVpcIpAddress;
        private BrokerSoftwareInfo currentBrokerSoftwareInfo;
        private List<String> endpoints = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BrokerNodeInfo model) {
            this.attachedENIId(model.attachedENIId);
            this.brokerId(model.brokerId);
            this.clientSubnet(model.clientSubnet);
            this.clientVpcIpAddress(model.clientVpcIpAddress);
            this.currentBrokerSoftwareInfo(model.currentBrokerSoftwareInfo);
            this.endpoints(model.endpoints);
        }

        public final String getAttachedENIId() {
            return this.attachedENIId;
        }

        @Override
        public final Builder attachedENIId(String attachedENIId) {
            this.attachedENIId = attachedENIId;
            return this;
        }

        public final void setAttachedENIId(String attachedENIId) {
            this.attachedENIId = attachedENIId;
        }

        public final Double getBrokerId() {
            return this.brokerId;
        }

        @Override
        public final Builder brokerId(Double brokerId) {
            this.brokerId = brokerId;
            return this;
        }

        public final void setBrokerId(Double brokerId) {
            this.brokerId = brokerId;
        }

        public final String getClientSubnet() {
            return this.clientSubnet;
        }

        @Override
        public final Builder clientSubnet(String clientSubnet) {
            this.clientSubnet = clientSubnet;
            return this;
        }

        public final void setClientSubnet(String clientSubnet) {
            this.clientSubnet = clientSubnet;
        }

        public final String getClientVpcIpAddress() {
            return this.clientVpcIpAddress;
        }

        @Override
        public final Builder clientVpcIpAddress(String clientVpcIpAddress) {
            this.clientVpcIpAddress = clientVpcIpAddress;
            return this;
        }

        public final void setClientVpcIpAddress(String clientVpcIpAddress) {
            this.clientVpcIpAddress = clientVpcIpAddress;
        }

        public final BrokerSoftwareInfo.Builder getCurrentBrokerSoftwareInfo() {
            return this.currentBrokerSoftwareInfo != null ? this.currentBrokerSoftwareInfo.toBuilder() : null;
        }

        @Override
        public final Builder currentBrokerSoftwareInfo(BrokerSoftwareInfo currentBrokerSoftwareInfo) {
            this.currentBrokerSoftwareInfo = currentBrokerSoftwareInfo;
            return this;
        }

        public final void setCurrentBrokerSoftwareInfo(BrokerSoftwareInfo.BuilderImpl currentBrokerSoftwareInfo) {
            this.currentBrokerSoftwareInfo = currentBrokerSoftwareInfo != null ? currentBrokerSoftwareInfo.build() : null;
        }

        public final Collection<String> getEndpoints() {
            return this.endpoints;
        }

        @Override
        public final Builder endpoints(Collection<String> endpoints) {
            this.endpoints = ___listOf__stringCopier.copy(endpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpoints(String ... endpoints) {
            this.endpoints(Arrays.asList(endpoints));
            return this;
        }

        public final void setEndpoints(Collection<String> endpoints) {
            this.endpoints = ___listOf__stringCopier.copy(endpoints);
        }

        public BrokerNodeInfo build() {
            return new BrokerNodeInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BrokerNodeInfo> {
        public Builder attachedENIId(String var1);

        public Builder brokerId(Double var1);

        public Builder clientSubnet(String var1);

        public Builder clientVpcIpAddress(String var1);

        public Builder currentBrokerSoftwareInfo(BrokerSoftwareInfo var1);

        default public Builder currentBrokerSoftwareInfo(Consumer<BrokerSoftwareInfo.Builder> currentBrokerSoftwareInfo) {
            return this.currentBrokerSoftwareInfo((BrokerSoftwareInfo)((BrokerSoftwareInfo.Builder)BrokerSoftwareInfo.builder().applyMutation(currentBrokerSoftwareInfo)).build());
        }

        public Builder endpoints(Collection<String> var1);

        public Builder endpoints(String ... var1);
    }
}

