/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kafka.model.BrokerNodeGroupInfo;
import software.amazon.awssdk.services.kafka.model.BrokerSoftwareInfo;
import software.amazon.awssdk.services.kafka.model.ClusterState;
import software.amazon.awssdk.services.kafka.model.EncryptionInfo;
import software.amazon.awssdk.services.kafka.model.EnhancedMonitoring;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClusterInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClusterInfo> {
    private static final SdkField<BrokerNodeGroupInfo> BROKER_NODE_GROUP_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ClusterInfo.getter(ClusterInfo::brokerNodeGroupInfo)).setter(ClusterInfo.setter(Builder::brokerNodeGroupInfo)).constructor(BrokerNodeGroupInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("brokerNodeGroupInfo").build()}).build();
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ClusterInfo.getter(ClusterInfo::clusterArn)).setter(ClusterInfo.setter(Builder::clusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterArn").build()}).build();
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ClusterInfo.getter(ClusterInfo::clusterName)).setter(ClusterInfo.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterName").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ClusterInfo.getter(ClusterInfo::creationTime)).setter(ClusterInfo.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<BrokerSoftwareInfo> CURRENT_BROKER_SOFTWARE_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ClusterInfo.getter(ClusterInfo::currentBrokerSoftwareInfo)).setter(ClusterInfo.setter(Builder::currentBrokerSoftwareInfo)).constructor(BrokerSoftwareInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentBrokerSoftwareInfo").build()}).build();
    private static final SdkField<String> CURRENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ClusterInfo.getter(ClusterInfo::currentVersion)).setter(ClusterInfo.setter(Builder::currentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentVersion").build()}).build();
    private static final SdkField<EncryptionInfo> ENCRYPTION_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ClusterInfo.getter(ClusterInfo::encryptionInfo)).setter(ClusterInfo.setter(Builder::encryptionInfo)).constructor(EncryptionInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionInfo").build()}).build();
    private static final SdkField<String> ENHANCED_MONITORING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ClusterInfo.getter(ClusterInfo::enhancedMonitoringAsString)).setter(ClusterInfo.setter(Builder::enhancedMonitoring)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enhancedMonitoring").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_BROKER_NODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ClusterInfo.getter(ClusterInfo::numberOfBrokerNodes)).setter(ClusterInfo.setter(Builder::numberOfBrokerNodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfBrokerNodes").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ClusterInfo.getter(ClusterInfo::stateAsString)).setter(ClusterInfo.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<String> ZOOKEEPER_CONNECT_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ClusterInfo.getter(ClusterInfo::zookeeperConnectString)).setter(ClusterInfo.setter(Builder::zookeeperConnectString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("zookeeperConnectString").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BROKER_NODE_GROUP_INFO_FIELD, CLUSTER_ARN_FIELD, CLUSTER_NAME_FIELD, CREATION_TIME_FIELD, CURRENT_BROKER_SOFTWARE_INFO_FIELD, CURRENT_VERSION_FIELD, ENCRYPTION_INFO_FIELD, ENHANCED_MONITORING_FIELD, NUMBER_OF_BROKER_NODES_FIELD, STATE_FIELD, ZOOKEEPER_CONNECT_STRING_FIELD));
    private static final long serialVersionUID = 1L;
    private final BrokerNodeGroupInfo brokerNodeGroupInfo;
    private final String clusterArn;
    private final String clusterName;
    private final Instant creationTime;
    private final BrokerSoftwareInfo currentBrokerSoftwareInfo;
    private final String currentVersion;
    private final EncryptionInfo encryptionInfo;
    private final String enhancedMonitoring;
    private final Integer numberOfBrokerNodes;
    private final String state;
    private final String zookeeperConnectString;

    private ClusterInfo(BuilderImpl builder) {
        this.brokerNodeGroupInfo = builder.brokerNodeGroupInfo;
        this.clusterArn = builder.clusterArn;
        this.clusterName = builder.clusterName;
        this.creationTime = builder.creationTime;
        this.currentBrokerSoftwareInfo = builder.currentBrokerSoftwareInfo;
        this.currentVersion = builder.currentVersion;
        this.encryptionInfo = builder.encryptionInfo;
        this.enhancedMonitoring = builder.enhancedMonitoring;
        this.numberOfBrokerNodes = builder.numberOfBrokerNodes;
        this.state = builder.state;
        this.zookeeperConnectString = builder.zookeeperConnectString;
    }

    public BrokerNodeGroupInfo brokerNodeGroupInfo() {
        return this.brokerNodeGroupInfo;
    }

    public String clusterArn() {
        return this.clusterArn;
    }

    public String clusterName() {
        return this.clusterName;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public BrokerSoftwareInfo currentBrokerSoftwareInfo() {
        return this.currentBrokerSoftwareInfo;
    }

    public String currentVersion() {
        return this.currentVersion;
    }

    public EncryptionInfo encryptionInfo() {
        return this.encryptionInfo;
    }

    public EnhancedMonitoring enhancedMonitoring() {
        return EnhancedMonitoring.fromValue(this.enhancedMonitoring);
    }

    public String enhancedMonitoringAsString() {
        return this.enhancedMonitoring;
    }

    public Integer numberOfBrokerNodes() {
        return this.numberOfBrokerNodes;
    }

    public ClusterState state() {
        return ClusterState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public String zookeeperConnectString() {
        return this.zookeeperConnectString;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.brokerNodeGroupInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentBrokerSoftwareInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.enhancedMonitoringAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfBrokerNodes());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.zookeeperConnectString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterInfo)) {
            return false;
        }
        ClusterInfo other = (ClusterInfo)obj;
        return Objects.equals(this.brokerNodeGroupInfo(), other.brokerNodeGroupInfo()) && Objects.equals(this.clusterArn(), other.clusterArn()) && Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.currentBrokerSoftwareInfo(), other.currentBrokerSoftwareInfo()) && Objects.equals(this.currentVersion(), other.currentVersion()) && Objects.equals(this.encryptionInfo(), other.encryptionInfo()) && Objects.equals(this.enhancedMonitoringAsString(), other.enhancedMonitoringAsString()) && Objects.equals(this.numberOfBrokerNodes(), other.numberOfBrokerNodes()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.zookeeperConnectString(), other.zookeeperConnectString());
    }

    public String toString() {
        return ToString.builder((String)"ClusterInfo").add("BrokerNodeGroupInfo", (Object)this.brokerNodeGroupInfo()).add("ClusterArn", (Object)this.clusterArn()).add("ClusterName", (Object)this.clusterName()).add("CreationTime", (Object)this.creationTime()).add("CurrentBrokerSoftwareInfo", (Object)this.currentBrokerSoftwareInfo()).add("CurrentVersion", (Object)this.currentVersion()).add("EncryptionInfo", (Object)this.encryptionInfo()).add("EnhancedMonitoring", (Object)this.enhancedMonitoringAsString()).add("NumberOfBrokerNodes", (Object)this.numberOfBrokerNodes()).add("State", (Object)this.stateAsString()).add("ZookeeperConnectString", (Object)this.zookeeperConnectString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BrokerNodeGroupInfo": {
                return Optional.ofNullable(clazz.cast(this.brokerNodeGroupInfo()));
            }
            case "ClusterArn": {
                return Optional.ofNullable(clazz.cast(this.clusterArn()));
            }
            case "ClusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "CurrentBrokerSoftwareInfo": {
                return Optional.ofNullable(clazz.cast(this.currentBrokerSoftwareInfo()));
            }
            case "CurrentVersion": {
                return Optional.ofNullable(clazz.cast(this.currentVersion()));
            }
            case "EncryptionInfo": {
                return Optional.ofNullable(clazz.cast(this.encryptionInfo()));
            }
            case "EnhancedMonitoring": {
                return Optional.ofNullable(clazz.cast(this.enhancedMonitoringAsString()));
            }
            case "NumberOfBrokerNodes": {
                return Optional.ofNullable(clazz.cast(this.numberOfBrokerNodes()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "ZookeeperConnectString": {
                return Optional.ofNullable(clazz.cast(this.zookeeperConnectString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClusterInfo, T> g) {
        return obj -> g.apply((ClusterInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private BrokerNodeGroupInfo brokerNodeGroupInfo;
        private String clusterArn;
        private String clusterName;
        private Instant creationTime;
        private BrokerSoftwareInfo currentBrokerSoftwareInfo;
        private String currentVersion;
        private EncryptionInfo encryptionInfo;
        private String enhancedMonitoring;
        private Integer numberOfBrokerNodes;
        private String state;
        private String zookeeperConnectString;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterInfo model) {
            this.brokerNodeGroupInfo(model.brokerNodeGroupInfo);
            this.clusterArn(model.clusterArn);
            this.clusterName(model.clusterName);
            this.creationTime(model.creationTime);
            this.currentBrokerSoftwareInfo(model.currentBrokerSoftwareInfo);
            this.currentVersion(model.currentVersion);
            this.encryptionInfo(model.encryptionInfo);
            this.enhancedMonitoring(model.enhancedMonitoring);
            this.numberOfBrokerNodes(model.numberOfBrokerNodes);
            this.state(model.state);
            this.zookeeperConnectString(model.zookeeperConnectString);
        }

        public final BrokerNodeGroupInfo.Builder getBrokerNodeGroupInfo() {
            return this.brokerNodeGroupInfo != null ? this.brokerNodeGroupInfo.toBuilder() : null;
        }

        @Override
        public final Builder brokerNodeGroupInfo(BrokerNodeGroupInfo brokerNodeGroupInfo) {
            this.brokerNodeGroupInfo = brokerNodeGroupInfo;
            return this;
        }

        public final void setBrokerNodeGroupInfo(BrokerNodeGroupInfo.BuilderImpl brokerNodeGroupInfo) {
            this.brokerNodeGroupInfo = brokerNodeGroupInfo != null ? brokerNodeGroupInfo.build() : null;
        }

        public final String getClusterArn() {
            return this.clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final BrokerSoftwareInfo.Builder getCurrentBrokerSoftwareInfo() {
            return this.currentBrokerSoftwareInfo != null ? this.currentBrokerSoftwareInfo.toBuilder() : null;
        }

        @Override
        public final Builder currentBrokerSoftwareInfo(BrokerSoftwareInfo currentBrokerSoftwareInfo) {
            this.currentBrokerSoftwareInfo = currentBrokerSoftwareInfo;
            return this;
        }

        public final void setCurrentBrokerSoftwareInfo(BrokerSoftwareInfo.BuilderImpl currentBrokerSoftwareInfo) {
            this.currentBrokerSoftwareInfo = currentBrokerSoftwareInfo != null ? currentBrokerSoftwareInfo.build() : null;
        }

        public final String getCurrentVersion() {
            return this.currentVersion;
        }

        @Override
        public final Builder currentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
            return this;
        }

        public final void setCurrentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
        }

        public final EncryptionInfo.Builder getEncryptionInfo() {
            return this.encryptionInfo != null ? this.encryptionInfo.toBuilder() : null;
        }

        @Override
        public final Builder encryptionInfo(EncryptionInfo encryptionInfo) {
            this.encryptionInfo = encryptionInfo;
            return this;
        }

        public final void setEncryptionInfo(EncryptionInfo.BuilderImpl encryptionInfo) {
            this.encryptionInfo = encryptionInfo != null ? encryptionInfo.build() : null;
        }

        public final String getEnhancedMonitoringAsString() {
            return this.enhancedMonitoring;
        }

        @Override
        public final Builder enhancedMonitoring(String enhancedMonitoring) {
            this.enhancedMonitoring = enhancedMonitoring;
            return this;
        }

        @Override
        public final Builder enhancedMonitoring(EnhancedMonitoring enhancedMonitoring) {
            this.enhancedMonitoring(enhancedMonitoring.toString());
            return this;
        }

        public final void setEnhancedMonitoring(String enhancedMonitoring) {
            this.enhancedMonitoring = enhancedMonitoring;
        }

        public final Integer getNumberOfBrokerNodes() {
            return this.numberOfBrokerNodes;
        }

        @Override
        public final Builder numberOfBrokerNodes(Integer numberOfBrokerNodes) {
            this.numberOfBrokerNodes = numberOfBrokerNodes;
            return this;
        }

        public final void setNumberOfBrokerNodes(Integer numberOfBrokerNodes) {
            this.numberOfBrokerNodes = numberOfBrokerNodes;
        }

        public final String getStateAsString() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ClusterState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getZookeeperConnectString() {
            return this.zookeeperConnectString;
        }

        @Override
        public final Builder zookeeperConnectString(String zookeeperConnectString) {
            this.zookeeperConnectString = zookeeperConnectString;
            return this;
        }

        public final void setZookeeperConnectString(String zookeeperConnectString) {
            this.zookeeperConnectString = zookeeperConnectString;
        }

        public ClusterInfo build() {
            return new ClusterInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClusterInfo> {
        public Builder brokerNodeGroupInfo(BrokerNodeGroupInfo var1);

        default public Builder brokerNodeGroupInfo(Consumer<BrokerNodeGroupInfo.Builder> brokerNodeGroupInfo) {
            return this.brokerNodeGroupInfo((BrokerNodeGroupInfo)((BrokerNodeGroupInfo.Builder)BrokerNodeGroupInfo.builder().applyMutation(brokerNodeGroupInfo)).build());
        }

        public Builder clusterArn(String var1);

        public Builder clusterName(String var1);

        public Builder creationTime(Instant var1);

        public Builder currentBrokerSoftwareInfo(BrokerSoftwareInfo var1);

        default public Builder currentBrokerSoftwareInfo(Consumer<BrokerSoftwareInfo.Builder> currentBrokerSoftwareInfo) {
            return this.currentBrokerSoftwareInfo((BrokerSoftwareInfo)((BrokerSoftwareInfo.Builder)BrokerSoftwareInfo.builder().applyMutation(currentBrokerSoftwareInfo)).build());
        }

        public Builder currentVersion(String var1);

        public Builder encryptionInfo(EncryptionInfo var1);

        default public Builder encryptionInfo(Consumer<EncryptionInfo.Builder> encryptionInfo) {
            return this.encryptionInfo((EncryptionInfo)((EncryptionInfo.Builder)EncryptionInfo.builder().applyMutation(encryptionInfo)).build());
        }

        public Builder enhancedMonitoring(String var1);

        public Builder enhancedMonitoring(EnhancedMonitoring var1);

        public Builder numberOfBrokerNodes(Integer var1);

        public Builder state(String var1);

        public Builder state(ClusterState var1);

        public Builder zookeeperConnectString(String var1);
    }
}

