/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a topic partition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TopicPartitionInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<TopicPartitionInfo.Builder, TopicPartitionInfo> {
    private static final SdkField<Integer> PARTITION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Partition").getter(getter(TopicPartitionInfo::partition)).setter(setter(Builder::partition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("partition").build()).build();

    private static final SdkField<Integer> LEADER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Leader").getter(getter(TopicPartitionInfo::leader)).setter(setter(Builder::leader))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("leader").build()).build();

    private static final SdkField<List<Integer>> REPLICAS_FIELD = SdkField
            .<List<Integer>> builder(MarshallingType.LIST)
            .memberName("Replicas")
            .getter(getter(TopicPartitionInfo::replicas))
            .setter(setter(Builder::replicas))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicas").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Integer>> ISR_FIELD = SdkField
            .<List<Integer>> builder(MarshallingType.LIST)
            .memberName("Isr")
            .getter(getter(TopicPartitionInfo::isr))
            .setter(setter(Builder::isr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isr").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARTITION_FIELD, LEADER_FIELD,
            REPLICAS_FIELD, ISR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer partition;

    private final Integer leader;

    private final List<Integer> replicas;

    private final List<Integer> isr;

    private TopicPartitionInfo(BuilderImpl builder) {
        this.partition = builder.partition;
        this.leader = builder.leader;
        this.replicas = builder.replicas;
        this.isr = builder.isr;
    }

    /**
     * <p>
     * The partition ID.
     * </p>
     * 
     * @return The partition ID.
     */
    public final Integer partition() {
        return partition;
    }

    /**
     * <p>
     * The leader broker ID for the partition.
     * </p>
     * 
     * @return The leader broker ID for the partition.
     */
    public final Integer leader() {
        return leader;
    }

    /**
     * For responses, this returns true if the service returned a value for the Replicas property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasReplicas() {
        return replicas != null && !(replicas instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of replica broker IDs for the partition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReplicas} method.
     * </p>
     * 
     * @return The list of replica broker IDs for the partition.
     */
    public final List<Integer> replicas() {
        return replicas;
    }

    /**
     * For responses, this returns true if the service returned a value for the Isr property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasIsr() {
        return isr != null && !(isr instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of in-sync replica broker IDs for the partition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIsr} method.
     * </p>
     * 
     * @return The list of in-sync replica broker IDs for the partition.
     */
    public final List<Integer> isr() {
        return isr;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(partition());
        hashCode = 31 * hashCode + Objects.hashCode(leader());
        hashCode = 31 * hashCode + Objects.hashCode(hasReplicas() ? replicas() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasIsr() ? isr() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicPartitionInfo)) {
            return false;
        }
        TopicPartitionInfo other = (TopicPartitionInfo) obj;
        return Objects.equals(partition(), other.partition()) && Objects.equals(leader(), other.leader())
                && hasReplicas() == other.hasReplicas() && Objects.equals(replicas(), other.replicas())
                && hasIsr() == other.hasIsr() && Objects.equals(isr(), other.isr());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TopicPartitionInfo").add("Partition", partition()).add("Leader", leader())
                .add("Replicas", hasReplicas() ? replicas() : null).add("Isr", hasIsr() ? isr() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Partition":
            return Optional.ofNullable(clazz.cast(partition()));
        case "Leader":
            return Optional.ofNullable(clazz.cast(leader()));
        case "Replicas":
            return Optional.ofNullable(clazz.cast(replicas()));
        case "Isr":
            return Optional.ofNullable(clazz.cast(isr()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("partition", PARTITION_FIELD);
        map.put("leader", LEADER_FIELD);
        map.put("replicas", REPLICAS_FIELD);
        map.put("isr", ISR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TopicPartitionInfo, T> g) {
        return obj -> g.apply((TopicPartitionInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TopicPartitionInfo> {
        /**
         * <p>
         * The partition ID.
         * </p>
         * 
         * @param partition
         *        The partition ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partition(Integer partition);

        /**
         * <p>
         * The leader broker ID for the partition.
         * </p>
         * 
         * @param leader
         *        The leader broker ID for the partition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder leader(Integer leader);

        /**
         * <p>
         * The list of replica broker IDs for the partition.
         * </p>
         * 
         * @param replicas
         *        The list of replica broker IDs for the partition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicas(Collection<Integer> replicas);

        /**
         * <p>
         * The list of replica broker IDs for the partition.
         * </p>
         * 
         * @param replicas
         *        The list of replica broker IDs for the partition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicas(Integer... replicas);

        /**
         * <p>
         * The list of in-sync replica broker IDs for the partition.
         * </p>
         * 
         * @param isr
         *        The list of in-sync replica broker IDs for the partition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isr(Collection<Integer> isr);

        /**
         * <p>
         * The list of in-sync replica broker IDs for the partition.
         * </p>
         * 
         * @param isr
         *        The list of in-sync replica broker IDs for the partition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isr(Integer... isr);
    }

    static final class BuilderImpl implements Builder {
        private Integer partition;

        private Integer leader;

        private List<Integer> replicas = DefaultSdkAutoConstructList.getInstance();

        private List<Integer> isr = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TopicPartitionInfo model) {
            partition(model.partition);
            leader(model.leader);
            replicas(model.replicas);
            isr(model.isr);
        }

        public final Integer getPartition() {
            return partition;
        }

        public final void setPartition(Integer partition) {
            this.partition = partition;
        }

        @Override
        public final Builder partition(Integer partition) {
            this.partition = partition;
            return this;
        }

        public final Integer getLeader() {
            return leader;
        }

        public final void setLeader(Integer leader) {
            this.leader = leader;
        }

        @Override
        public final Builder leader(Integer leader) {
            this.leader = leader;
            return this;
        }

        public final Collection<Integer> getReplicas() {
            if (replicas instanceof SdkAutoConstructList) {
                return null;
            }
            return replicas;
        }

        public final void setReplicas(Collection<Integer> replicas) {
            this.replicas = ___listOf__integerCopier.copy(replicas);
        }

        @Override
        public final Builder replicas(Collection<Integer> replicas) {
            this.replicas = ___listOf__integerCopier.copy(replicas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicas(Integer... replicas) {
            replicas(Arrays.asList(replicas));
            return this;
        }

        public final Collection<Integer> getIsr() {
            if (isr instanceof SdkAutoConstructList) {
                return null;
            }
            return isr;
        }

        public final void setIsr(Collection<Integer> isr) {
            this.isr = ___listOf__integerCopier.copy(isr);
        }

        @Override
        public final Builder isr(Collection<Integer> isr) {
            this.isr = ___listOf__integerCopier.copy(isr);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder isr(Integer... isr) {
            isr(Arrays.asList(isr));
            return this;
        }

        @Override
        public TopicPartitionInfo build() {
            return new TopicPartitionInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
