/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 *
 * <p>
 * Details for client authentication using SASL.
 * </p>
 * 
 */
@Generated("software.amazon.awssdk:codegen")
public final class Sasl implements SdkPojo, Serializable, ToCopyableBuilder<Sasl.Builder, Sasl> {
    private static final SdkField<Scram> SCRAM_FIELD = SdkField.<Scram> builder(MarshallingType.SDK_POJO).memberName("Scram")
            .getter(getter(Sasl::scram)).setter(setter(Builder::scram)).constructor(Scram::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scram").build()).build();

    private static final SdkField<Iam> IAM_FIELD = SdkField.<Iam> builder(MarshallingType.SDK_POJO).memberName("Iam")
            .getter(getter(Sasl::iam)).setter(setter(Builder::iam)).constructor(Iam::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iam").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCRAM_FIELD, IAM_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Scram scram;

    private final Iam iam;

    private Sasl(BuilderImpl builder) {
        this.scram = builder.scram;
        this.iam = builder.iam;
    }

    /**
     *
     * <p>
     * Details for SASL/SCRAM client authentication.
     * </p>
     * 
     * @return <p>
     *         Details for SASL/SCRAM client authentication.
     *         </p>
     */
    public final Scram scram() {
        return scram;
    }

    /**
     *
     * <p>
     * Indicates whether IAM access control is enabled.
     * </p>
     * 
     * @return <p>
     *         Indicates whether IAM access control is enabled.
     *         </p>
     */
    public final Iam iam() {
        return iam;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scram());
        hashCode = 31 * hashCode + Objects.hashCode(iam());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Sasl)) {
            return false;
        }
        Sasl other = (Sasl) obj;
        return Objects.equals(scram(), other.scram()) && Objects.equals(iam(), other.iam());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Sasl").add("Scram", scram()).add("Iam", iam()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Scram":
            return Optional.ofNullable(clazz.cast(scram()));
        case "Iam":
            return Optional.ofNullable(clazz.cast(iam()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("scram", SCRAM_FIELD);
        map.put("iam", IAM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Sasl, T> g) {
        return obj -> g.apply((Sasl) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Sasl> {
        /**
         *
         * <p>
         * Details for SASL/SCRAM client authentication.
         * </p>
         * 
         * @param scram
         *        <p>
         *        Details for SASL/SCRAM client authentication.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scram(Scram scram);

        /**
         *
         * <p>
         * Details for SASL/SCRAM client authentication.
         * </p>
         * 
         * This is a convenience method that creates an instance of the {@link Scram.Builder} avoiding the need to
         * create one manually via {@link Scram#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Scram.Builder#build()} is called immediately and its result is
         * passed to {@link #scram(Scram)}.
         * 
         * @param scram
         *        a consumer that will call methods on {@link Scram.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scram(Scram)
         */
        default Builder scram(Consumer<Scram.Builder> scram) {
            return scram(Scram.builder().applyMutation(scram).build());
        }

        /**
         *
         * <p>
         * Indicates whether IAM access control is enabled.
         * </p>
         * 
         * @param iam
         *        <p>
         *        Indicates whether IAM access control is enabled.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iam(Iam iam);

        /**
         *
         * <p>
         * Indicates whether IAM access control is enabled.
         * </p>
         * 
         * This is a convenience method that creates an instance of the {@link Iam.Builder} avoiding the need to create
         * one manually via {@link Iam#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Iam.Builder#build()} is called immediately and its result is
         * passed to {@link #iam(Iam)}.
         * 
         * @param iam
         *        a consumer that will call methods on {@link Iam.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iam(Iam)
         */
        default Builder iam(Consumer<Iam.Builder> iam) {
            return iam(Iam.builder().applyMutation(iam).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Scram scram;

        private Iam iam;

        private BuilderImpl() {
        }

        private BuilderImpl(Sasl model) {
            scram(model.scram);
            iam(model.iam);
        }

        public final Scram.Builder getScram() {
            return scram != null ? scram.toBuilder() : null;
        }

        public final void setScram(Scram.BuilderImpl scram) {
            this.scram = scram != null ? scram.build() : null;
        }

        @Override
        public final Builder scram(Scram scram) {
            this.scram = scram;
            return this;
        }

        public final Iam.Builder getIam() {
            return iam != null ? iam.toBuilder() : null;
        }

        public final void setIam(Iam.BuilderImpl iam) {
            this.iam = iam != null ? iam.build() : null;
        }

        @Override
        public final Builder iam(Iam iam) {
            this.iam = iam;
            return this;
        }

        @Override
        public Sasl build() {
            return new Sasl(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
