/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summarized information of replication between clusters.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplicationInfoSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ReplicationInfoSummary.Builder, ReplicationInfoSummary> {
    private static final SdkField<String> SOURCE_KAFKA_CLUSTER_ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceKafkaClusterAlias").getter(getter(ReplicationInfoSummary::sourceKafkaClusterAlias))
            .setter(setter(Builder::sourceKafkaClusterAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceKafkaClusterAlias").build())
            .build();

    private static final SdkField<String> TARGET_KAFKA_CLUSTER_ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetKafkaClusterAlias").getter(getter(ReplicationInfoSummary::targetKafkaClusterAlias))
            .setter(setter(Builder::targetKafkaClusterAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetKafkaClusterAlias").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SOURCE_KAFKA_CLUSTER_ALIAS_FIELD, TARGET_KAFKA_CLUSTER_ALIAS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sourceKafkaClusterAlias;

    private final String targetKafkaClusterAlias;

    private ReplicationInfoSummary(BuilderImpl builder) {
        this.sourceKafkaClusterAlias = builder.sourceKafkaClusterAlias;
        this.targetKafkaClusterAlias = builder.targetKafkaClusterAlias;
    }

    /**
     * <p>
     * The alias of the source Kafka cluster.
     * </p>
     * 
     * @return The alias of the source Kafka cluster.
     */
    public final String sourceKafkaClusterAlias() {
        return sourceKafkaClusterAlias;
    }

    /**
     * <p>
     * The alias of the target Kafka cluster.
     * </p>
     * 
     * @return The alias of the target Kafka cluster.
     */
    public final String targetKafkaClusterAlias() {
        return targetKafkaClusterAlias;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceKafkaClusterAlias());
        hashCode = 31 * hashCode + Objects.hashCode(targetKafkaClusterAlias());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationInfoSummary)) {
            return false;
        }
        ReplicationInfoSummary other = (ReplicationInfoSummary) obj;
        return Objects.equals(sourceKafkaClusterAlias(), other.sourceKafkaClusterAlias())
                && Objects.equals(targetKafkaClusterAlias(), other.targetKafkaClusterAlias());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReplicationInfoSummary").add("SourceKafkaClusterAlias", sourceKafkaClusterAlias())
                .add("TargetKafkaClusterAlias", targetKafkaClusterAlias()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceKafkaClusterAlias":
            return Optional.ofNullable(clazz.cast(sourceKafkaClusterAlias()));
        case "TargetKafkaClusterAlias":
            return Optional.ofNullable(clazz.cast(targetKafkaClusterAlias()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sourceKafkaClusterAlias", SOURCE_KAFKA_CLUSTER_ALIAS_FIELD);
        map.put("targetKafkaClusterAlias", TARGET_KAFKA_CLUSTER_ALIAS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReplicationInfoSummary, T> g) {
        return obj -> g.apply((ReplicationInfoSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReplicationInfoSummary> {
        /**
         * <p>
         * The alias of the source Kafka cluster.
         * </p>
         * 
         * @param sourceKafkaClusterAlias
         *        The alias of the source Kafka cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceKafkaClusterAlias(String sourceKafkaClusterAlias);

        /**
         * <p>
         * The alias of the target Kafka cluster.
         * </p>
         * 
         * @param targetKafkaClusterAlias
         *        The alias of the target Kafka cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetKafkaClusterAlias(String targetKafkaClusterAlias);
    }

    static final class BuilderImpl implements Builder {
        private String sourceKafkaClusterAlias;

        private String targetKafkaClusterAlias;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationInfoSummary model) {
            sourceKafkaClusterAlias(model.sourceKafkaClusterAlias);
            targetKafkaClusterAlias(model.targetKafkaClusterAlias);
        }

        public final String getSourceKafkaClusterAlias() {
            return sourceKafkaClusterAlias;
        }

        public final void setSourceKafkaClusterAlias(String sourceKafkaClusterAlias) {
            this.sourceKafkaClusterAlias = sourceKafkaClusterAlias;
        }

        @Override
        public final Builder sourceKafkaClusterAlias(String sourceKafkaClusterAlias) {
            this.sourceKafkaClusterAlias = sourceKafkaClusterAlias;
            return this;
        }

        public final String getTargetKafkaClusterAlias() {
            return targetKafkaClusterAlias;
        }

        public final void setTargetKafkaClusterAlias(String targetKafkaClusterAlias) {
            this.targetKafkaClusterAlias = targetKafkaClusterAlias;
        }

        @Override
        public final Builder targetKafkaClusterAlias(String targetKafkaClusterAlias) {
            this.targetKafkaClusterAlias = targetKafkaClusterAlias;
            return this;
        }

        @Override
        public ReplicationInfoSummary build() {
            return new ReplicationInfoSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
