/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 *
 * <p>
 * The node information object.
 * </p>
 * 
 */
@Generated("software.amazon.awssdk:codegen")
public final class NodeInfo implements SdkPojo, Serializable, ToCopyableBuilder<NodeInfo.Builder, NodeInfo> {
    private static final SdkField<String> ADDED_TO_CLUSTER_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AddedToClusterTime").getter(getter(NodeInfo::addedToClusterTime))
            .setter(setter(Builder::addedToClusterTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addedToClusterTime").build())
            .build();

    private static final SdkField<BrokerNodeInfo> BROKER_NODE_INFO_FIELD = SdkField
            .<BrokerNodeInfo> builder(MarshallingType.SDK_POJO).memberName("BrokerNodeInfo")
            .getter(getter(NodeInfo::brokerNodeInfo)).setter(setter(Builder::brokerNodeInfo))
            .constructor(BrokerNodeInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("brokerNodeInfo").build()).build();

    private static final SdkField<ControllerNodeInfo> CONTROLLER_NODE_INFO_FIELD = SdkField
            .<ControllerNodeInfo> builder(MarshallingType.SDK_POJO).memberName("ControllerNodeInfo")
            .getter(getter(NodeInfo::controllerNodeInfo)).setter(setter(Builder::controllerNodeInfo))
            .constructor(ControllerNodeInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controllerNodeInfo").build())
            .build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceType").getter(getter(NodeInfo::instanceType)).setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceType").build()).build();

    private static final SdkField<String> NODE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NodeARN").getter(getter(NodeInfo::nodeARN)).setter(setter(Builder::nodeARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeARN").build()).build();

    private static final SdkField<String> NODE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NodeType").getter(getter(NodeInfo::nodeTypeAsString)).setter(setter(Builder::nodeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeType").build()).build();

    private static final SdkField<ZookeeperNodeInfo> ZOOKEEPER_NODE_INFO_FIELD = SdkField
            .<ZookeeperNodeInfo> builder(MarshallingType.SDK_POJO).memberName("ZookeeperNodeInfo")
            .getter(getter(NodeInfo::zookeeperNodeInfo)).setter(setter(Builder::zookeeperNodeInfo))
            .constructor(ZookeeperNodeInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("zookeeperNodeInfo").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDED_TO_CLUSTER_TIME_FIELD,
            BROKER_NODE_INFO_FIELD, CONTROLLER_NODE_INFO_FIELD, INSTANCE_TYPE_FIELD, NODE_ARN_FIELD, NODE_TYPE_FIELD,
            ZOOKEEPER_NODE_INFO_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String addedToClusterTime;

    private final BrokerNodeInfo brokerNodeInfo;

    private final ControllerNodeInfo controllerNodeInfo;

    private final String instanceType;

    private final String nodeARN;

    private final String nodeType;

    private final ZookeeperNodeInfo zookeeperNodeInfo;

    private NodeInfo(BuilderImpl builder) {
        this.addedToClusterTime = builder.addedToClusterTime;
        this.brokerNodeInfo = builder.brokerNodeInfo;
        this.controllerNodeInfo = builder.controllerNodeInfo;
        this.instanceType = builder.instanceType;
        this.nodeARN = builder.nodeARN;
        this.nodeType = builder.nodeType;
        this.zookeeperNodeInfo = builder.zookeeperNodeInfo;
    }

    /**
     *
     * <p>
     * The start time.
     * </p>
     * 
     * @return <p>
     *         The start time.
     *         </p>
     */
    public final String addedToClusterTime() {
        return addedToClusterTime;
    }

    /**
     *
     * <p>
     * The broker node info.
     * </p>
     * 
     * @return <p>
     *         The broker node info.
     *         </p>
     */
    public final BrokerNodeInfo brokerNodeInfo() {
        return brokerNodeInfo;
    }

    /**
     *
     * <p>
     * The ControllerNodeInfo.
     * </p>
     * 
     * @return <p>
     *         The ControllerNodeInfo.
     *         </p>
     */
    public final ControllerNodeInfo controllerNodeInfo() {
        return controllerNodeInfo;
    }

    /**
     *
     * <p>
     * The instance type.
     * </p>
     * 
     * @return <p>
     *         The instance type.
     *         </p>
     */
    public final String instanceType() {
        return instanceType;
    }

    /**
     *
     * <p>
     * The Amazon Resource Name (ARN) of the node.
     * </p>
     * 
     * @return <p>
     *         The Amazon Resource Name (ARN) of the node.
     *         </p>
     */
    public final String nodeARN() {
        return nodeARN;
    }

    /**
     *
     * <p>
     * The node type.
     * </p>
     * 
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nodeType} will
     * return {@link NodeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nodeTypeAsString}.
     * </p>
     * 
     * @return <p>
     *         The node type.
     *         </p>
     * @see NodeType
     */
    public final NodeType nodeType() {
        return NodeType.fromValue(nodeType);
    }

    /**
     *
     * <p>
     * The node type.
     * </p>
     * 
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nodeType} will
     * return {@link NodeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nodeTypeAsString}.
     * </p>
     * 
     * @return <p>
     *         The node type.
     *         </p>
     * @see NodeType
     */
    public final String nodeTypeAsString() {
        return nodeType;
    }

    /**
     *
     * <p>
     * The ZookeeperNodeInfo.
     * </p>
     * 
     * @return <p>
     *         The ZookeeperNodeInfo.
     *         </p>
     */
    public final ZookeeperNodeInfo zookeeperNodeInfo() {
        return zookeeperNodeInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(addedToClusterTime());
        hashCode = 31 * hashCode + Objects.hashCode(brokerNodeInfo());
        hashCode = 31 * hashCode + Objects.hashCode(controllerNodeInfo());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(nodeARN());
        hashCode = 31 * hashCode + Objects.hashCode(nodeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(zookeeperNodeInfo());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeInfo)) {
            return false;
        }
        NodeInfo other = (NodeInfo) obj;
        return Objects.equals(addedToClusterTime(), other.addedToClusterTime())
                && Objects.equals(brokerNodeInfo(), other.brokerNodeInfo())
                && Objects.equals(controllerNodeInfo(), other.controllerNodeInfo())
                && Objects.equals(instanceType(), other.instanceType()) && Objects.equals(nodeARN(), other.nodeARN())
                && Objects.equals(nodeTypeAsString(), other.nodeTypeAsString())
                && Objects.equals(zookeeperNodeInfo(), other.zookeeperNodeInfo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NodeInfo").add("AddedToClusterTime", addedToClusterTime())
                .add("BrokerNodeInfo", brokerNodeInfo()).add("ControllerNodeInfo", controllerNodeInfo())
                .add("InstanceType", instanceType()).add("NodeARN", nodeARN()).add("NodeType", nodeTypeAsString())
                .add("ZookeeperNodeInfo", zookeeperNodeInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AddedToClusterTime":
            return Optional.ofNullable(clazz.cast(addedToClusterTime()));
        case "BrokerNodeInfo":
            return Optional.ofNullable(clazz.cast(brokerNodeInfo()));
        case "ControllerNodeInfo":
            return Optional.ofNullable(clazz.cast(controllerNodeInfo()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "NodeARN":
            return Optional.ofNullable(clazz.cast(nodeARN()));
        case "NodeType":
            return Optional.ofNullable(clazz.cast(nodeTypeAsString()));
        case "ZookeeperNodeInfo":
            return Optional.ofNullable(clazz.cast(zookeeperNodeInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("addedToClusterTime", ADDED_TO_CLUSTER_TIME_FIELD);
        map.put("brokerNodeInfo", BROKER_NODE_INFO_FIELD);
        map.put("controllerNodeInfo", CONTROLLER_NODE_INFO_FIELD);
        map.put("instanceType", INSTANCE_TYPE_FIELD);
        map.put("nodeARN", NODE_ARN_FIELD);
        map.put("nodeType", NODE_TYPE_FIELD);
        map.put("zookeeperNodeInfo", ZOOKEEPER_NODE_INFO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NodeInfo, T> g) {
        return obj -> g.apply((NodeInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NodeInfo> {
        /**
         *
         * <p>
         * The start time.
         * </p>
         * 
         * @param addedToClusterTime
         *        <p>
         *        The start time.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addedToClusterTime(String addedToClusterTime);

        /**
         *
         * <p>
         * The broker node info.
         * </p>
         * 
         * @param brokerNodeInfo
         *        <p>
         *        The broker node info.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder brokerNodeInfo(BrokerNodeInfo brokerNodeInfo);

        /**
         *
         * <p>
         * The broker node info.
         * </p>
         * 
         * This is a convenience method that creates an instance of the {@link BrokerNodeInfo.Builder} avoiding the need
         * to create one manually via {@link BrokerNodeInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BrokerNodeInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #brokerNodeInfo(BrokerNodeInfo)}.
         * 
         * @param brokerNodeInfo
         *        a consumer that will call methods on {@link BrokerNodeInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #brokerNodeInfo(BrokerNodeInfo)
         */
        default Builder brokerNodeInfo(Consumer<BrokerNodeInfo.Builder> brokerNodeInfo) {
            return brokerNodeInfo(BrokerNodeInfo.builder().applyMutation(brokerNodeInfo).build());
        }

        /**
         *
         * <p>
         * The ControllerNodeInfo.
         * </p>
         * 
         * @param controllerNodeInfo
         *        <p>
         *        The ControllerNodeInfo.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controllerNodeInfo(ControllerNodeInfo controllerNodeInfo);

        /**
         *
         * <p>
         * The ControllerNodeInfo.
         * </p>
         * 
         * This is a convenience method that creates an instance of the {@link ControllerNodeInfo.Builder} avoiding the
         * need to create one manually via {@link ControllerNodeInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ControllerNodeInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #controllerNodeInfo(ControllerNodeInfo)}.
         * 
         * @param controllerNodeInfo
         *        a consumer that will call methods on {@link ControllerNodeInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #controllerNodeInfo(ControllerNodeInfo)
         */
        default Builder controllerNodeInfo(Consumer<ControllerNodeInfo.Builder> controllerNodeInfo) {
            return controllerNodeInfo(ControllerNodeInfo.builder().applyMutation(controllerNodeInfo).build());
        }

        /**
         *
         * <p>
         * The instance type.
         * </p>
         * 
         * @param instanceType
         *        <p>
         *        The instance type.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         *
         * <p>
         * The Amazon Resource Name (ARN) of the node.
         * </p>
         * 
         * @param nodeARN
         *        <p>
         *        The Amazon Resource Name (ARN) of the node.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeARN(String nodeARN);

        /**
         *
         * <p>
         * The node type.
         * </p>
         * 
         * @param nodeType
         *        <p>
         *        The node type.
         *        </p>
         * @see NodeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NodeType
         */
        Builder nodeType(String nodeType);

        /**
         *
         * <p>
         * The node type.
         * </p>
         * 
         * @param nodeType
         *        <p>
         *        The node type.
         *        </p>
         * @see NodeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NodeType
         */
        Builder nodeType(NodeType nodeType);

        /**
         *
         * <p>
         * The ZookeeperNodeInfo.
         * </p>
         * 
         * @param zookeeperNodeInfo
         *        <p>
         *        The ZookeeperNodeInfo.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zookeeperNodeInfo(ZookeeperNodeInfo zookeeperNodeInfo);

        /**
         *
         * <p>
         * The ZookeeperNodeInfo.
         * </p>
         * 
         * This is a convenience method that creates an instance of the {@link ZookeeperNodeInfo.Builder} avoiding the
         * need to create one manually via {@link ZookeeperNodeInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ZookeeperNodeInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #zookeeperNodeInfo(ZookeeperNodeInfo)}.
         * 
         * @param zookeeperNodeInfo
         *        a consumer that will call methods on {@link ZookeeperNodeInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #zookeeperNodeInfo(ZookeeperNodeInfo)
         */
        default Builder zookeeperNodeInfo(Consumer<ZookeeperNodeInfo.Builder> zookeeperNodeInfo) {
            return zookeeperNodeInfo(ZookeeperNodeInfo.builder().applyMutation(zookeeperNodeInfo).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String addedToClusterTime;

        private BrokerNodeInfo brokerNodeInfo;

        private ControllerNodeInfo controllerNodeInfo;

        private String instanceType;

        private String nodeARN;

        private String nodeType;

        private ZookeeperNodeInfo zookeeperNodeInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(NodeInfo model) {
            addedToClusterTime(model.addedToClusterTime);
            brokerNodeInfo(model.brokerNodeInfo);
            controllerNodeInfo(model.controllerNodeInfo);
            instanceType(model.instanceType);
            nodeARN(model.nodeARN);
            nodeType(model.nodeType);
            zookeeperNodeInfo(model.zookeeperNodeInfo);
        }

        public final String getAddedToClusterTime() {
            return addedToClusterTime;
        }

        public final void setAddedToClusterTime(String addedToClusterTime) {
            this.addedToClusterTime = addedToClusterTime;
        }

        @Override
        public final Builder addedToClusterTime(String addedToClusterTime) {
            this.addedToClusterTime = addedToClusterTime;
            return this;
        }

        public final BrokerNodeInfo.Builder getBrokerNodeInfo() {
            return brokerNodeInfo != null ? brokerNodeInfo.toBuilder() : null;
        }

        public final void setBrokerNodeInfo(BrokerNodeInfo.BuilderImpl brokerNodeInfo) {
            this.brokerNodeInfo = brokerNodeInfo != null ? brokerNodeInfo.build() : null;
        }

        @Override
        public final Builder brokerNodeInfo(BrokerNodeInfo brokerNodeInfo) {
            this.brokerNodeInfo = brokerNodeInfo;
            return this;
        }

        public final ControllerNodeInfo.Builder getControllerNodeInfo() {
            return controllerNodeInfo != null ? controllerNodeInfo.toBuilder() : null;
        }

        public final void setControllerNodeInfo(ControllerNodeInfo.BuilderImpl controllerNodeInfo) {
            this.controllerNodeInfo = controllerNodeInfo != null ? controllerNodeInfo.build() : null;
        }

        @Override
        public final Builder controllerNodeInfo(ControllerNodeInfo controllerNodeInfo) {
            this.controllerNodeInfo = controllerNodeInfo;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getNodeARN() {
            return nodeARN;
        }

        public final void setNodeARN(String nodeARN) {
            this.nodeARN = nodeARN;
        }

        @Override
        public final Builder nodeARN(String nodeARN) {
            this.nodeARN = nodeARN;
            return this;
        }

        public final String getNodeType() {
            return nodeType;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        @Override
        public final Builder nodeType(NodeType nodeType) {
            this.nodeType(nodeType == null ? null : nodeType.toString());
            return this;
        }

        public final ZookeeperNodeInfo.Builder getZookeeperNodeInfo() {
            return zookeeperNodeInfo != null ? zookeeperNodeInfo.toBuilder() : null;
        }

        public final void setZookeeperNodeInfo(ZookeeperNodeInfo.BuilderImpl zookeeperNodeInfo) {
            this.zookeeperNodeInfo = zookeeperNodeInfo != null ? zookeeperNodeInfo.build() : null;
        }

        @Override
        public final Builder zookeeperNodeInfo(ZookeeperNodeInfo zookeeperNodeInfo) {
            this.zookeeperNodeInfo = zookeeperNodeInfo;
            return this;
        }

        @Override
        public NodeInfo build() {
            return new NodeInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
