/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 *
 * <p>
 * Returns information about a cluster.
 * </p>
 * 
 */
@Generated("software.amazon.awssdk:codegen")
public final class Cluster implements SdkPojo, Serializable, ToCopyableBuilder<Cluster.Builder, Cluster> {
    private static final SdkField<String> ACTIVE_OPERATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActiveOperationArn").getter(getter(Cluster::activeOperationArn))
            .setter(setter(Builder::activeOperationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeOperationArn").build())
            .build();

    private static final SdkField<String> CLUSTER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterType").getter(getter(Cluster::clusterTypeAsString)).setter(setter(Builder::clusterType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterType").build()).build();

    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterArn").getter(getter(Cluster::clusterArn)).setter(setter(Builder::clusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterArn").build()).build();

    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterName").getter(getter(Cluster::clusterName)).setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterName").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime")
            .getter(getter(Cluster::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> CURRENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrentVersion").getter(getter(Cluster::currentVersion)).setter(setter(Builder::currentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentVersion").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(Cluster::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<StateInfo> STATE_INFO_FIELD = SdkField.<StateInfo> builder(MarshallingType.SDK_POJO)
            .memberName("StateInfo").getter(getter(Cluster::stateInfo)).setter(setter(Builder::stateInfo))
            .constructor(StateInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateInfo").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(Cluster::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Provisioned> PROVISIONED_FIELD = SdkField.<Provisioned> builder(MarshallingType.SDK_POJO)
            .memberName("Provisioned").getter(getter(Cluster::provisioned)).setter(setter(Builder::provisioned))
            .constructor(Provisioned::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisioned").build()).build();

    private static final SdkField<Serverless> SERVERLESS_FIELD = SdkField.<Serverless> builder(MarshallingType.SDK_POJO)
            .memberName("Serverless").getter(getter(Cluster::serverless)).setter(setter(Builder::serverless))
            .constructor(Serverless::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverless").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVE_OPERATION_ARN_FIELD,
            CLUSTER_TYPE_FIELD, CLUSTER_ARN_FIELD, CLUSTER_NAME_FIELD, CREATION_TIME_FIELD, CURRENT_VERSION_FIELD, STATE_FIELD,
            STATE_INFO_FIELD, TAGS_FIELD, PROVISIONED_FIELD, SERVERLESS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String activeOperationArn;

    private final String clusterType;

    private final String clusterArn;

    private final String clusterName;

    private final Instant creationTime;

    private final String currentVersion;

    private final String state;

    private final StateInfo stateInfo;

    private final Map<String, String> tags;

    private final Provisioned provisioned;

    private final Serverless serverless;

    private Cluster(BuilderImpl builder) {
        this.activeOperationArn = builder.activeOperationArn;
        this.clusterType = builder.clusterType;
        this.clusterArn = builder.clusterArn;
        this.clusterName = builder.clusterName;
        this.creationTime = builder.creationTime;
        this.currentVersion = builder.currentVersion;
        this.state = builder.state;
        this.stateInfo = builder.stateInfo;
        this.tags = builder.tags;
        this.provisioned = builder.provisioned;
        this.serverless = builder.serverless;
    }

    /**
     *
     * <p>
     * The Amazon Resource Name (ARN) that uniquely identifies a cluster operation.
     * </p>
     * 
     * @return <p>
     *         The Amazon Resource Name (ARN) that uniquely identifies a cluster operation.
     *         </p>
     */
    public final String activeOperationArn() {
        return activeOperationArn;
    }

    /**
     *
     * <p>
     * Cluster Type.
     * </p>
     * 
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #clusterType} will
     * return {@link ClusterType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #clusterTypeAsString}.
     * </p>
     * 
     * @return <p>
     *         Cluster Type.
     *         </p>
     * @see ClusterType
     */
    public final ClusterType clusterType() {
        return ClusterType.fromValue(clusterType);
    }

    /**
     *
     * <p>
     * Cluster Type.
     * </p>
     * 
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #clusterType} will
     * return {@link ClusterType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #clusterTypeAsString}.
     * </p>
     * 
     * @return <p>
     *         Cluster Type.
     *         </p>
     * @see ClusterType
     */
    public final String clusterTypeAsString() {
        return clusterType;
    }

    /**
     *
     * <p>
     * The Amazon Resource Name (ARN) that uniquely identifies the cluster.
     * </p>
     * 
     * @return <p>
     *         The Amazon Resource Name (ARN) that uniquely identifies the cluster.
     *         </p>
     */
    public final String clusterArn() {
        return clusterArn;
    }

    /**
     *
     * <p>
     * The name of the cluster.
     * </p>
     * 
     * @return <p>
     *         The name of the cluster.
     *         </p>
     */
    public final String clusterName() {
        return clusterName;
    }

    /**
     *
     * <p>
     * The time when the cluster was created.
     * </p>
     * 
     * @return <p>
     *         The time when the cluster was created.
     *         </p>
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     *
     * <p>
     * The current version of the MSK cluster.
     * </p>
     * 
     * @return <p>
     *         The current version of the MSK cluster.
     *         </p>
     */
    public final String currentVersion() {
        return currentVersion;
    }

    /**
     *
     * <p>
     * The state of the cluster. The possible states are ACTIVE, CREATING, DELETING, FAILED, HEALING, MAINTENANCE,
     * REBOOTING_BROKER, and UPDATING.
     * </p>
     * 
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ClusterState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return <p>
     *         The state of the cluster. The possible states are ACTIVE, CREATING, DELETING, FAILED, HEALING,
     *         MAINTENANCE, REBOOTING_BROKER, and UPDATING.
     *         </p>
     * @see ClusterState
     */
    public final ClusterState state() {
        return ClusterState.fromValue(state);
    }

    /**
     *
     * <p>
     * The state of the cluster. The possible states are ACTIVE, CREATING, DELETING, FAILED, HEALING, MAINTENANCE,
     * REBOOTING_BROKER, and UPDATING.
     * </p>
     * 
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ClusterState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return <p>
     *         The state of the cluster. The possible states are ACTIVE, CREATING, DELETING, FAILED, HEALING,
     *         MAINTENANCE, REBOOTING_BROKER, and UPDATING.
     *         </p>
     * @see ClusterState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     *
     * <p>
     * State Info for the Amazon MSK cluster.
     * </p>
     * 
     * @return <p>
     *         State Info for the Amazon MSK cluster.
     *         </p>
     */
    public final StateInfo stateInfo() {
        return stateInfo;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     *
     * <p>
     * Tags attached to the cluster.
     * </p>
     * 
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return <p>
     *         Tags attached to the cluster.
     *         </p>
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     *
     * <p>
     * Information about the provisioned cluster.
     * </p>
     * 
     * @return <p>
     *         Information about the provisioned cluster.
     *         </p>
     */
    public final Provisioned provisioned() {
        return provisioned;
    }

    /**
     *
     * <p>
     * Information about the serverless cluster.
     * </p>
     * 
     * @return <p>
     *         Information about the serverless cluster.
     *         </p>
     */
    public final Serverless serverless() {
        return serverless;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(activeOperationArn());
        hashCode = 31 * hashCode + Objects.hashCode(clusterTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(currentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateInfo());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(provisioned());
        hashCode = 31 * hashCode + Objects.hashCode(serverless());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cluster)) {
            return false;
        }
        Cluster other = (Cluster) obj;
        return Objects.equals(activeOperationArn(), other.activeOperationArn())
                && Objects.equals(clusterTypeAsString(), other.clusterTypeAsString())
                && Objects.equals(clusterArn(), other.clusterArn()) && Objects.equals(clusterName(), other.clusterName())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(currentVersion(), other.currentVersion())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(stateInfo(), other.stateInfo())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(provisioned(), other.provisioned()) && Objects.equals(serverless(), other.serverless());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Cluster").add("ActiveOperationArn", activeOperationArn())
                .add("ClusterType", clusterTypeAsString()).add("ClusterArn", clusterArn()).add("ClusterName", clusterName())
                .add("CreationTime", creationTime()).add("CurrentVersion", currentVersion()).add("State", stateAsString())
                .add("StateInfo", stateInfo()).add("Tags", hasTags() ? tags() : null).add("Provisioned", provisioned())
                .add("Serverless", serverless()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActiveOperationArn":
            return Optional.ofNullable(clazz.cast(activeOperationArn()));
        case "ClusterType":
            return Optional.ofNullable(clazz.cast(clusterTypeAsString()));
        case "ClusterArn":
            return Optional.ofNullable(clazz.cast(clusterArn()));
        case "ClusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "CurrentVersion":
            return Optional.ofNullable(clazz.cast(currentVersion()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "StateInfo":
            return Optional.ofNullable(clazz.cast(stateInfo()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "Provisioned":
            return Optional.ofNullable(clazz.cast(provisioned()));
        case "Serverless":
            return Optional.ofNullable(clazz.cast(serverless()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("activeOperationArn", ACTIVE_OPERATION_ARN_FIELD);
        map.put("clusterType", CLUSTER_TYPE_FIELD);
        map.put("clusterArn", CLUSTER_ARN_FIELD);
        map.put("clusterName", CLUSTER_NAME_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("currentVersion", CURRENT_VERSION_FIELD);
        map.put("state", STATE_FIELD);
        map.put("stateInfo", STATE_INFO_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("provisioned", PROVISIONED_FIELD);
        map.put("serverless", SERVERLESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Cluster, T> g) {
        return obj -> g.apply((Cluster) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Cluster> {
        /**
         *
         * <p>
         * The Amazon Resource Name (ARN) that uniquely identifies a cluster operation.
         * </p>
         * 
         * @param activeOperationArn
         *        <p>
         *        The Amazon Resource Name (ARN) that uniquely identifies a cluster operation.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeOperationArn(String activeOperationArn);

        /**
         *
         * <p>
         * Cluster Type.
         * </p>
         * 
         * @param clusterType
         *        <p>
         *        Cluster Type.
         *        </p>
         * @see ClusterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterType
         */
        Builder clusterType(String clusterType);

        /**
         *
         * <p>
         * Cluster Type.
         * </p>
         * 
         * @param clusterType
         *        <p>
         *        Cluster Type.
         *        </p>
         * @see ClusterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterType
         */
        Builder clusterType(ClusterType clusterType);

        /**
         *
         * <p>
         * The Amazon Resource Name (ARN) that uniquely identifies the cluster.
         * </p>
         * 
         * @param clusterArn
         *        <p>
         *        The Amazon Resource Name (ARN) that uniquely identifies the cluster.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterArn(String clusterArn);

        /**
         *
         * <p>
         * The name of the cluster.
         * </p>
         * 
         * @param clusterName
         *        <p>
         *        The name of the cluster.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         *
         * <p>
         * The time when the cluster was created.
         * </p>
         * 
         * @param creationTime
         *        <p>
         *        The time when the cluster was created.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         *
         * <p>
         * The current version of the MSK cluster.
         * </p>
         * 
         * @param currentVersion
         *        <p>
         *        The current version of the MSK cluster.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentVersion(String currentVersion);

        /**
         *
         * <p>
         * The state of the cluster. The possible states are ACTIVE, CREATING, DELETING, FAILED, HEALING, MAINTENANCE,
         * REBOOTING_BROKER, and UPDATING.
         * </p>
         * 
         * @param state
         *        <p>
         *        The state of the cluster. The possible states are ACTIVE, CREATING, DELETING, FAILED, HEALING,
         *        MAINTENANCE, REBOOTING_BROKER, and UPDATING.
         *        </p>
         * @see ClusterState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterState
         */
        Builder state(String state);

        /**
         *
         * <p>
         * The state of the cluster. The possible states are ACTIVE, CREATING, DELETING, FAILED, HEALING, MAINTENANCE,
         * REBOOTING_BROKER, and UPDATING.
         * </p>
         * 
         * @param state
         *        <p>
         *        The state of the cluster. The possible states are ACTIVE, CREATING, DELETING, FAILED, HEALING,
         *        MAINTENANCE, REBOOTING_BROKER, and UPDATING.
         *        </p>
         * @see ClusterState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterState
         */
        Builder state(ClusterState state);

        /**
         *
         * <p>
         * State Info for the Amazon MSK cluster.
         * </p>
         * 
         * @param stateInfo
         *        <p>
         *        State Info for the Amazon MSK cluster.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateInfo(StateInfo stateInfo);

        /**
         *
         * <p>
         * State Info for the Amazon MSK cluster.
         * </p>
         * 
         * This is a convenience method that creates an instance of the {@link StateInfo.Builder} avoiding the need to
         * create one manually via {@link StateInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StateInfo.Builder#build()} is called immediately and its result
         * is passed to {@link #stateInfo(StateInfo)}.
         * 
         * @param stateInfo
         *        a consumer that will call methods on {@link StateInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stateInfo(StateInfo)
         */
        default Builder stateInfo(Consumer<StateInfo.Builder> stateInfo) {
            return stateInfo(StateInfo.builder().applyMutation(stateInfo).build());
        }

        /**
         *
         * <p>
         * Tags attached to the cluster.
         * </p>
         * 
         * @param tags
         *        <p>
         *        Tags attached to the cluster.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         *
         * <p>
         * Information about the provisioned cluster.
         * </p>
         * 
         * @param provisioned
         *        <p>
         *        Information about the provisioned cluster.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioned(Provisioned provisioned);

        /**
         *
         * <p>
         * Information about the provisioned cluster.
         * </p>
         * 
         * This is a convenience method that creates an instance of the {@link Provisioned.Builder} avoiding the need to
         * create one manually via {@link Provisioned#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Provisioned.Builder#build()} is called immediately and its result
         * is passed to {@link #provisioned(Provisioned)}.
         * 
         * @param provisioned
         *        a consumer that will call methods on {@link Provisioned.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisioned(Provisioned)
         */
        default Builder provisioned(Consumer<Provisioned.Builder> provisioned) {
            return provisioned(Provisioned.builder().applyMutation(provisioned).build());
        }

        /**
         *
         * <p>
         * Information about the serverless cluster.
         * </p>
         * 
         * @param serverless
         *        <p>
         *        Information about the serverless cluster.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverless(Serverless serverless);

        /**
         *
         * <p>
         * Information about the serverless cluster.
         * </p>
         * 
         * This is a convenience method that creates an instance of the {@link Serverless.Builder} avoiding the need to
         * create one manually via {@link Serverless#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Serverless.Builder#build()} is called immediately and its result
         * is passed to {@link #serverless(Serverless)}.
         * 
         * @param serverless
         *        a consumer that will call methods on {@link Serverless.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serverless(Serverless)
         */
        default Builder serverless(Consumer<Serverless.Builder> serverless) {
            return serverless(Serverless.builder().applyMutation(serverless).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String activeOperationArn;

        private String clusterType;

        private String clusterArn;

        private String clusterName;

        private Instant creationTime;

        private String currentVersion;

        private String state;

        private StateInfo stateInfo;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private Provisioned provisioned;

        private Serverless serverless;

        private BuilderImpl() {
        }

        private BuilderImpl(Cluster model) {
            activeOperationArn(model.activeOperationArn);
            clusterType(model.clusterType);
            clusterArn(model.clusterArn);
            clusterName(model.clusterName);
            creationTime(model.creationTime);
            currentVersion(model.currentVersion);
            state(model.state);
            stateInfo(model.stateInfo);
            tags(model.tags);
            provisioned(model.provisioned);
            serverless(model.serverless);
        }

        public final String getActiveOperationArn() {
            return activeOperationArn;
        }

        public final void setActiveOperationArn(String activeOperationArn) {
            this.activeOperationArn = activeOperationArn;
        }

        @Override
        public final Builder activeOperationArn(String activeOperationArn) {
            this.activeOperationArn = activeOperationArn;
            return this;
        }

        public final String getClusterType() {
            return clusterType;
        }

        public final void setClusterType(String clusterType) {
            this.clusterType = clusterType;
        }

        @Override
        public final Builder clusterType(String clusterType) {
            this.clusterType = clusterType;
            return this;
        }

        @Override
        public final Builder clusterType(ClusterType clusterType) {
            this.clusterType(clusterType == null ? null : clusterType.toString());
            return this;
        }

        public final String getClusterArn() {
            return clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final String getClusterName() {
            return clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getCurrentVersion() {
            return currentVersion;
        }

        public final void setCurrentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
        }

        @Override
        public final Builder currentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ClusterState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final StateInfo.Builder getStateInfo() {
            return stateInfo != null ? stateInfo.toBuilder() : null;
        }

        public final void setStateInfo(StateInfo.BuilderImpl stateInfo) {
            this.stateInfo = stateInfo != null ? stateInfo.build() : null;
        }

        @Override
        public final Builder stateInfo(StateInfo stateInfo) {
            this.stateInfo = stateInfo;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
            return this;
        }

        public final Provisioned.Builder getProvisioned() {
            return provisioned != null ? provisioned.toBuilder() : null;
        }

        public final void setProvisioned(Provisioned.BuilderImpl provisioned) {
            this.provisioned = provisioned != null ? provisioned.build() : null;
        }

        @Override
        public final Builder provisioned(Provisioned provisioned) {
            this.provisioned = provisioned;
            return this;
        }

        public final Serverless.Builder getServerless() {
            return serverless != null ? serverless.toBuilder() : null;
        }

        public final void setServerless(Serverless.BuilderImpl serverless) {
            this.serverless = serverless != null ? serverless.build() : null;
        }

        @Override
        public final Builder serverless(Serverless serverless) {
            this.serverless = serverless;
            return this;
        }

        @Override
        public Cluster build() {
            return new Cluster(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
