/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kafka.model.Cluster;
import software.amazon.awssdk.services.kafka.model.KafkaResponse;
import software.amazon.awssdk.services.kafka.model.___listOfClusterCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListClustersV2Response
extends KafkaResponse
implements ToCopyableBuilder<Builder, ListClustersV2Response> {
    private static final SdkField<List<Cluster>> CLUSTER_INFO_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ClusterInfoList").getter(ListClustersV2Response.getter(ListClustersV2Response::clusterInfoList)).setter(ListClustersV2Response.setter(Builder::clusterInfoList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterInfoList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Cluster::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListClustersV2Response.getter(ListClustersV2Response::nextToken)).setter(ListClustersV2Response.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_INFO_LIST_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListClustersV2Response.memberNameToFieldInitializer();
    private final List<Cluster> clusterInfoList;
    private final String nextToken;

    private ListClustersV2Response(BuilderImpl builder) {
        super(builder);
        this.clusterInfoList = builder.clusterInfoList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasClusterInfoList() {
        return this.clusterInfoList != null && !(this.clusterInfoList instanceof SdkAutoConstructList);
    }

    public final List<Cluster> clusterInfoList() {
        return this.clusterInfoList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClusterInfoList() ? this.clusterInfoList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListClustersV2Response)) {
            return false;
        }
        ListClustersV2Response other = (ListClustersV2Response)((Object)obj);
        return this.hasClusterInfoList() == other.hasClusterInfoList() && Objects.equals(this.clusterInfoList(), other.clusterInfoList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListClustersV2Response").add("ClusterInfoList", this.hasClusterInfoList() ? this.clusterInfoList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterInfoList": {
                return Optional.ofNullable(clazz.cast(this.clusterInfoList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clusterInfoList", CLUSTER_INFO_LIST_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListClustersV2Response, T> g) {
        return obj -> g.apply((ListClustersV2Response)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KafkaResponse.BuilderImpl
    implements Builder {
        private List<Cluster> clusterInfoList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListClustersV2Response model) {
            super(model);
            this.clusterInfoList(model.clusterInfoList);
            this.nextToken(model.nextToken);
        }

        public final List<Cluster.Builder> getClusterInfoList() {
            List<Cluster.Builder> result = ___listOfClusterCopier.copyToBuilder(this.clusterInfoList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClusterInfoList(Collection<Cluster.BuilderImpl> clusterInfoList) {
            this.clusterInfoList = ___listOfClusterCopier.copyFromBuilder(clusterInfoList);
        }

        @Override
        public final Builder clusterInfoList(Collection<Cluster> clusterInfoList) {
            this.clusterInfoList = ___listOfClusterCopier.copy(clusterInfoList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterInfoList(Cluster ... clusterInfoList) {
            this.clusterInfoList(Arrays.asList(clusterInfoList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterInfoList(Consumer<Cluster.Builder> ... clusterInfoList) {
            this.clusterInfoList(Stream.of(clusterInfoList).map(c -> (Cluster)((Cluster.Builder)Cluster.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListClustersV2Response build() {
            return new ListClustersV2Response(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends KafkaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListClustersV2Response> {
        public Builder clusterInfoList(Collection<Cluster> var1);

        public Builder clusterInfoList(Cluster ... var1);

        public Builder clusterInfoList(Consumer<Cluster.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

