/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kafka.model.ConsumerGroupReplicationUpdate;
import software.amazon.awssdk.services.kafka.model.KafkaRequest;
import software.amazon.awssdk.services.kafka.model.TopicReplicationUpdate;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateReplicationInfoRequest
extends KafkaRequest
implements ToCopyableBuilder<Builder, UpdateReplicationInfoRequest> {
    private static final SdkField<ConsumerGroupReplicationUpdate> CONSUMER_GROUP_REPLICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConsumerGroupReplication").getter(UpdateReplicationInfoRequest.getter(UpdateReplicationInfoRequest::consumerGroupReplication)).setter(UpdateReplicationInfoRequest.setter(Builder::consumerGroupReplication)).constructor(ConsumerGroupReplicationUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("consumerGroupReplication").build()}).build();
    private static final SdkField<String> CURRENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrentVersion").getter(UpdateReplicationInfoRequest.getter(UpdateReplicationInfoRequest::currentVersion)).setter(UpdateReplicationInfoRequest.setter(Builder::currentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentVersion").build()}).build();
    private static final SdkField<String> REPLICATOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicatorArn").getter(UpdateReplicationInfoRequest.getter(UpdateReplicationInfoRequest::replicatorArn)).setter(UpdateReplicationInfoRequest.setter(Builder::replicatorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("replicatorArn").build()}).build();
    private static final SdkField<String> SOURCE_KAFKA_CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceKafkaClusterArn").getter(UpdateReplicationInfoRequest.getter(UpdateReplicationInfoRequest::sourceKafkaClusterArn)).setter(UpdateReplicationInfoRequest.setter(Builder::sourceKafkaClusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceKafkaClusterArn").build()}).build();
    private static final SdkField<String> TARGET_KAFKA_CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetKafkaClusterArn").getter(UpdateReplicationInfoRequest.getter(UpdateReplicationInfoRequest::targetKafkaClusterArn)).setter(UpdateReplicationInfoRequest.setter(Builder::targetKafkaClusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetKafkaClusterArn").build()}).build();
    private static final SdkField<TopicReplicationUpdate> TOPIC_REPLICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TopicReplication").getter(UpdateReplicationInfoRequest.getter(UpdateReplicationInfoRequest::topicReplication)).setter(UpdateReplicationInfoRequest.setter(Builder::topicReplication)).constructor(TopicReplicationUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topicReplication").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONSUMER_GROUP_REPLICATION_FIELD, CURRENT_VERSION_FIELD, REPLICATOR_ARN_FIELD, SOURCE_KAFKA_CLUSTER_ARN_FIELD, TARGET_KAFKA_CLUSTER_ARN_FIELD, TOPIC_REPLICATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateReplicationInfoRequest.memberNameToFieldInitializer();
    private final ConsumerGroupReplicationUpdate consumerGroupReplication;
    private final String currentVersion;
    private final String replicatorArn;
    private final String sourceKafkaClusterArn;
    private final String targetKafkaClusterArn;
    private final TopicReplicationUpdate topicReplication;

    private UpdateReplicationInfoRequest(BuilderImpl builder) {
        super(builder);
        this.consumerGroupReplication = builder.consumerGroupReplication;
        this.currentVersion = builder.currentVersion;
        this.replicatorArn = builder.replicatorArn;
        this.sourceKafkaClusterArn = builder.sourceKafkaClusterArn;
        this.targetKafkaClusterArn = builder.targetKafkaClusterArn;
        this.topicReplication = builder.topicReplication;
    }

    public final ConsumerGroupReplicationUpdate consumerGroupReplication() {
        return this.consumerGroupReplication;
    }

    public final String currentVersion() {
        return this.currentVersion;
    }

    public final String replicatorArn() {
        return this.replicatorArn;
    }

    public final String sourceKafkaClusterArn() {
        return this.sourceKafkaClusterArn;
    }

    public final String targetKafkaClusterArn() {
        return this.targetKafkaClusterArn;
    }

    public final TopicReplicationUpdate topicReplication() {
        return this.topicReplication;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.consumerGroupReplication());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicatorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceKafkaClusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetKafkaClusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.topicReplication());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateReplicationInfoRequest)) {
            return false;
        }
        UpdateReplicationInfoRequest other = (UpdateReplicationInfoRequest)((Object)obj);
        return Objects.equals(this.consumerGroupReplication(), other.consumerGroupReplication()) && Objects.equals(this.currentVersion(), other.currentVersion()) && Objects.equals(this.replicatorArn(), other.replicatorArn()) && Objects.equals(this.sourceKafkaClusterArn(), other.sourceKafkaClusterArn()) && Objects.equals(this.targetKafkaClusterArn(), other.targetKafkaClusterArn()) && Objects.equals(this.topicReplication(), other.topicReplication());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateReplicationInfoRequest").add("ConsumerGroupReplication", (Object)this.consumerGroupReplication()).add("CurrentVersion", (Object)this.currentVersion()).add("ReplicatorArn", (Object)this.replicatorArn()).add("SourceKafkaClusterArn", (Object)this.sourceKafkaClusterArn()).add("TargetKafkaClusterArn", (Object)this.targetKafkaClusterArn()).add("TopicReplication", (Object)this.topicReplication()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConsumerGroupReplication": {
                return Optional.ofNullable(clazz.cast(this.consumerGroupReplication()));
            }
            case "CurrentVersion": {
                return Optional.ofNullable(clazz.cast(this.currentVersion()));
            }
            case "ReplicatorArn": {
                return Optional.ofNullable(clazz.cast(this.replicatorArn()));
            }
            case "SourceKafkaClusterArn": {
                return Optional.ofNullable(clazz.cast(this.sourceKafkaClusterArn()));
            }
            case "TargetKafkaClusterArn": {
                return Optional.ofNullable(clazz.cast(this.targetKafkaClusterArn()));
            }
            case "TopicReplication": {
                return Optional.ofNullable(clazz.cast(this.topicReplication()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("consumerGroupReplication", CONSUMER_GROUP_REPLICATION_FIELD);
        map.put("currentVersion", CURRENT_VERSION_FIELD);
        map.put("replicatorArn", REPLICATOR_ARN_FIELD);
        map.put("sourceKafkaClusterArn", SOURCE_KAFKA_CLUSTER_ARN_FIELD);
        map.put("targetKafkaClusterArn", TARGET_KAFKA_CLUSTER_ARN_FIELD);
        map.put("topicReplication", TOPIC_REPLICATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateReplicationInfoRequest, T> g) {
        return obj -> g.apply((UpdateReplicationInfoRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KafkaRequest.BuilderImpl
    implements Builder {
        private ConsumerGroupReplicationUpdate consumerGroupReplication;
        private String currentVersion;
        private String replicatorArn;
        private String sourceKafkaClusterArn;
        private String targetKafkaClusterArn;
        private TopicReplicationUpdate topicReplication;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateReplicationInfoRequest model) {
            super(model);
            this.consumerGroupReplication(model.consumerGroupReplication);
            this.currentVersion(model.currentVersion);
            this.replicatorArn(model.replicatorArn);
            this.sourceKafkaClusterArn(model.sourceKafkaClusterArn);
            this.targetKafkaClusterArn(model.targetKafkaClusterArn);
            this.topicReplication(model.topicReplication);
        }

        public final ConsumerGroupReplicationUpdate.Builder getConsumerGroupReplication() {
            return this.consumerGroupReplication != null ? this.consumerGroupReplication.toBuilder() : null;
        }

        public final void setConsumerGroupReplication(ConsumerGroupReplicationUpdate.BuilderImpl consumerGroupReplication) {
            this.consumerGroupReplication = consumerGroupReplication != null ? consumerGroupReplication.build() : null;
        }

        @Override
        public final Builder consumerGroupReplication(ConsumerGroupReplicationUpdate consumerGroupReplication) {
            this.consumerGroupReplication = consumerGroupReplication;
            return this;
        }

        public final String getCurrentVersion() {
            return this.currentVersion;
        }

        public final void setCurrentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
        }

        @Override
        public final Builder currentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
            return this;
        }

        public final String getReplicatorArn() {
            return this.replicatorArn;
        }

        public final void setReplicatorArn(String replicatorArn) {
            this.replicatorArn = replicatorArn;
        }

        @Override
        public final Builder replicatorArn(String replicatorArn) {
            this.replicatorArn = replicatorArn;
            return this;
        }

        public final String getSourceKafkaClusterArn() {
            return this.sourceKafkaClusterArn;
        }

        public final void setSourceKafkaClusterArn(String sourceKafkaClusterArn) {
            this.sourceKafkaClusterArn = sourceKafkaClusterArn;
        }

        @Override
        public final Builder sourceKafkaClusterArn(String sourceKafkaClusterArn) {
            this.sourceKafkaClusterArn = sourceKafkaClusterArn;
            return this;
        }

        public final String getTargetKafkaClusterArn() {
            return this.targetKafkaClusterArn;
        }

        public final void setTargetKafkaClusterArn(String targetKafkaClusterArn) {
            this.targetKafkaClusterArn = targetKafkaClusterArn;
        }

        @Override
        public final Builder targetKafkaClusterArn(String targetKafkaClusterArn) {
            this.targetKafkaClusterArn = targetKafkaClusterArn;
            return this;
        }

        public final TopicReplicationUpdate.Builder getTopicReplication() {
            return this.topicReplication != null ? this.topicReplication.toBuilder() : null;
        }

        public final void setTopicReplication(TopicReplicationUpdate.BuilderImpl topicReplication) {
            this.topicReplication = topicReplication != null ? topicReplication.build() : null;
        }

        @Override
        public final Builder topicReplication(TopicReplicationUpdate topicReplication) {
            this.topicReplication = topicReplication;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateReplicationInfoRequest build() {
            return new UpdateReplicationInfoRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends KafkaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateReplicationInfoRequest> {
        public Builder consumerGroupReplication(ConsumerGroupReplicationUpdate var1);

        default public Builder consumerGroupReplication(Consumer<ConsumerGroupReplicationUpdate.Builder> consumerGroupReplication) {
            return this.consumerGroupReplication((ConsumerGroupReplicationUpdate)((ConsumerGroupReplicationUpdate.Builder)ConsumerGroupReplicationUpdate.builder().applyMutation(consumerGroupReplication)).build());
        }

        public Builder currentVersion(String var1);

        public Builder replicatorArn(String var1);

        public Builder sourceKafkaClusterArn(String var1);

        public Builder targetKafkaClusterArn(String var1);

        public Builder topicReplication(TopicReplicationUpdate var1);

        default public Builder topicReplication(Consumer<TopicReplicationUpdate.Builder> topicReplication) {
            return this.topicReplication((TopicReplicationUpdate)((TopicReplicationUpdate.Builder)TopicReplicationUpdate.builder().applyMutation(topicReplication)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

