/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.kafka.model.KafkaCluster;
import software.amazon.awssdk.services.kafka.model.KafkaRequest;
import software.amazon.awssdk.services.kafka.model.ReplicationInfo;
import software.amazon.awssdk.services.kafka.model.___listOfKafkaClusterCopier;
import software.amazon.awssdk.services.kafka.model.___listOfReplicationInfoCopier;
import software.amazon.awssdk.services.kafka.model.___mapOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateReplicatorRequest
extends KafkaRequest
implements ToCopyableBuilder<Builder, CreateReplicatorRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateReplicatorRequest.getter(CreateReplicatorRequest::description)).setter(CreateReplicatorRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<KafkaCluster>> KAFKA_CLUSTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("KafkaClusters").getter(CreateReplicatorRequest.getter(CreateReplicatorRequest::kafkaClusters)).setter(CreateReplicatorRequest.setter(Builder::kafkaClusters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kafkaClusters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KafkaCluster::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ReplicationInfo>> REPLICATION_INFO_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReplicationInfoList").getter(CreateReplicatorRequest.getter(CreateReplicatorRequest::replicationInfoList)).setter(CreateReplicatorRequest.setter(Builder::replicationInfoList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationInfoList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReplicationInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> REPLICATOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicatorName").getter(CreateReplicatorRequest.getter(CreateReplicatorRequest::replicatorName)).setter(CreateReplicatorRequest.setter(Builder::replicatorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicatorName").build()}).build();
    private static final SdkField<String> SERVICE_EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceExecutionRoleArn").getter(CreateReplicatorRequest.getter(CreateReplicatorRequest::serviceExecutionRoleArn)).setter(CreateReplicatorRequest.setter(Builder::serviceExecutionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceExecutionRoleArn").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateReplicatorRequest.getter(CreateReplicatorRequest::tags)).setter(CreateReplicatorRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, KAFKA_CLUSTERS_FIELD, REPLICATION_INFO_LIST_FIELD, REPLICATOR_NAME_FIELD, SERVICE_EXECUTION_ROLE_ARN_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateReplicatorRequest.memberNameToFieldInitializer();
    private final String description;
    private final List<KafkaCluster> kafkaClusters;
    private final List<ReplicationInfo> replicationInfoList;
    private final String replicatorName;
    private final String serviceExecutionRoleArn;
    private final Map<String, String> tags;

    private CreateReplicatorRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.kafkaClusters = builder.kafkaClusters;
        this.replicationInfoList = builder.replicationInfoList;
        this.replicatorName = builder.replicatorName;
        this.serviceExecutionRoleArn = builder.serviceExecutionRoleArn;
        this.tags = builder.tags;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasKafkaClusters() {
        return this.kafkaClusters != null && !(this.kafkaClusters instanceof SdkAutoConstructList);
    }

    public final List<KafkaCluster> kafkaClusters() {
        return this.kafkaClusters;
    }

    public final boolean hasReplicationInfoList() {
        return this.replicationInfoList != null && !(this.replicationInfoList instanceof SdkAutoConstructList);
    }

    public final List<ReplicationInfo> replicationInfoList() {
        return this.replicationInfoList;
    }

    public final String replicatorName() {
        return this.replicatorName;
    }

    public final String serviceExecutionRoleArn() {
        return this.serviceExecutionRoleArn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKafkaClusters() ? this.kafkaClusters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReplicationInfoList() ? this.replicationInfoList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.replicatorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceExecutionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReplicatorRequest)) {
            return false;
        }
        CreateReplicatorRequest other = (CreateReplicatorRequest)((Object)obj);
        return Objects.equals(this.description(), other.description()) && this.hasKafkaClusters() == other.hasKafkaClusters() && Objects.equals(this.kafkaClusters(), other.kafkaClusters()) && this.hasReplicationInfoList() == other.hasReplicationInfoList() && Objects.equals(this.replicationInfoList(), other.replicationInfoList()) && Objects.equals(this.replicatorName(), other.replicatorName()) && Objects.equals(this.serviceExecutionRoleArn(), other.serviceExecutionRoleArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateReplicatorRequest").add("Description", (Object)this.description()).add("KafkaClusters", this.hasKafkaClusters() ? this.kafkaClusters() : null).add("ReplicationInfoList", this.hasReplicationInfoList() ? this.replicationInfoList() : null).add("ReplicatorName", (Object)this.replicatorName()).add("ServiceExecutionRoleArn", (Object)this.serviceExecutionRoleArn()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "KafkaClusters": {
                return Optional.ofNullable(clazz.cast(this.kafkaClusters()));
            }
            case "ReplicationInfoList": {
                return Optional.ofNullable(clazz.cast(this.replicationInfoList()));
            }
            case "ReplicatorName": {
                return Optional.ofNullable(clazz.cast(this.replicatorName()));
            }
            case "ServiceExecutionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.serviceExecutionRoleArn()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("description", DESCRIPTION_FIELD);
        map.put("kafkaClusters", KAFKA_CLUSTERS_FIELD);
        map.put("replicationInfoList", REPLICATION_INFO_LIST_FIELD);
        map.put("replicatorName", REPLICATOR_NAME_FIELD);
        map.put("serviceExecutionRoleArn", SERVICE_EXECUTION_ROLE_ARN_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateReplicatorRequest, T> g) {
        return obj -> g.apply((CreateReplicatorRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KafkaRequest.BuilderImpl
    implements Builder {
        private String description;
        private List<KafkaCluster> kafkaClusters = DefaultSdkAutoConstructList.getInstance();
        private List<ReplicationInfo> replicationInfoList = DefaultSdkAutoConstructList.getInstance();
        private String replicatorName;
        private String serviceExecutionRoleArn;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReplicatorRequest model) {
            super(model);
            this.description(model.description);
            this.kafkaClusters(model.kafkaClusters);
            this.replicationInfoList(model.replicationInfoList);
            this.replicatorName(model.replicatorName);
            this.serviceExecutionRoleArn(model.serviceExecutionRoleArn);
            this.tags(model.tags);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<KafkaCluster.Builder> getKafkaClusters() {
            List<KafkaCluster.Builder> result = ___listOfKafkaClusterCopier.copyToBuilder(this.kafkaClusters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setKafkaClusters(Collection<KafkaCluster.BuilderImpl> kafkaClusters) {
            this.kafkaClusters = ___listOfKafkaClusterCopier.copyFromBuilder(kafkaClusters);
        }

        @Override
        public final Builder kafkaClusters(Collection<KafkaCluster> kafkaClusters) {
            this.kafkaClusters = ___listOfKafkaClusterCopier.copy(kafkaClusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder kafkaClusters(KafkaCluster ... kafkaClusters) {
            this.kafkaClusters(Arrays.asList(kafkaClusters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder kafkaClusters(Consumer<KafkaCluster.Builder> ... kafkaClusters) {
            this.kafkaClusters(Stream.of(kafkaClusters).map(c -> (KafkaCluster)((KafkaCluster.Builder)KafkaCluster.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ReplicationInfo.Builder> getReplicationInfoList() {
            List<ReplicationInfo.Builder> result = ___listOfReplicationInfoCopier.copyToBuilder(this.replicationInfoList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReplicationInfoList(Collection<ReplicationInfo.BuilderImpl> replicationInfoList) {
            this.replicationInfoList = ___listOfReplicationInfoCopier.copyFromBuilder(replicationInfoList);
        }

        @Override
        public final Builder replicationInfoList(Collection<ReplicationInfo> replicationInfoList) {
            this.replicationInfoList = ___listOfReplicationInfoCopier.copy(replicationInfoList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationInfoList(ReplicationInfo ... replicationInfoList) {
            this.replicationInfoList(Arrays.asList(replicationInfoList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationInfoList(Consumer<ReplicationInfo.Builder> ... replicationInfoList) {
            this.replicationInfoList(Stream.of(replicationInfoList).map(c -> (ReplicationInfo)((ReplicationInfo.Builder)ReplicationInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getReplicatorName() {
            return this.replicatorName;
        }

        public final void setReplicatorName(String replicatorName) {
            this.replicatorName = replicatorName;
        }

        @Override
        public final Builder replicatorName(String replicatorName) {
            this.replicatorName = replicatorName;
            return this;
        }

        public final String getServiceExecutionRoleArn() {
            return this.serviceExecutionRoleArn;
        }

        public final void setServiceExecutionRoleArn(String serviceExecutionRoleArn) {
            this.serviceExecutionRoleArn = serviceExecutionRoleArn;
        }

        @Override
        public final Builder serviceExecutionRoleArn(String serviceExecutionRoleArn) {
            this.serviceExecutionRoleArn = serviceExecutionRoleArn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateReplicatorRequest build() {
            return new CreateReplicatorRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends KafkaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateReplicatorRequest> {
        public Builder description(String var1);

        public Builder kafkaClusters(Collection<KafkaCluster> var1);

        public Builder kafkaClusters(KafkaCluster ... var1);

        public Builder kafkaClusters(Consumer<KafkaCluster.Builder> ... var1);

        public Builder replicationInfoList(Collection<ReplicationInfo> var1);

        public Builder replicationInfoList(ReplicationInfo ... var1);

        public Builder replicationInfoList(Consumer<ReplicationInfo.Builder> ... var1);

        public Builder replicatorName(String var1);

        public Builder serviceExecutionRoleArn(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

