/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kafka.model.BrokerNodeGroupInfo;
import software.amazon.awssdk.services.kafka.model.BrokerSoftwareInfo;
import software.amazon.awssdk.services.kafka.model.ClientAuthentication;
import software.amazon.awssdk.services.kafka.model.CustomerActionStatus;
import software.amazon.awssdk.services.kafka.model.EncryptionInfo;
import software.amazon.awssdk.services.kafka.model.EnhancedMonitoring;
import software.amazon.awssdk.services.kafka.model.LoggingInfo;
import software.amazon.awssdk.services.kafka.model.OpenMonitoringInfo;
import software.amazon.awssdk.services.kafka.model.StorageMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Provisioned
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Provisioned> {
    private static final SdkField<BrokerNodeGroupInfo> BROKER_NODE_GROUP_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BrokerNodeGroupInfo").getter(Provisioned.getter(Provisioned::brokerNodeGroupInfo)).setter(Provisioned.setter(Builder::brokerNodeGroupInfo)).constructor(BrokerNodeGroupInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("brokerNodeGroupInfo").build()}).build();
    private static final SdkField<BrokerSoftwareInfo> CURRENT_BROKER_SOFTWARE_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CurrentBrokerSoftwareInfo").getter(Provisioned.getter(Provisioned::currentBrokerSoftwareInfo)).setter(Provisioned.setter(Builder::currentBrokerSoftwareInfo)).constructor(BrokerSoftwareInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentBrokerSoftwareInfo").build()}).build();
    private static final SdkField<ClientAuthentication> CLIENT_AUTHENTICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ClientAuthentication").getter(Provisioned.getter(Provisioned::clientAuthentication)).setter(Provisioned.setter(Builder::clientAuthentication)).constructor(ClientAuthentication::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientAuthentication").build()}).build();
    private static final SdkField<EncryptionInfo> ENCRYPTION_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EncryptionInfo").getter(Provisioned.getter(Provisioned::encryptionInfo)).setter(Provisioned.setter(Builder::encryptionInfo)).constructor(EncryptionInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionInfo").build()}).build();
    private static final SdkField<String> ENHANCED_MONITORING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EnhancedMonitoring").getter(Provisioned.getter(Provisioned::enhancedMonitoringAsString)).setter(Provisioned.setter(Builder::enhancedMonitoring)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enhancedMonitoring").build()}).build();
    private static final SdkField<OpenMonitoringInfo> OPEN_MONITORING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OpenMonitoring").getter(Provisioned.getter(Provisioned::openMonitoring)).setter(Provisioned.setter(Builder::openMonitoring)).constructor(OpenMonitoringInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openMonitoring").build()}).build();
    private static final SdkField<LoggingInfo> LOGGING_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LoggingInfo").getter(Provisioned.getter(Provisioned::loggingInfo)).setter(Provisioned.setter(Builder::loggingInfo)).constructor(LoggingInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loggingInfo").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_BROKER_NODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfBrokerNodes").getter(Provisioned.getter(Provisioned::numberOfBrokerNodes)).setter(Provisioned.setter(Builder::numberOfBrokerNodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfBrokerNodes").build()}).build();
    private static final SdkField<String> ZOOKEEPER_CONNECT_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ZookeeperConnectString").getter(Provisioned.getter(Provisioned::zookeeperConnectString)).setter(Provisioned.setter(Builder::zookeeperConnectString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("zookeeperConnectString").build()}).build();
    private static final SdkField<String> ZOOKEEPER_CONNECT_STRING_TLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ZookeeperConnectStringTls").getter(Provisioned.getter(Provisioned::zookeeperConnectStringTls)).setter(Provisioned.setter(Builder::zookeeperConnectStringTls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("zookeeperConnectStringTls").build()}).build();
    private static final SdkField<String> STORAGE_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StorageMode").getter(Provisioned.getter(Provisioned::storageModeAsString)).setter(Provisioned.setter(Builder::storageMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageMode").build()}).build();
    private static final SdkField<String> CUSTOMER_ACTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomerActionStatus").getter(Provisioned.getter(Provisioned::customerActionStatusAsString)).setter(Provisioned.setter(Builder::customerActionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerActionStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BROKER_NODE_GROUP_INFO_FIELD, CURRENT_BROKER_SOFTWARE_INFO_FIELD, CLIENT_AUTHENTICATION_FIELD, ENCRYPTION_INFO_FIELD, ENHANCED_MONITORING_FIELD, OPEN_MONITORING_FIELD, LOGGING_INFO_FIELD, NUMBER_OF_BROKER_NODES_FIELD, ZOOKEEPER_CONNECT_STRING_FIELD, ZOOKEEPER_CONNECT_STRING_TLS_FIELD, STORAGE_MODE_FIELD, CUSTOMER_ACTION_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Provisioned.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final BrokerNodeGroupInfo brokerNodeGroupInfo;
    private final BrokerSoftwareInfo currentBrokerSoftwareInfo;
    private final ClientAuthentication clientAuthentication;
    private final EncryptionInfo encryptionInfo;
    private final String enhancedMonitoring;
    private final OpenMonitoringInfo openMonitoring;
    private final LoggingInfo loggingInfo;
    private final Integer numberOfBrokerNodes;
    private final String zookeeperConnectString;
    private final String zookeeperConnectStringTls;
    private final String storageMode;
    private final String customerActionStatus;

    private Provisioned(BuilderImpl builder) {
        this.brokerNodeGroupInfo = builder.brokerNodeGroupInfo;
        this.currentBrokerSoftwareInfo = builder.currentBrokerSoftwareInfo;
        this.clientAuthentication = builder.clientAuthentication;
        this.encryptionInfo = builder.encryptionInfo;
        this.enhancedMonitoring = builder.enhancedMonitoring;
        this.openMonitoring = builder.openMonitoring;
        this.loggingInfo = builder.loggingInfo;
        this.numberOfBrokerNodes = builder.numberOfBrokerNodes;
        this.zookeeperConnectString = builder.zookeeperConnectString;
        this.zookeeperConnectStringTls = builder.zookeeperConnectStringTls;
        this.storageMode = builder.storageMode;
        this.customerActionStatus = builder.customerActionStatus;
    }

    public final BrokerNodeGroupInfo brokerNodeGroupInfo() {
        return this.brokerNodeGroupInfo;
    }

    public final BrokerSoftwareInfo currentBrokerSoftwareInfo() {
        return this.currentBrokerSoftwareInfo;
    }

    public final ClientAuthentication clientAuthentication() {
        return this.clientAuthentication;
    }

    public final EncryptionInfo encryptionInfo() {
        return this.encryptionInfo;
    }

    public final EnhancedMonitoring enhancedMonitoring() {
        return EnhancedMonitoring.fromValue(this.enhancedMonitoring);
    }

    public final String enhancedMonitoringAsString() {
        return this.enhancedMonitoring;
    }

    public final OpenMonitoringInfo openMonitoring() {
        return this.openMonitoring;
    }

    public final LoggingInfo loggingInfo() {
        return this.loggingInfo;
    }

    public final Integer numberOfBrokerNodes() {
        return this.numberOfBrokerNodes;
    }

    public final String zookeeperConnectString() {
        return this.zookeeperConnectString;
    }

    public final String zookeeperConnectStringTls() {
        return this.zookeeperConnectStringTls;
    }

    public final StorageMode storageMode() {
        return StorageMode.fromValue(this.storageMode);
    }

    public final String storageModeAsString() {
        return this.storageMode;
    }

    public final CustomerActionStatus customerActionStatus() {
        return CustomerActionStatus.fromValue(this.customerActionStatus);
    }

    public final String customerActionStatusAsString() {
        return this.customerActionStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.brokerNodeGroupInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentBrokerSoftwareInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientAuthentication());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.enhancedMonitoringAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.openMonitoring());
        hashCode = 31 * hashCode + Objects.hashCode(this.loggingInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfBrokerNodes());
        hashCode = 31 * hashCode + Objects.hashCode(this.zookeeperConnectString());
        hashCode = 31 * hashCode + Objects.hashCode(this.zookeeperConnectStringTls());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerActionStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Provisioned)) {
            return false;
        }
        Provisioned other = (Provisioned)obj;
        return Objects.equals(this.brokerNodeGroupInfo(), other.brokerNodeGroupInfo()) && Objects.equals(this.currentBrokerSoftwareInfo(), other.currentBrokerSoftwareInfo()) && Objects.equals(this.clientAuthentication(), other.clientAuthentication()) && Objects.equals(this.encryptionInfo(), other.encryptionInfo()) && Objects.equals(this.enhancedMonitoringAsString(), other.enhancedMonitoringAsString()) && Objects.equals(this.openMonitoring(), other.openMonitoring()) && Objects.equals(this.loggingInfo(), other.loggingInfo()) && Objects.equals(this.numberOfBrokerNodes(), other.numberOfBrokerNodes()) && Objects.equals(this.zookeeperConnectString(), other.zookeeperConnectString()) && Objects.equals(this.zookeeperConnectStringTls(), other.zookeeperConnectStringTls()) && Objects.equals(this.storageModeAsString(), other.storageModeAsString()) && Objects.equals(this.customerActionStatusAsString(), other.customerActionStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Provisioned").add("BrokerNodeGroupInfo", (Object)this.brokerNodeGroupInfo()).add("CurrentBrokerSoftwareInfo", (Object)this.currentBrokerSoftwareInfo()).add("ClientAuthentication", (Object)this.clientAuthentication()).add("EncryptionInfo", (Object)this.encryptionInfo()).add("EnhancedMonitoring", (Object)this.enhancedMonitoringAsString()).add("OpenMonitoring", (Object)this.openMonitoring()).add("LoggingInfo", (Object)this.loggingInfo()).add("NumberOfBrokerNodes", (Object)this.numberOfBrokerNodes()).add("ZookeeperConnectString", (Object)this.zookeeperConnectString()).add("ZookeeperConnectStringTls", (Object)this.zookeeperConnectStringTls()).add("StorageMode", (Object)this.storageModeAsString()).add("CustomerActionStatus", (Object)this.customerActionStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BrokerNodeGroupInfo": {
                return Optional.ofNullable(clazz.cast(this.brokerNodeGroupInfo()));
            }
            case "CurrentBrokerSoftwareInfo": {
                return Optional.ofNullable(clazz.cast(this.currentBrokerSoftwareInfo()));
            }
            case "ClientAuthentication": {
                return Optional.ofNullable(clazz.cast(this.clientAuthentication()));
            }
            case "EncryptionInfo": {
                return Optional.ofNullable(clazz.cast(this.encryptionInfo()));
            }
            case "EnhancedMonitoring": {
                return Optional.ofNullable(clazz.cast(this.enhancedMonitoringAsString()));
            }
            case "OpenMonitoring": {
                return Optional.ofNullable(clazz.cast(this.openMonitoring()));
            }
            case "LoggingInfo": {
                return Optional.ofNullable(clazz.cast(this.loggingInfo()));
            }
            case "NumberOfBrokerNodes": {
                return Optional.ofNullable(clazz.cast(this.numberOfBrokerNodes()));
            }
            case "ZookeeperConnectString": {
                return Optional.ofNullable(clazz.cast(this.zookeeperConnectString()));
            }
            case "ZookeeperConnectStringTls": {
                return Optional.ofNullable(clazz.cast(this.zookeeperConnectStringTls()));
            }
            case "StorageMode": {
                return Optional.ofNullable(clazz.cast(this.storageModeAsString()));
            }
            case "CustomerActionStatus": {
                return Optional.ofNullable(clazz.cast(this.customerActionStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("brokerNodeGroupInfo", BROKER_NODE_GROUP_INFO_FIELD);
        map.put("currentBrokerSoftwareInfo", CURRENT_BROKER_SOFTWARE_INFO_FIELD);
        map.put("clientAuthentication", CLIENT_AUTHENTICATION_FIELD);
        map.put("encryptionInfo", ENCRYPTION_INFO_FIELD);
        map.put("enhancedMonitoring", ENHANCED_MONITORING_FIELD);
        map.put("openMonitoring", OPEN_MONITORING_FIELD);
        map.put("loggingInfo", LOGGING_INFO_FIELD);
        map.put("numberOfBrokerNodes", NUMBER_OF_BROKER_NODES_FIELD);
        map.put("zookeeperConnectString", ZOOKEEPER_CONNECT_STRING_FIELD);
        map.put("zookeeperConnectStringTls", ZOOKEEPER_CONNECT_STRING_TLS_FIELD);
        map.put("storageMode", STORAGE_MODE_FIELD);
        map.put("customerActionStatus", CUSTOMER_ACTION_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Provisioned, T> g) {
        return obj -> g.apply((Provisioned)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private BrokerNodeGroupInfo brokerNodeGroupInfo;
        private BrokerSoftwareInfo currentBrokerSoftwareInfo;
        private ClientAuthentication clientAuthentication;
        private EncryptionInfo encryptionInfo;
        private String enhancedMonitoring;
        private OpenMonitoringInfo openMonitoring;
        private LoggingInfo loggingInfo;
        private Integer numberOfBrokerNodes;
        private String zookeeperConnectString;
        private String zookeeperConnectStringTls;
        private String storageMode;
        private String customerActionStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(Provisioned model) {
            this.brokerNodeGroupInfo(model.brokerNodeGroupInfo);
            this.currentBrokerSoftwareInfo(model.currentBrokerSoftwareInfo);
            this.clientAuthentication(model.clientAuthentication);
            this.encryptionInfo(model.encryptionInfo);
            this.enhancedMonitoring(model.enhancedMonitoring);
            this.openMonitoring(model.openMonitoring);
            this.loggingInfo(model.loggingInfo);
            this.numberOfBrokerNodes(model.numberOfBrokerNodes);
            this.zookeeperConnectString(model.zookeeperConnectString);
            this.zookeeperConnectStringTls(model.zookeeperConnectStringTls);
            this.storageMode(model.storageMode);
            this.customerActionStatus(model.customerActionStatus);
        }

        public final BrokerNodeGroupInfo.Builder getBrokerNodeGroupInfo() {
            return this.brokerNodeGroupInfo != null ? this.brokerNodeGroupInfo.toBuilder() : null;
        }

        public final void setBrokerNodeGroupInfo(BrokerNodeGroupInfo.BuilderImpl brokerNodeGroupInfo) {
            this.brokerNodeGroupInfo = brokerNodeGroupInfo != null ? brokerNodeGroupInfo.build() : null;
        }

        @Override
        public final Builder brokerNodeGroupInfo(BrokerNodeGroupInfo brokerNodeGroupInfo) {
            this.brokerNodeGroupInfo = brokerNodeGroupInfo;
            return this;
        }

        public final BrokerSoftwareInfo.Builder getCurrentBrokerSoftwareInfo() {
            return this.currentBrokerSoftwareInfo != null ? this.currentBrokerSoftwareInfo.toBuilder() : null;
        }

        public final void setCurrentBrokerSoftwareInfo(BrokerSoftwareInfo.BuilderImpl currentBrokerSoftwareInfo) {
            this.currentBrokerSoftwareInfo = currentBrokerSoftwareInfo != null ? currentBrokerSoftwareInfo.build() : null;
        }

        @Override
        public final Builder currentBrokerSoftwareInfo(BrokerSoftwareInfo currentBrokerSoftwareInfo) {
            this.currentBrokerSoftwareInfo = currentBrokerSoftwareInfo;
            return this;
        }

        public final ClientAuthentication.Builder getClientAuthentication() {
            return this.clientAuthentication != null ? this.clientAuthentication.toBuilder() : null;
        }

        public final void setClientAuthentication(ClientAuthentication.BuilderImpl clientAuthentication) {
            this.clientAuthentication = clientAuthentication != null ? clientAuthentication.build() : null;
        }

        @Override
        public final Builder clientAuthentication(ClientAuthentication clientAuthentication) {
            this.clientAuthentication = clientAuthentication;
            return this;
        }

        public final EncryptionInfo.Builder getEncryptionInfo() {
            return this.encryptionInfo != null ? this.encryptionInfo.toBuilder() : null;
        }

        public final void setEncryptionInfo(EncryptionInfo.BuilderImpl encryptionInfo) {
            this.encryptionInfo = encryptionInfo != null ? encryptionInfo.build() : null;
        }

        @Override
        public final Builder encryptionInfo(EncryptionInfo encryptionInfo) {
            this.encryptionInfo = encryptionInfo;
            return this;
        }

        public final String getEnhancedMonitoring() {
            return this.enhancedMonitoring;
        }

        public final void setEnhancedMonitoring(String enhancedMonitoring) {
            this.enhancedMonitoring = enhancedMonitoring;
        }

        @Override
        public final Builder enhancedMonitoring(String enhancedMonitoring) {
            this.enhancedMonitoring = enhancedMonitoring;
            return this;
        }

        @Override
        public final Builder enhancedMonitoring(EnhancedMonitoring enhancedMonitoring) {
            this.enhancedMonitoring(enhancedMonitoring == null ? null : enhancedMonitoring.toString());
            return this;
        }

        public final OpenMonitoringInfo.Builder getOpenMonitoring() {
            return this.openMonitoring != null ? this.openMonitoring.toBuilder() : null;
        }

        public final void setOpenMonitoring(OpenMonitoringInfo.BuilderImpl openMonitoring) {
            this.openMonitoring = openMonitoring != null ? openMonitoring.build() : null;
        }

        @Override
        public final Builder openMonitoring(OpenMonitoringInfo openMonitoring) {
            this.openMonitoring = openMonitoring;
            return this;
        }

        public final LoggingInfo.Builder getLoggingInfo() {
            return this.loggingInfo != null ? this.loggingInfo.toBuilder() : null;
        }

        public final void setLoggingInfo(LoggingInfo.BuilderImpl loggingInfo) {
            this.loggingInfo = loggingInfo != null ? loggingInfo.build() : null;
        }

        @Override
        public final Builder loggingInfo(LoggingInfo loggingInfo) {
            this.loggingInfo = loggingInfo;
            return this;
        }

        public final Integer getNumberOfBrokerNodes() {
            return this.numberOfBrokerNodes;
        }

        public final void setNumberOfBrokerNodes(Integer numberOfBrokerNodes) {
            this.numberOfBrokerNodes = numberOfBrokerNodes;
        }

        @Override
        public final Builder numberOfBrokerNodes(Integer numberOfBrokerNodes) {
            this.numberOfBrokerNodes = numberOfBrokerNodes;
            return this;
        }

        public final String getZookeeperConnectString() {
            return this.zookeeperConnectString;
        }

        public final void setZookeeperConnectString(String zookeeperConnectString) {
            this.zookeeperConnectString = zookeeperConnectString;
        }

        @Override
        public final Builder zookeeperConnectString(String zookeeperConnectString) {
            this.zookeeperConnectString = zookeeperConnectString;
            return this;
        }

        public final String getZookeeperConnectStringTls() {
            return this.zookeeperConnectStringTls;
        }

        public final void setZookeeperConnectStringTls(String zookeeperConnectStringTls) {
            this.zookeeperConnectStringTls = zookeeperConnectStringTls;
        }

        @Override
        public final Builder zookeeperConnectStringTls(String zookeeperConnectStringTls) {
            this.zookeeperConnectStringTls = zookeeperConnectStringTls;
            return this;
        }

        public final String getStorageMode() {
            return this.storageMode;
        }

        public final void setStorageMode(String storageMode) {
            this.storageMode = storageMode;
        }

        @Override
        public final Builder storageMode(String storageMode) {
            this.storageMode = storageMode;
            return this;
        }

        @Override
        public final Builder storageMode(StorageMode storageMode) {
            this.storageMode(storageMode == null ? null : storageMode.toString());
            return this;
        }

        public final String getCustomerActionStatus() {
            return this.customerActionStatus;
        }

        public final void setCustomerActionStatus(String customerActionStatus) {
            this.customerActionStatus = customerActionStatus;
        }

        @Override
        public final Builder customerActionStatus(String customerActionStatus) {
            this.customerActionStatus = customerActionStatus;
            return this;
        }

        @Override
        public final Builder customerActionStatus(CustomerActionStatus customerActionStatus) {
            this.customerActionStatus(customerActionStatus == null ? null : customerActionStatus.toString());
            return this;
        }

        public Provisioned build() {
            return new Provisioned(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Provisioned> {
        public Builder brokerNodeGroupInfo(BrokerNodeGroupInfo var1);

        default public Builder brokerNodeGroupInfo(Consumer<BrokerNodeGroupInfo.Builder> brokerNodeGroupInfo) {
            return this.brokerNodeGroupInfo((BrokerNodeGroupInfo)((BrokerNodeGroupInfo.Builder)BrokerNodeGroupInfo.builder().applyMutation(brokerNodeGroupInfo)).build());
        }

        public Builder currentBrokerSoftwareInfo(BrokerSoftwareInfo var1);

        default public Builder currentBrokerSoftwareInfo(Consumer<BrokerSoftwareInfo.Builder> currentBrokerSoftwareInfo) {
            return this.currentBrokerSoftwareInfo((BrokerSoftwareInfo)((BrokerSoftwareInfo.Builder)BrokerSoftwareInfo.builder().applyMutation(currentBrokerSoftwareInfo)).build());
        }

        public Builder clientAuthentication(ClientAuthentication var1);

        default public Builder clientAuthentication(Consumer<ClientAuthentication.Builder> clientAuthentication) {
            return this.clientAuthentication((ClientAuthentication)((ClientAuthentication.Builder)ClientAuthentication.builder().applyMutation(clientAuthentication)).build());
        }

        public Builder encryptionInfo(EncryptionInfo var1);

        default public Builder encryptionInfo(Consumer<EncryptionInfo.Builder> encryptionInfo) {
            return this.encryptionInfo((EncryptionInfo)((EncryptionInfo.Builder)EncryptionInfo.builder().applyMutation(encryptionInfo)).build());
        }

        public Builder enhancedMonitoring(String var1);

        public Builder enhancedMonitoring(EnhancedMonitoring var1);

        public Builder openMonitoring(OpenMonitoringInfo var1);

        default public Builder openMonitoring(Consumer<OpenMonitoringInfo.Builder> openMonitoring) {
            return this.openMonitoring((OpenMonitoringInfo)((OpenMonitoringInfo.Builder)OpenMonitoringInfo.builder().applyMutation(openMonitoring)).build());
        }

        public Builder loggingInfo(LoggingInfo var1);

        default public Builder loggingInfo(Consumer<LoggingInfo.Builder> loggingInfo) {
            return this.loggingInfo((LoggingInfo)((LoggingInfo.Builder)LoggingInfo.builder().applyMutation(loggingInfo)).build());
        }

        public Builder numberOfBrokerNodes(Integer var1);

        public Builder zookeeperConnectString(String var1);

        public Builder zookeeperConnectStringTls(String var1);

        public Builder storageMode(String var1);

        public Builder storageMode(StorageMode var1);

        public Builder customerActionStatus(String var1);

        public Builder customerActionStatus(CustomerActionStatus var1);
    }
}

