/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kafka.model.ClusterOperationStep;
import software.amazon.awssdk.services.kafka.model.MutableClusterInfo;
import software.amazon.awssdk.services.kafka.model.VpcConnectionInfo;
import software.amazon.awssdk.services.kafka.model.___listOfClusterOperationStepCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClusterOperationV2Provisioned
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClusterOperationV2Provisioned> {
    private static final SdkField<List<ClusterOperationStep>> OPERATION_STEPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OperationSteps").getter(ClusterOperationV2Provisioned.getter(ClusterOperationV2Provisioned::operationSteps)).setter(ClusterOperationV2Provisioned.setter(Builder::operationSteps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationSteps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ClusterOperationStep::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<MutableClusterInfo> SOURCE_CLUSTER_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceClusterInfo").getter(ClusterOperationV2Provisioned.getter(ClusterOperationV2Provisioned::sourceClusterInfo)).setter(ClusterOperationV2Provisioned.setter(Builder::sourceClusterInfo)).constructor(MutableClusterInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceClusterInfo").build()}).build();
    private static final SdkField<MutableClusterInfo> TARGET_CLUSTER_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TargetClusterInfo").getter(ClusterOperationV2Provisioned.getter(ClusterOperationV2Provisioned::targetClusterInfo)).setter(ClusterOperationV2Provisioned.setter(Builder::targetClusterInfo)).constructor(MutableClusterInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetClusterInfo").build()}).build();
    private static final SdkField<VpcConnectionInfo> VPC_CONNECTION_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcConnectionInfo").getter(ClusterOperationV2Provisioned.getter(ClusterOperationV2Provisioned::vpcConnectionInfo)).setter(ClusterOperationV2Provisioned.setter(Builder::vpcConnectionInfo)).constructor(VpcConnectionInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConnectionInfo").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERATION_STEPS_FIELD, SOURCE_CLUSTER_INFO_FIELD, TARGET_CLUSTER_INFO_FIELD, VPC_CONNECTION_INFO_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("operationSteps", OPERATION_STEPS_FIELD);
            this.put("sourceClusterInfo", SOURCE_CLUSTER_INFO_FIELD);
            this.put("targetClusterInfo", TARGET_CLUSTER_INFO_FIELD);
            this.put("vpcConnectionInfo", VPC_CONNECTION_INFO_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<ClusterOperationStep> operationSteps;
    private final MutableClusterInfo sourceClusterInfo;
    private final MutableClusterInfo targetClusterInfo;
    private final VpcConnectionInfo vpcConnectionInfo;

    private ClusterOperationV2Provisioned(BuilderImpl builder) {
        this.operationSteps = builder.operationSteps;
        this.sourceClusterInfo = builder.sourceClusterInfo;
        this.targetClusterInfo = builder.targetClusterInfo;
        this.vpcConnectionInfo = builder.vpcConnectionInfo;
    }

    public final boolean hasOperationSteps() {
        return this.operationSteps != null && !(this.operationSteps instanceof SdkAutoConstructList);
    }

    public final List<ClusterOperationStep> operationSteps() {
        return this.operationSteps;
    }

    public final MutableClusterInfo sourceClusterInfo() {
        return this.sourceClusterInfo;
    }

    public final MutableClusterInfo targetClusterInfo() {
        return this.targetClusterInfo;
    }

    public final VpcConnectionInfo vpcConnectionInfo() {
        return this.vpcConnectionInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOperationSteps() ? this.operationSteps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceClusterInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetClusterInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConnectionInfo());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterOperationV2Provisioned)) {
            return false;
        }
        ClusterOperationV2Provisioned other = (ClusterOperationV2Provisioned)obj;
        return this.hasOperationSteps() == other.hasOperationSteps() && Objects.equals(this.operationSteps(), other.operationSteps()) && Objects.equals(this.sourceClusterInfo(), other.sourceClusterInfo()) && Objects.equals(this.targetClusterInfo(), other.targetClusterInfo()) && Objects.equals(this.vpcConnectionInfo(), other.vpcConnectionInfo());
    }

    public final String toString() {
        return ToString.builder((String)"ClusterOperationV2Provisioned").add("OperationSteps", this.hasOperationSteps() ? this.operationSteps() : null).add("SourceClusterInfo", (Object)this.sourceClusterInfo()).add("TargetClusterInfo", (Object)this.targetClusterInfo()).add("VpcConnectionInfo", (Object)this.vpcConnectionInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OperationSteps": {
                return Optional.ofNullable(clazz.cast(this.operationSteps()));
            }
            case "SourceClusterInfo": {
                return Optional.ofNullable(clazz.cast(this.sourceClusterInfo()));
            }
            case "TargetClusterInfo": {
                return Optional.ofNullable(clazz.cast(this.targetClusterInfo()));
            }
            case "VpcConnectionInfo": {
                return Optional.ofNullable(clazz.cast(this.vpcConnectionInfo()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ClusterOperationV2Provisioned, T> g) {
        return obj -> g.apply((ClusterOperationV2Provisioned)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ClusterOperationStep> operationSteps = DefaultSdkAutoConstructList.getInstance();
        private MutableClusterInfo sourceClusterInfo;
        private MutableClusterInfo targetClusterInfo;
        private VpcConnectionInfo vpcConnectionInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterOperationV2Provisioned model) {
            this.operationSteps(model.operationSteps);
            this.sourceClusterInfo(model.sourceClusterInfo);
            this.targetClusterInfo(model.targetClusterInfo);
            this.vpcConnectionInfo(model.vpcConnectionInfo);
        }

        public final List<ClusterOperationStep.Builder> getOperationSteps() {
            List<ClusterOperationStep.Builder> result = ___listOfClusterOperationStepCopier.copyToBuilder(this.operationSteps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOperationSteps(Collection<ClusterOperationStep.BuilderImpl> operationSteps) {
            this.operationSteps = ___listOfClusterOperationStepCopier.copyFromBuilder(operationSteps);
        }

        @Override
        public final Builder operationSteps(Collection<ClusterOperationStep> operationSteps) {
            this.operationSteps = ___listOfClusterOperationStepCopier.copy(operationSteps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operationSteps(ClusterOperationStep ... operationSteps) {
            this.operationSteps(Arrays.asList(operationSteps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operationSteps(Consumer<ClusterOperationStep.Builder> ... operationSteps) {
            this.operationSteps(Stream.of(operationSteps).map(c -> (ClusterOperationStep)((ClusterOperationStep.Builder)ClusterOperationStep.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final MutableClusterInfo.Builder getSourceClusterInfo() {
            return this.sourceClusterInfo != null ? this.sourceClusterInfo.toBuilder() : null;
        }

        public final void setSourceClusterInfo(MutableClusterInfo.BuilderImpl sourceClusterInfo) {
            this.sourceClusterInfo = sourceClusterInfo != null ? sourceClusterInfo.build() : null;
        }

        @Override
        public final Builder sourceClusterInfo(MutableClusterInfo sourceClusterInfo) {
            this.sourceClusterInfo = sourceClusterInfo;
            return this;
        }

        public final MutableClusterInfo.Builder getTargetClusterInfo() {
            return this.targetClusterInfo != null ? this.targetClusterInfo.toBuilder() : null;
        }

        public final void setTargetClusterInfo(MutableClusterInfo.BuilderImpl targetClusterInfo) {
            this.targetClusterInfo = targetClusterInfo != null ? targetClusterInfo.build() : null;
        }

        @Override
        public final Builder targetClusterInfo(MutableClusterInfo targetClusterInfo) {
            this.targetClusterInfo = targetClusterInfo;
            return this;
        }

        public final VpcConnectionInfo.Builder getVpcConnectionInfo() {
            return this.vpcConnectionInfo != null ? this.vpcConnectionInfo.toBuilder() : null;
        }

        public final void setVpcConnectionInfo(VpcConnectionInfo.BuilderImpl vpcConnectionInfo) {
            this.vpcConnectionInfo = vpcConnectionInfo != null ? vpcConnectionInfo.build() : null;
        }

        @Override
        public final Builder vpcConnectionInfo(VpcConnectionInfo vpcConnectionInfo) {
            this.vpcConnectionInfo = vpcConnectionInfo;
            return this;
        }

        public ClusterOperationV2Provisioned build() {
            return new ClusterOperationV2Provisioned(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClusterOperationV2Provisioned> {
        public Builder operationSteps(Collection<ClusterOperationStep> var1);

        public Builder operationSteps(ClusterOperationStep ... var1);

        public Builder operationSteps(Consumer<ClusterOperationStep.Builder> ... var1);

        public Builder sourceClusterInfo(MutableClusterInfo var1);

        default public Builder sourceClusterInfo(Consumer<MutableClusterInfo.Builder> sourceClusterInfo) {
            return this.sourceClusterInfo((MutableClusterInfo)((MutableClusterInfo.Builder)MutableClusterInfo.builder().applyMutation(sourceClusterInfo)).build());
        }

        public Builder targetClusterInfo(MutableClusterInfo var1);

        default public Builder targetClusterInfo(Consumer<MutableClusterInfo.Builder> targetClusterInfo) {
            return this.targetClusterInfo((MutableClusterInfo)((MutableClusterInfo.Builder)MutableClusterInfo.builder().applyMutation(targetClusterInfo)).build());
        }

        public Builder vpcConnectionInfo(VpcConnectionInfo var1);

        default public Builder vpcConnectionInfo(Consumer<VpcConnectionInfo.Builder> vpcConnectionInfo) {
            return this.vpcConnectionInfo((VpcConnectionInfo)((VpcConnectionInfo.Builder)VpcConnectionInfo.builder().applyMutation(vpcConnectionInfo)).build());
        }
    }
}

