/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kafka.model.AmazonMskCluster;
import software.amazon.awssdk.services.kafka.model.KafkaClusterClientVpcConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KafkaClusterDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KafkaClusterDescription> {
    private static final SdkField<AmazonMskCluster> AMAZON_MSK_CLUSTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AmazonMskCluster").getter(KafkaClusterDescription.getter(KafkaClusterDescription::amazonMskCluster)).setter(KafkaClusterDescription.setter(Builder::amazonMskCluster)).constructor(AmazonMskCluster::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amazonMskCluster").build()}).build();
    private static final SdkField<String> KAFKA_CLUSTER_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KafkaClusterAlias").getter(KafkaClusterDescription.getter(KafkaClusterDescription::kafkaClusterAlias)).setter(KafkaClusterDescription.setter(Builder::kafkaClusterAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kafkaClusterAlias").build()}).build();
    private static final SdkField<KafkaClusterClientVpcConfig> VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcConfig").getter(KafkaClusterDescription.getter(KafkaClusterDescription::vpcConfig)).setter(KafkaClusterDescription.setter(Builder::vpcConfig)).constructor(KafkaClusterClientVpcConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMAZON_MSK_CLUSTER_FIELD, KAFKA_CLUSTER_ALIAS_FIELD, VPC_CONFIG_FIELD));
    private static final long serialVersionUID = 1L;
    private final AmazonMskCluster amazonMskCluster;
    private final String kafkaClusterAlias;
    private final KafkaClusterClientVpcConfig vpcConfig;

    private KafkaClusterDescription(BuilderImpl builder) {
        this.amazonMskCluster = builder.amazonMskCluster;
        this.kafkaClusterAlias = builder.kafkaClusterAlias;
        this.vpcConfig = builder.vpcConfig;
    }

    public final AmazonMskCluster amazonMskCluster() {
        return this.amazonMskCluster;
    }

    public final String kafkaClusterAlias() {
        return this.kafkaClusterAlias;
    }

    public final KafkaClusterClientVpcConfig vpcConfig() {
        return this.vpcConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.amazonMskCluster());
        hashCode = 31 * hashCode + Objects.hashCode(this.kafkaClusterAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KafkaClusterDescription)) {
            return false;
        }
        KafkaClusterDescription other = (KafkaClusterDescription)obj;
        return Objects.equals(this.amazonMskCluster(), other.amazonMskCluster()) && Objects.equals(this.kafkaClusterAlias(), other.kafkaClusterAlias()) && Objects.equals(this.vpcConfig(), other.vpcConfig());
    }

    public final String toString() {
        return ToString.builder((String)"KafkaClusterDescription").add("AmazonMskCluster", (Object)this.amazonMskCluster()).add("KafkaClusterAlias", (Object)this.kafkaClusterAlias()).add("VpcConfig", (Object)this.vpcConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AmazonMskCluster": {
                return Optional.ofNullable(clazz.cast(this.amazonMskCluster()));
            }
            case "KafkaClusterAlias": {
                return Optional.ofNullable(clazz.cast(this.kafkaClusterAlias()));
            }
            case "VpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KafkaClusterDescription, T> g) {
        return obj -> g.apply((KafkaClusterDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AmazonMskCluster amazonMskCluster;
        private String kafkaClusterAlias;
        private KafkaClusterClientVpcConfig vpcConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(KafkaClusterDescription model) {
            this.amazonMskCluster(model.amazonMskCluster);
            this.kafkaClusterAlias(model.kafkaClusterAlias);
            this.vpcConfig(model.vpcConfig);
        }

        public final AmazonMskCluster.Builder getAmazonMskCluster() {
            return this.amazonMskCluster != null ? this.amazonMskCluster.toBuilder() : null;
        }

        public final void setAmazonMskCluster(AmazonMskCluster.BuilderImpl amazonMskCluster) {
            this.amazonMskCluster = amazonMskCluster != null ? amazonMskCluster.build() : null;
        }

        @Override
        public final Builder amazonMskCluster(AmazonMskCluster amazonMskCluster) {
            this.amazonMskCluster = amazonMskCluster;
            return this;
        }

        public final String getKafkaClusterAlias() {
            return this.kafkaClusterAlias;
        }

        public final void setKafkaClusterAlias(String kafkaClusterAlias) {
            this.kafkaClusterAlias = kafkaClusterAlias;
        }

        @Override
        public final Builder kafkaClusterAlias(String kafkaClusterAlias) {
            this.kafkaClusterAlias = kafkaClusterAlias;
            return this;
        }

        public final KafkaClusterClientVpcConfig.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(KafkaClusterClientVpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(KafkaClusterClientVpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public KafkaClusterDescription build() {
            return new KafkaClusterDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KafkaClusterDescription> {
        public Builder amazonMskCluster(AmazonMskCluster var1);

        default public Builder amazonMskCluster(Consumer<AmazonMskCluster.Builder> amazonMskCluster) {
            return this.amazonMskCluster((AmazonMskCluster)((AmazonMskCluster.Builder)AmazonMskCluster.builder().applyMutation(amazonMskCluster)).build());
        }

        public Builder kafkaClusterAlias(String var1);

        public Builder vpcConfig(KafkaClusterClientVpcConfig var1);

        default public Builder vpcConfig(Consumer<KafkaClusterClientVpcConfig.Builder> vpcConfig) {
            return this.vpcConfig((KafkaClusterClientVpcConfig)((KafkaClusterClientVpcConfig.Builder)KafkaClusterClientVpcConfig.builder().applyMutation(vpcConfig)).build());
        }
    }
}

