/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kafka.model.UserIdentity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VpcConnectionInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VpcConnectionInfo> {
    private static final SdkField<String> VPC_CONNECTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcConnectionArn").getter(VpcConnectionInfo.getter(VpcConnectionInfo::vpcConnectionArn)).setter(VpcConnectionInfo.setter(Builder::vpcConnectionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConnectionArn").build()}).build();
    private static final SdkField<String> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Owner").getter(VpcConnectionInfo.getter(VpcConnectionInfo::owner)).setter(VpcConnectionInfo.setter(Builder::owner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owner").build()}).build();
    private static final SdkField<UserIdentity> USER_IDENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UserIdentity").getter(VpcConnectionInfo.getter(VpcConnectionInfo::userIdentity)).setter(VpcConnectionInfo.setter(Builder::userIdentity)).constructor(UserIdentity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userIdentity").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(VpcConnectionInfo.getter(VpcConnectionInfo::creationTime)).setter(VpcConnectionInfo.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_CONNECTION_ARN_FIELD, OWNER_FIELD, USER_IDENTITY_FIELD, CREATION_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String vpcConnectionArn;
    private final String owner;
    private final UserIdentity userIdentity;
    private final Instant creationTime;

    private VpcConnectionInfo(BuilderImpl builder) {
        this.vpcConnectionArn = builder.vpcConnectionArn;
        this.owner = builder.owner;
        this.userIdentity = builder.userIdentity;
        this.creationTime = builder.creationTime;
    }

    public final String vpcConnectionArn() {
        return this.vpcConnectionArn;
    }

    public final String owner() {
        return this.owner;
    }

    public final UserIdentity userIdentity() {
        return this.userIdentity;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConnectionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.userIdentity());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcConnectionInfo)) {
            return false;
        }
        VpcConnectionInfo other = (VpcConnectionInfo)obj;
        return Objects.equals(this.vpcConnectionArn(), other.vpcConnectionArn()) && Objects.equals(this.owner(), other.owner()) && Objects.equals(this.userIdentity(), other.userIdentity()) && Objects.equals(this.creationTime(), other.creationTime());
    }

    public final String toString() {
        return ToString.builder((String)"VpcConnectionInfo").add("VpcConnectionArn", (Object)this.vpcConnectionArn()).add("Owner", (Object)this.owner()).add("UserIdentity", (Object)this.userIdentity()).add("CreationTime", (Object)this.creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VpcConnectionArn": {
                return Optional.ofNullable(clazz.cast(this.vpcConnectionArn()));
            }
            case "Owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
            case "UserIdentity": {
                return Optional.ofNullable(clazz.cast(this.userIdentity()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VpcConnectionInfo, T> g) {
        return obj -> g.apply((VpcConnectionInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String vpcConnectionArn;
        private String owner;
        private UserIdentity userIdentity;
        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcConnectionInfo model) {
            this.vpcConnectionArn(model.vpcConnectionArn);
            this.owner(model.owner);
            this.userIdentity(model.userIdentity);
            this.creationTime(model.creationTime);
        }

        public final String getVpcConnectionArn() {
            return this.vpcConnectionArn;
        }

        public final void setVpcConnectionArn(String vpcConnectionArn) {
            this.vpcConnectionArn = vpcConnectionArn;
        }

        @Override
        public final Builder vpcConnectionArn(String vpcConnectionArn) {
            this.vpcConnectionArn = vpcConnectionArn;
            return this;
        }

        public final String getOwner() {
            return this.owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final UserIdentity.Builder getUserIdentity() {
            return this.userIdentity != null ? this.userIdentity.toBuilder() : null;
        }

        public final void setUserIdentity(UserIdentity.BuilderImpl userIdentity) {
            this.userIdentity = userIdentity != null ? userIdentity.build() : null;
        }

        @Override
        public final Builder userIdentity(UserIdentity userIdentity) {
            this.userIdentity = userIdentity;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public VpcConnectionInfo build() {
            return new VpcConnectionInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VpcConnectionInfo> {
        public Builder vpcConnectionArn(String var1);

        public Builder owner(String var1);

        public Builder userIdentity(UserIdentity var1);

        default public Builder userIdentity(Consumer<UserIdentity.Builder> userIdentity) {
            return this.userIdentity((UserIdentity)((UserIdentity.Builder)UserIdentity.builder().applyMutation(userIdentity)).build());
        }

        public Builder creationTime(Instant var1);
    }
}

