/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ClusterType {
    PROVISIONED("PROVISIONED"),
    SERVERLESS("SERVERLESS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ClusterType> VALUE_MAP;
    private final String value;

    private ClusterType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ClusterType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ClusterType> knownValues() {
        EnumSet<ClusterType> knownValues = EnumSet.allOf(ClusterType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ClusterType.class, ClusterType::toString);
    }
}

