/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kafka.KafkaAsyncClient;
import software.amazon.awssdk.services.kafka.model.ClientVpcConnection;
import software.amazon.awssdk.services.kafka.model.ListClientVpcConnectionsRequest;
import software.amazon.awssdk.services.kafka.model.ListClientVpcConnectionsResponse;

public class ListClientVpcConnectionsPublisher
implements SdkPublisher<ListClientVpcConnectionsResponse> {
    private final KafkaAsyncClient client;
    private final ListClientVpcConnectionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListClientVpcConnectionsPublisher(KafkaAsyncClient client, ListClientVpcConnectionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListClientVpcConnectionsPublisher(KafkaAsyncClient client, ListClientVpcConnectionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListClientVpcConnectionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListClientVpcConnectionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ClientVpcConnection> clientVpcConnections() {
        Function<ListClientVpcConnectionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.clientVpcConnections() != null) {
                return response.clientVpcConnections().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListClientVpcConnectionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListClientVpcConnectionsResponseFetcher
    implements AsyncPageFetcher<ListClientVpcConnectionsResponse> {
        private ListClientVpcConnectionsResponseFetcher() {
        }

        public boolean hasNextPage(ListClientVpcConnectionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListClientVpcConnectionsResponse> nextPage(ListClientVpcConnectionsResponse previousPage) {
            if (previousPage == null) {
                return ListClientVpcConnectionsPublisher.this.client.listClientVpcConnections(ListClientVpcConnectionsPublisher.this.firstRequest);
            }
            return ListClientVpcConnectionsPublisher.this.client.listClientVpcConnections((ListClientVpcConnectionsRequest)((Object)ListClientVpcConnectionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

