/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kafka.model.KafkaRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListClustersV2Request
extends KafkaRequest
implements ToCopyableBuilder<Builder, ListClustersV2Request> {
    private static final SdkField<String> CLUSTER_NAME_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterNameFilter").getter(ListClustersV2Request.getter(ListClustersV2Request::clusterNameFilter)).setter(ListClustersV2Request.setter(Builder::clusterNameFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("clusterNameFilter").build()}).build();
    private static final SdkField<String> CLUSTER_TYPE_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterTypeFilter").getter(ListClustersV2Request.getter(ListClustersV2Request::clusterTypeFilter)).setter(ListClustersV2Request.setter(Builder::clusterTypeFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("clusterTypeFilter").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListClustersV2Request.getter(ListClustersV2Request::maxResults)).setter(ListClustersV2Request.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListClustersV2Request.getter(ListClustersV2Request::nextToken)).setter(ListClustersV2Request.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FILTER_FIELD, CLUSTER_TYPE_FILTER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final String clusterNameFilter;
    private final String clusterTypeFilter;
    private final Integer maxResults;
    private final String nextToken;

    private ListClustersV2Request(BuilderImpl builder) {
        super(builder);
        this.clusterNameFilter = builder.clusterNameFilter;
        this.clusterTypeFilter = builder.clusterTypeFilter;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String clusterNameFilter() {
        return this.clusterNameFilter;
    }

    public final String clusterTypeFilter() {
        return this.clusterTypeFilter;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterNameFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterTypeFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListClustersV2Request)) {
            return false;
        }
        ListClustersV2Request other = (ListClustersV2Request)((Object)obj);
        return Objects.equals(this.clusterNameFilter(), other.clusterNameFilter()) && Objects.equals(this.clusterTypeFilter(), other.clusterTypeFilter()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListClustersV2Request").add("ClusterNameFilter", (Object)this.clusterNameFilter()).add("ClusterTypeFilter", (Object)this.clusterTypeFilter()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterNameFilter": {
                return Optional.ofNullable(clazz.cast(this.clusterNameFilter()));
            }
            case "ClusterTypeFilter": {
                return Optional.ofNullable(clazz.cast(this.clusterTypeFilter()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListClustersV2Request, T> g) {
        return obj -> g.apply((ListClustersV2Request)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KafkaRequest.BuilderImpl
    implements Builder {
        private String clusterNameFilter;
        private String clusterTypeFilter;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListClustersV2Request model) {
            super(model);
            this.clusterNameFilter(model.clusterNameFilter);
            this.clusterTypeFilter(model.clusterTypeFilter);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getClusterNameFilter() {
            return this.clusterNameFilter;
        }

        public final void setClusterNameFilter(String clusterNameFilter) {
            this.clusterNameFilter = clusterNameFilter;
        }

        @Override
        public final Builder clusterNameFilter(String clusterNameFilter) {
            this.clusterNameFilter = clusterNameFilter;
            return this;
        }

        public final String getClusterTypeFilter() {
            return this.clusterTypeFilter;
        }

        public final void setClusterTypeFilter(String clusterTypeFilter) {
            this.clusterTypeFilter = clusterTypeFilter;
        }

        @Override
        public final Builder clusterTypeFilter(String clusterTypeFilter) {
            this.clusterTypeFilter = clusterTypeFilter;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListClustersV2Request build() {
            return new ListClustersV2Request(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KafkaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListClustersV2Request> {
        public Builder clusterNameFilter(String var1);

        public Builder clusterTypeFilter(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

