/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum UserIdentityType {
    AWSACCOUNT("AWSACCOUNT"),
    AWSSERVICE("AWSSERVICE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, UserIdentityType> VALUE_MAP;
    private final String value;

    private UserIdentityType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static UserIdentityType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<UserIdentityType> knownValues() {
        EnumSet<UserIdentityType> knownValues = EnumSet.allOf(UserIdentityType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(UserIdentityType.class, UserIdentityType::toString);
    }
}

