/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kafka.KafkaAsyncClient;
import software.amazon.awssdk.services.kafka.model.KafkaVersion;
import software.amazon.awssdk.services.kafka.model.ListKafkaVersionsRequest;
import software.amazon.awssdk.services.kafka.model.ListKafkaVersionsResponse;

public class ListKafkaVersionsPublisher
implements SdkPublisher<ListKafkaVersionsResponse> {
    private final KafkaAsyncClient client;
    private final ListKafkaVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListKafkaVersionsPublisher(KafkaAsyncClient client, ListKafkaVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListKafkaVersionsPublisher(KafkaAsyncClient client, ListKafkaVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListKafkaVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListKafkaVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<KafkaVersion> kafkaVersions() {
        Function<ListKafkaVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.kafkaVersions() != null) {
                return response.kafkaVersions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListKafkaVersionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListKafkaVersionsResponseFetcher
    implements AsyncPageFetcher<ListKafkaVersionsResponse> {
        private ListKafkaVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListKafkaVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListKafkaVersionsResponse> nextPage(ListKafkaVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListKafkaVersionsPublisher.this.client.listKafkaVersions(ListKafkaVersionsPublisher.this.firstRequest);
            }
            return ListKafkaVersionsPublisher.this.client.listKafkaVersions((ListKafkaVersionsRequest)((Object)ListKafkaVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

