/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kafka.model.KafkaResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeConfigurationRevisionResponse
extends KafkaResponse
implements ToCopyableBuilder<Builder, DescribeConfigurationRevisionResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(DescribeConfigurationRevisionResponse.getter(DescribeConfigurationRevisionResponse::arn)).setter(DescribeConfigurationRevisionResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeConfigurationRevisionResponse.getter(DescribeConfigurationRevisionResponse::creationTime)).setter(DescribeConfigurationRevisionResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DescribeConfigurationRevisionResponse.getter(DescribeConfigurationRevisionResponse::description)).setter(DescribeConfigurationRevisionResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Long> REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Revision").getter(DescribeConfigurationRevisionResponse.getter(DescribeConfigurationRevisionResponse::revision)).setter(DescribeConfigurationRevisionResponse.setter(Builder::revision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revision").build()}).build();
    private static final SdkField<SdkBytes> SERVER_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("ServerProperties").getter(DescribeConfigurationRevisionResponse.getter(DescribeConfigurationRevisionResponse::serverProperties)).setter(DescribeConfigurationRevisionResponse.setter(Builder::serverProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverProperties").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATION_TIME_FIELD, DESCRIPTION_FIELD, REVISION_FIELD, SERVER_PROPERTIES_FIELD));
    private final String arn;
    private final Instant creationTime;
    private final String description;
    private final Long revision;
    private final SdkBytes serverProperties;

    private DescribeConfigurationRevisionResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.creationTime = builder.creationTime;
        this.description = builder.description;
        this.revision = builder.revision;
        this.serverProperties = builder.serverProperties;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String description() {
        return this.description;
    }

    public final Long revision() {
        return this.revision;
    }

    public final SdkBytes serverProperties() {
        return this.serverProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.revision());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverProperties());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigurationRevisionResponse)) {
            return false;
        }
        DescribeConfigurationRevisionResponse other = (DescribeConfigurationRevisionResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.revision(), other.revision()) && Objects.equals(this.serverProperties(), other.serverProperties());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeConfigurationRevisionResponse").add("Arn", (Object)this.arn()).add("CreationTime", (Object)this.creationTime()).add("Description", (Object)this.description()).add("Revision", (Object)this.revision()).add("ServerProperties", (Object)this.serverProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Revision": {
                return Optional.ofNullable(clazz.cast(this.revision()));
            }
            case "ServerProperties": {
                return Optional.ofNullable(clazz.cast(this.serverProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeConfigurationRevisionResponse, T> g) {
        return obj -> g.apply((DescribeConfigurationRevisionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KafkaResponse.BuilderImpl
    implements Builder {
        private String arn;
        private Instant creationTime;
        private String description;
        private Long revision;
        private SdkBytes serverProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigurationRevisionResponse model) {
            super(model);
            this.arn(model.arn);
            this.creationTime(model.creationTime);
            this.description(model.description);
            this.revision(model.revision);
            this.serverProperties(model.serverProperties);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Long getRevision() {
            return this.revision;
        }

        @Override
        public final Builder revision(Long revision) {
            this.revision = revision;
            return this;
        }

        public final void setRevision(Long revision) {
            this.revision = revision;
        }

        public final ByteBuffer getServerProperties() {
            return this.serverProperties == null ? null : this.serverProperties.asByteBuffer();
        }

        @Override
        public final Builder serverProperties(SdkBytes serverProperties) {
            this.serverProperties = serverProperties;
            return this;
        }

        public final void setServerProperties(ByteBuffer serverProperties) {
            this.serverProperties(serverProperties == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)serverProperties));
        }

        @Override
        public DescribeConfigurationRevisionResponse build() {
            return new DescribeConfigurationRevisionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KafkaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeConfigurationRevisionResponse> {
        public Builder arn(String var1);

        public Builder creationTime(Instant var1);

        public Builder description(String var1);

        public Builder revision(Long var1);

        public Builder serverProperties(SdkBytes var1);
    }
}

