/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kafka.model.ConfigurationRevision;
import software.amazon.awssdk.services.kafka.model.ConfigurationState;
import software.amazon.awssdk.services.kafka.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Configuration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Configuration> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(Configuration.getter(Configuration::arn)).setter(Configuration.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(Configuration.getter(Configuration::creationTime)).setter(Configuration.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(Configuration.getter(Configuration::description)).setter(Configuration.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<String>> KAFKA_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("KafkaVersions").getter(Configuration.getter(Configuration::kafkaVersions)).setter(Configuration.setter(Builder::kafkaVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kafkaVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ConfigurationRevision> LATEST_REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LatestRevision").getter(Configuration.getter(Configuration::latestRevision)).setter(Configuration.setter(Builder::latestRevision)).constructor(ConfigurationRevision::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestRevision").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Configuration.getter(Configuration::name)).setter(Configuration.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(Configuration.getter(Configuration::stateAsString)).setter(Configuration.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATION_TIME_FIELD, DESCRIPTION_FIELD, KAFKA_VERSIONS_FIELD, LATEST_REVISION_FIELD, NAME_FIELD, STATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final Instant creationTime;
    private final String description;
    private final List<String> kafkaVersions;
    private final ConfigurationRevision latestRevision;
    private final String name;
    private final String state;

    private Configuration(BuilderImpl builder) {
        this.arn = builder.arn;
        this.creationTime = builder.creationTime;
        this.description = builder.description;
        this.kafkaVersions = builder.kafkaVersions;
        this.latestRevision = builder.latestRevision;
        this.name = builder.name;
        this.state = builder.state;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasKafkaVersions() {
        return this.kafkaVersions != null && !(this.kafkaVersions instanceof SdkAutoConstructList);
    }

    public final List<String> kafkaVersions() {
        return this.kafkaVersions;
    }

    public final ConfigurationRevision latestRevision() {
        return this.latestRevision;
    }

    public final String name() {
        return this.name;
    }

    public final ConfigurationState state() {
        return ConfigurationState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKafkaVersions() ? this.kafkaVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.latestRevision());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Configuration)) {
            return false;
        }
        Configuration other = (Configuration)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.description(), other.description()) && this.hasKafkaVersions() == other.hasKafkaVersions() && Objects.equals(this.kafkaVersions(), other.kafkaVersions()) && Objects.equals(this.latestRevision(), other.latestRevision()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.stateAsString(), other.stateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Configuration").add("Arn", (Object)this.arn()).add("CreationTime", (Object)this.creationTime()).add("Description", (Object)this.description()).add("KafkaVersions", this.hasKafkaVersions() ? this.kafkaVersions() : null).add("LatestRevision", (Object)this.latestRevision()).add("Name", (Object)this.name()).add("State", (Object)this.stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "KafkaVersions": {
                return Optional.ofNullable(clazz.cast(this.kafkaVersions()));
            }
            case "LatestRevision": {
                return Optional.ofNullable(clazz.cast(this.latestRevision()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Configuration, T> g) {
        return obj -> g.apply((Configuration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private Instant creationTime;
        private String description;
        private List<String> kafkaVersions = DefaultSdkAutoConstructList.getInstance();
        private ConfigurationRevision latestRevision;
        private String name;
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(Configuration model) {
            this.arn(model.arn);
            this.creationTime(model.creationTime);
            this.description(model.description);
            this.kafkaVersions(model.kafkaVersions);
            this.latestRevision(model.latestRevision);
            this.name(model.name);
            this.state(model.state);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<String> getKafkaVersions() {
            if (this.kafkaVersions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.kafkaVersions;
        }

        @Override
        public final Builder kafkaVersions(Collection<String> kafkaVersions) {
            this.kafkaVersions = ___listOf__stringCopier.copy(kafkaVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder kafkaVersions(String ... kafkaVersions) {
            this.kafkaVersions(Arrays.asList(kafkaVersions));
            return this;
        }

        public final void setKafkaVersions(Collection<String> kafkaVersions) {
            this.kafkaVersions = ___listOf__stringCopier.copy(kafkaVersions);
        }

        public final ConfigurationRevision.Builder getLatestRevision() {
            return this.latestRevision != null ? this.latestRevision.toBuilder() : null;
        }

        @Override
        public final Builder latestRevision(ConfigurationRevision latestRevision) {
            this.latestRevision = latestRevision;
            return this;
        }

        public final void setLatestRevision(ConfigurationRevision.BuilderImpl latestRevision) {
            this.latestRevision = latestRevision != null ? latestRevision.build() : null;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ConfigurationState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public Configuration build() {
            return new Configuration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Configuration> {
        public Builder arn(String var1);

        public Builder creationTime(Instant var1);

        public Builder description(String var1);

        public Builder kafkaVersions(Collection<String> var1);

        public Builder kafkaVersions(String ... var1);

        public Builder latestRevision(ConfigurationRevision var1);

        default public Builder latestRevision(Consumer<ConfigurationRevision.Builder> latestRevision) {
            return this.latestRevision((ConfigurationRevision)((ConfigurationRevision.Builder)ConfigurationRevision.builder().applyMutation(latestRevision)).build());
        }

        public Builder name(String var1);

        public Builder state(String var1);

        public Builder state(ConfigurationState var1);
    }
}

