/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kafka.model.JmxExporter;
import software.amazon.awssdk.services.kafka.model.NodeExporter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Prometheus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Prometheus> {
    private static final SdkField<JmxExporter> JMX_EXPORTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Prometheus.getter(Prometheus::jmxExporter)).setter(Prometheus.setter(Builder::jmxExporter)).constructor(JmxExporter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jmxExporter").build()}).build();
    private static final SdkField<NodeExporter> NODE_EXPORTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Prometheus.getter(Prometheus::nodeExporter)).setter(Prometheus.setter(Builder::nodeExporter)).constructor(NodeExporter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeExporter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JMX_EXPORTER_FIELD, NODE_EXPORTER_FIELD));
    private static final long serialVersionUID = 1L;
    private final JmxExporter jmxExporter;
    private final NodeExporter nodeExporter;

    private Prometheus(BuilderImpl builder) {
        this.jmxExporter = builder.jmxExporter;
        this.nodeExporter = builder.nodeExporter;
    }

    public JmxExporter jmxExporter() {
        return this.jmxExporter;
    }

    public NodeExporter nodeExporter() {
        return this.nodeExporter;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jmxExporter());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeExporter());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Prometheus)) {
            return false;
        }
        Prometheus other = (Prometheus)obj;
        return Objects.equals(this.jmxExporter(), other.jmxExporter()) && Objects.equals(this.nodeExporter(), other.nodeExporter());
    }

    public String toString() {
        return ToString.builder((String)"Prometheus").add("JmxExporter", (Object)this.jmxExporter()).add("NodeExporter", (Object)this.nodeExporter()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JmxExporter": {
                return Optional.ofNullable(clazz.cast(this.jmxExporter()));
            }
            case "NodeExporter": {
                return Optional.ofNullable(clazz.cast(this.nodeExporter()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Prometheus, T> g) {
        return obj -> g.apply((Prometheus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private JmxExporter jmxExporter;
        private NodeExporter nodeExporter;

        private BuilderImpl() {
        }

        private BuilderImpl(Prometheus model) {
            this.jmxExporter(model.jmxExporter);
            this.nodeExporter(model.nodeExporter);
        }

        public final JmxExporter.Builder getJmxExporter() {
            return this.jmxExporter != null ? this.jmxExporter.toBuilder() : null;
        }

        @Override
        public final Builder jmxExporter(JmxExporter jmxExporter) {
            this.jmxExporter = jmxExporter;
            return this;
        }

        public final void setJmxExporter(JmxExporter.BuilderImpl jmxExporter) {
            this.jmxExporter = jmxExporter != null ? jmxExporter.build() : null;
        }

        public final NodeExporter.Builder getNodeExporter() {
            return this.nodeExporter != null ? this.nodeExporter.toBuilder() : null;
        }

        @Override
        public final Builder nodeExporter(NodeExporter nodeExporter) {
            this.nodeExporter = nodeExporter;
            return this;
        }

        public final void setNodeExporter(NodeExporter.BuilderImpl nodeExporter) {
            this.nodeExporter = nodeExporter != null ? nodeExporter.build() : null;
        }

        public Prometheus build() {
            return new Prometheus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Prometheus> {
        public Builder jmxExporter(JmxExporter var1);

        default public Builder jmxExporter(Consumer<JmxExporter.Builder> jmxExporter) {
            return this.jmxExporter((JmxExporter)((JmxExporter.Builder)JmxExporter.builder().applyMutation(jmxExporter)).build());
        }

        public Builder nodeExporter(NodeExporter var1);

        default public Builder nodeExporter(Consumer<NodeExporter.Builder> nodeExporter) {
            return this.nodeExporter((NodeExporter)((NodeExporter.Builder)NodeExporter.builder().applyMutation(nodeExporter)).build());
        }
    }
}

