/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivsrealtime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ivsrealtime.model.IvsRealTimeRequest;
import software.amazon.awssdk.services.ivsrealtime.model.ParticipantAttributesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartParticipantReplicationRequest
extends IvsRealTimeRequest
implements ToCopyableBuilder<Builder, StartParticipantReplicationRequest> {
    private static final SdkField<String> SOURCE_STAGE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceStageArn").getter(StartParticipantReplicationRequest.getter(StartParticipantReplicationRequest::sourceStageArn)).setter(StartParticipantReplicationRequest.setter(Builder::sourceStageArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceStageArn").build()}).build();
    private static final SdkField<String> DESTINATION_STAGE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destinationStageArn").getter(StartParticipantReplicationRequest.getter(StartParticipantReplicationRequest::destinationStageArn)).setter(StartParticipantReplicationRequest.setter(Builder::destinationStageArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationStageArn").build()}).build();
    private static final SdkField<String> PARTICIPANT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("participantId").getter(StartParticipantReplicationRequest.getter(StartParticipantReplicationRequest::participantId)).setter(StartParticipantReplicationRequest.setter(Builder::participantId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("participantId").build()}).build();
    private static final SdkField<Integer> RECONNECT_WINDOW_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("reconnectWindowSeconds").getter(StartParticipantReplicationRequest.getter(StartParticipantReplicationRequest::reconnectWindowSeconds)).setter(StartParticipantReplicationRequest.setter(Builder::reconnectWindowSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reconnectWindowSeconds").build()}).build();
    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("attributes").getter(StartParticipantReplicationRequest.getter(StartParticipantReplicationRequest::attributes)).setter(StartParticipantReplicationRequest.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_STAGE_ARN_FIELD, DESTINATION_STAGE_ARN_FIELD, PARTICIPANT_ID_FIELD, RECONNECT_WINDOW_SECONDS_FIELD, ATTRIBUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartParticipantReplicationRequest.memberNameToFieldInitializer();
    private final String sourceStageArn;
    private final String destinationStageArn;
    private final String participantId;
    private final Integer reconnectWindowSeconds;
    private final Map<String, String> attributes;

    private StartParticipantReplicationRequest(BuilderImpl builder) {
        super(builder);
        this.sourceStageArn = builder.sourceStageArn;
        this.destinationStageArn = builder.destinationStageArn;
        this.participantId = builder.participantId;
        this.reconnectWindowSeconds = builder.reconnectWindowSeconds;
        this.attributes = builder.attributes;
    }

    public final String sourceStageArn() {
        return this.sourceStageArn;
    }

    public final String destinationStageArn() {
        return this.destinationStageArn;
    }

    public final String participantId() {
        return this.participantId;
    }

    public final Integer reconnectWindowSeconds() {
        return this.reconnectWindowSeconds;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> attributes() {
        return this.attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceStageArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationStageArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.participantId());
        hashCode = 31 * hashCode + Objects.hashCode(this.reconnectWindowSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartParticipantReplicationRequest)) {
            return false;
        }
        StartParticipantReplicationRequest other = (StartParticipantReplicationRequest)((Object)obj);
        return Objects.equals(this.sourceStageArn(), other.sourceStageArn()) && Objects.equals(this.destinationStageArn(), other.destinationStageArn()) && Objects.equals(this.participantId(), other.participantId()) && Objects.equals(this.reconnectWindowSeconds(), other.reconnectWindowSeconds()) && this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes());
    }

    public final String toString() {
        return ToString.builder((String)"StartParticipantReplicationRequest").add("SourceStageArn", (Object)this.sourceStageArn()).add("DestinationStageArn", (Object)this.destinationStageArn()).add("ParticipantId", (Object)this.participantId()).add("ReconnectWindowSeconds", (Object)this.reconnectWindowSeconds()).add("Attributes", this.hasAttributes() ? this.attributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sourceStageArn": {
                return Optional.ofNullable(clazz.cast(this.sourceStageArn()));
            }
            case "destinationStageArn": {
                return Optional.ofNullable(clazz.cast(this.destinationStageArn()));
            }
            case "participantId": {
                return Optional.ofNullable(clazz.cast(this.participantId()));
            }
            case "reconnectWindowSeconds": {
                return Optional.ofNullable(clazz.cast(this.reconnectWindowSeconds()));
            }
            case "attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sourceStageArn", SOURCE_STAGE_ARN_FIELD);
        map.put("destinationStageArn", DESTINATION_STAGE_ARN_FIELD);
        map.put("participantId", PARTICIPANT_ID_FIELD);
        map.put("reconnectWindowSeconds", RECONNECT_WINDOW_SECONDS_FIELD);
        map.put("attributes", ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartParticipantReplicationRequest, T> g) {
        return obj -> g.apply((StartParticipantReplicationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IvsRealTimeRequest.BuilderImpl
    implements Builder {
        private String sourceStageArn;
        private String destinationStageArn;
        private String participantId;
        private Integer reconnectWindowSeconds;
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartParticipantReplicationRequest model) {
            super(model);
            this.sourceStageArn(model.sourceStageArn);
            this.destinationStageArn(model.destinationStageArn);
            this.participantId(model.participantId);
            this.reconnectWindowSeconds(model.reconnectWindowSeconds);
            this.attributes(model.attributes);
        }

        public final String getSourceStageArn() {
            return this.sourceStageArn;
        }

        public final void setSourceStageArn(String sourceStageArn) {
            this.sourceStageArn = sourceStageArn;
        }

        @Override
        public final Builder sourceStageArn(String sourceStageArn) {
            this.sourceStageArn = sourceStageArn;
            return this;
        }

        public final String getDestinationStageArn() {
            return this.destinationStageArn;
        }

        public final void setDestinationStageArn(String destinationStageArn) {
            this.destinationStageArn = destinationStageArn;
        }

        @Override
        public final Builder destinationStageArn(String destinationStageArn) {
            this.destinationStageArn = destinationStageArn;
            return this;
        }

        public final String getParticipantId() {
            return this.participantId;
        }

        public final void setParticipantId(String participantId) {
            this.participantId = participantId;
        }

        @Override
        public final Builder participantId(String participantId) {
            this.participantId = participantId;
            return this;
        }

        public final Integer getReconnectWindowSeconds() {
            return this.reconnectWindowSeconds;
        }

        public final void setReconnectWindowSeconds(Integer reconnectWindowSeconds) {
            this.reconnectWindowSeconds = reconnectWindowSeconds;
        }

        @Override
        public final Builder reconnectWindowSeconds(Integer reconnectWindowSeconds) {
            this.reconnectWindowSeconds = reconnectWindowSeconds;
            return this;
        }

        public final Map<String, String> getAttributes() {
            if (this.attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = ParticipantAttributesCopier.copy(attributes);
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = ParticipantAttributesCopier.copy(attributes);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartParticipantReplicationRequest build() {
            return new StartParticipantReplicationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IvsRealTimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartParticipantReplicationRequest> {
        public Builder sourceStageArn(String var1);

        public Builder destinationStageArn(String var1);

        public Builder participantId(String var1);

        public Builder reconnectWindowSeconds(Integer var1);

        public Builder attributes(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

