/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivsrealtime.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ivsrealtime.IvsRealTimeAsyncClient;
import software.amazon.awssdk.services.ivsrealtime.internal.UserAgentUtils;
import software.amazon.awssdk.services.ivsrealtime.model.ListParticipantReplicasRequest;
import software.amazon.awssdk.services.ivsrealtime.model.ListParticipantReplicasResponse;
import software.amazon.awssdk.services.ivsrealtime.model.ParticipantReplica;

public class ListParticipantReplicasPublisher
implements SdkPublisher<ListParticipantReplicasResponse> {
    private final IvsRealTimeAsyncClient client;
    private final ListParticipantReplicasRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListParticipantReplicasPublisher(IvsRealTimeAsyncClient client, ListParticipantReplicasRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListParticipantReplicasPublisher(IvsRealTimeAsyncClient client, ListParticipantReplicasRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListParticipantReplicasResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListParticipantReplicasResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ParticipantReplica> replicas() {
        Function<ListParticipantReplicasResponse, Iterator> getIterator = response -> {
            if (response != null && response.replicas() != null) {
                return response.replicas().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListParticipantReplicasResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListParticipantReplicasResponseFetcher
    implements AsyncPageFetcher<ListParticipantReplicasResponse> {
        private ListParticipantReplicasResponseFetcher() {
        }

        public boolean hasNextPage(ListParticipantReplicasResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListParticipantReplicasResponse> nextPage(ListParticipantReplicasResponse previousPage) {
            if (previousPage == null) {
                return ListParticipantReplicasPublisher.this.client.listParticipantReplicas(ListParticipantReplicasPublisher.this.firstRequest);
            }
            return ListParticipantReplicasPublisher.this.client.listParticipantReplicas((ListParticipantReplicasRequest)((Object)ListParticipantReplicasPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

