/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivsrealtime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ivsrealtime.model.IvsRealTimeResponse;
import software.amazon.awssdk.services.ivsrealtime.model.ParticipantReplica;
import software.amazon.awssdk.services.ivsrealtime.model.ParticipantReplicaListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListParticipantReplicasResponse
extends IvsRealTimeResponse
implements ToCopyableBuilder<Builder, ListParticipantReplicasResponse> {
    private static final SdkField<List<ParticipantReplica>> REPLICAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("replicas").getter(ListParticipantReplicasResponse.getter(ListParticipantReplicasResponse::replicas)).setter(ListParticipantReplicasResponse.setter(Builder::replicas)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicas").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ParticipantReplica::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListParticipantReplicasResponse.getter(ListParticipantReplicasResponse::nextToken)).setter(ListParticipantReplicasResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICAS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListParticipantReplicasResponse.memberNameToFieldInitializer();
    private final List<ParticipantReplica> replicas;
    private final String nextToken;

    private ListParticipantReplicasResponse(BuilderImpl builder) {
        super(builder);
        this.replicas = builder.replicas;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasReplicas() {
        return this.replicas != null && !(this.replicas instanceof SdkAutoConstructList);
    }

    public final List<ParticipantReplica> replicas() {
        return this.replicas;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReplicas() ? this.replicas() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListParticipantReplicasResponse)) {
            return false;
        }
        ListParticipantReplicasResponse other = (ListParticipantReplicasResponse)((Object)obj);
        return this.hasReplicas() == other.hasReplicas() && Objects.equals(this.replicas(), other.replicas()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListParticipantReplicasResponse").add("Replicas", this.hasReplicas() ? this.replicas() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "replicas": {
                return Optional.ofNullable(clazz.cast(this.replicas()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("replicas", REPLICAS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListParticipantReplicasResponse, T> g) {
        return obj -> g.apply((ListParticipantReplicasResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IvsRealTimeResponse.BuilderImpl
    implements Builder {
        private List<ParticipantReplica> replicas = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListParticipantReplicasResponse model) {
            super(model);
            this.replicas(model.replicas);
            this.nextToken(model.nextToken);
        }

        public final List<ParticipantReplica.Builder> getReplicas() {
            List<ParticipantReplica.Builder> result = ParticipantReplicaListCopier.copyToBuilder(this.replicas);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReplicas(Collection<ParticipantReplica.BuilderImpl> replicas) {
            this.replicas = ParticipantReplicaListCopier.copyFromBuilder(replicas);
        }

        @Override
        public final Builder replicas(Collection<ParticipantReplica> replicas) {
            this.replicas = ParticipantReplicaListCopier.copy(replicas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicas(ParticipantReplica ... replicas) {
            this.replicas(Arrays.asList(replicas));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicas(Consumer<ParticipantReplica.Builder> ... replicas) {
            this.replicas(Stream.of(replicas).map(c -> (ParticipantReplica)((ParticipantReplica.Builder)ParticipantReplica.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListParticipantReplicasResponse build() {
            return new ListParticipantReplicasResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IvsRealTimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListParticipantReplicasResponse> {
        public Builder replicas(Collection<ParticipantReplica> var1);

        public Builder replicas(ParticipantReplica ... var1);

        public Builder replicas(Consumer<ParticipantReplica.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

