/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivsrealtime.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EventErrorCode {
    INSUFFICIENT_CAPABILITIES("INSUFFICIENT_CAPABILITIES"),
    QUOTA_EXCEEDED("QUOTA_EXCEEDED"),
    PUBLISHER_NOT_FOUND("PUBLISHER_NOT_FOUND"),
    BITRATE_EXCEEDED("BITRATE_EXCEEDED"),
    RESOLUTION_EXCEEDED("RESOLUTION_EXCEEDED"),
    STREAM_DURATION_EXCEEDED("STREAM_DURATION_EXCEEDED"),
    INVALID_AUDIO_CODEC("INVALID_AUDIO_CODEC"),
    INVALID_VIDEO_CODEC("INVALID_VIDEO_CODEC"),
    INVALID_PROTOCOL("INVALID_PROTOCOL"),
    INVALID_STREAM_KEY("INVALID_STREAM_KEY"),
    REUSE_OF_STREAM_KEY("REUSE_OF_STREAM_KEY"),
    B_FRAME_PRESENT("B_FRAME_PRESENT"),
    INVALID_INPUT("INVALID_INPUT"),
    INTERNAL_SERVER_EXCEPTION("INTERNAL_SERVER_EXCEPTION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EventErrorCode> VALUE_MAP;
    private final String value;

    private EventErrorCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EventErrorCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EventErrorCode> knownValues() {
        EnumSet<EventErrorCode> knownValues = EnumSet.allOf(EventErrorCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EventErrorCode.class, EventErrorCode::toString);
    }
}

