/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivsrealtime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ivsrealtime.model.IngestConfigurationState;
import software.amazon.awssdk.services.ivsrealtime.model.IngestProtocol;
import software.amazon.awssdk.services.ivsrealtime.model.ParticipantAttributesCopier;
import software.amazon.awssdk.services.ivsrealtime.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IngestConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IngestConfiguration> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(IngestConfiguration.getter(IngestConfiguration::name)).setter(IngestConfiguration.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(IngestConfiguration.getter(IngestConfiguration::arn)).setter(IngestConfiguration.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> INGEST_PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ingestProtocol").getter(IngestConfiguration.getter(IngestConfiguration::ingestProtocolAsString)).setter(IngestConfiguration.setter(Builder::ingestProtocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingestProtocol").build()}).build();
    private static final SdkField<String> STREAM_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("streamKey").getter(IngestConfiguration.getter(IngestConfiguration::streamKey)).setter(IngestConfiguration.setter(Builder::streamKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamKey").build()}).build();
    private static final SdkField<String> STAGE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stageArn").getter(IngestConfiguration.getter(IngestConfiguration::stageArn)).setter(IngestConfiguration.setter(Builder::stageArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stageArn").build()}).build();
    private static final SdkField<String> PARTICIPANT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("participantId").getter(IngestConfiguration.getter(IngestConfiguration::participantId)).setter(IngestConfiguration.setter(Builder::participantId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("participantId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(IngestConfiguration.getter(IngestConfiguration::stateAsString)).setter(IngestConfiguration.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userId").getter(IngestConfiguration.getter(IngestConfiguration::userId)).setter(IngestConfiguration.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userId").build()}).build();
    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("attributes").getter(IngestConfiguration.getter(IngestConfiguration::attributes)).setter(IngestConfiguration.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(IngestConfiguration.getter(IngestConfiguration::tags)).setter(IngestConfiguration.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD, INGEST_PROTOCOL_FIELD, STREAM_KEY_FIELD, STAGE_ARN_FIELD, PARTICIPANT_ID_FIELD, STATE_FIELD, USER_ID_FIELD, ATTRIBUTES_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("name", NAME_FIELD);
            this.put("arn", ARN_FIELD);
            this.put("ingestProtocol", INGEST_PROTOCOL_FIELD);
            this.put("streamKey", STREAM_KEY_FIELD);
            this.put("stageArn", STAGE_ARN_FIELD);
            this.put("participantId", PARTICIPANT_ID_FIELD);
            this.put("state", STATE_FIELD);
            this.put("userId", USER_ID_FIELD);
            this.put("attributes", ATTRIBUTES_FIELD);
            this.put("tags", TAGS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String arn;
    private final String ingestProtocol;
    private final String streamKey;
    private final String stageArn;
    private final String participantId;
    private final String state;
    private final String userId;
    private final Map<String, String> attributes;
    private final Map<String, String> tags;

    private IngestConfiguration(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.ingestProtocol = builder.ingestProtocol;
        this.streamKey = builder.streamKey;
        this.stageArn = builder.stageArn;
        this.participantId = builder.participantId;
        this.state = builder.state;
        this.userId = builder.userId;
        this.attributes = builder.attributes;
        this.tags = builder.tags;
    }

    public final String name() {
        return this.name;
    }

    public final String arn() {
        return this.arn;
    }

    public final IngestProtocol ingestProtocol() {
        return IngestProtocol.fromValue(this.ingestProtocol);
    }

    public final String ingestProtocolAsString() {
        return this.ingestProtocol;
    }

    public final String streamKey() {
        return this.streamKey;
    }

    public final String stageArn() {
        return this.stageArn;
    }

    public final String participantId() {
        return this.participantId;
    }

    public final IngestConfigurationState state() {
        return IngestConfigurationState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String userId() {
        return this.userId;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> attributes() {
        return this.attributes;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingestProtocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.stageArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.participantId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IngestConfiguration)) {
            return false;
        }
        IngestConfiguration other = (IngestConfiguration)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.ingestProtocolAsString(), other.ingestProtocolAsString()) && Objects.equals(this.streamKey(), other.streamKey()) && Objects.equals(this.stageArn(), other.stageArn()) && Objects.equals(this.participantId(), other.participantId()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.userId(), other.userId()) && this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"IngestConfiguration").add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("IngestProtocol", (Object)this.ingestProtocolAsString()).add("StreamKey", (Object)(this.streamKey() == null ? null : "*** Sensitive Data Redacted ***")).add("StageArn", (Object)this.stageArn()).add("ParticipantId", (Object)this.participantId()).add("State", (Object)this.stateAsString()).add("UserId", (Object)this.userId()).add("Attributes", this.hasAttributes() ? this.attributes() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "ingestProtocol": {
                return Optional.ofNullable(clazz.cast(this.ingestProtocolAsString()));
            }
            case "streamKey": {
                return Optional.ofNullable(clazz.cast(this.streamKey()));
            }
            case "stageArn": {
                return Optional.ofNullable(clazz.cast(this.stageArn()));
            }
            case "participantId": {
                return Optional.ofNullable(clazz.cast(this.participantId()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "userId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<IngestConfiguration, T> g) {
        return obj -> g.apply((IngestConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String arn;
        private String ingestProtocol;
        private String streamKey;
        private String stageArn;
        private String participantId;
        private String state;
        private String userId;
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IngestConfiguration model) {
            this.name(model.name);
            this.arn(model.arn);
            this.ingestProtocol(model.ingestProtocol);
            this.streamKey(model.streamKey);
            this.stageArn(model.stageArn);
            this.participantId(model.participantId);
            this.state(model.state);
            this.userId(model.userId);
            this.attributes(model.attributes);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getIngestProtocol() {
            return this.ingestProtocol;
        }

        public final void setIngestProtocol(String ingestProtocol) {
            this.ingestProtocol = ingestProtocol;
        }

        @Override
        public final Builder ingestProtocol(String ingestProtocol) {
            this.ingestProtocol = ingestProtocol;
            return this;
        }

        @Override
        public final Builder ingestProtocol(IngestProtocol ingestProtocol) {
            this.ingestProtocol(ingestProtocol == null ? null : ingestProtocol.toString());
            return this;
        }

        public final String getStreamKey() {
            return this.streamKey;
        }

        public final void setStreamKey(String streamKey) {
            this.streamKey = streamKey;
        }

        @Override
        public final Builder streamKey(String streamKey) {
            this.streamKey = streamKey;
            return this;
        }

        public final String getStageArn() {
            return this.stageArn;
        }

        public final void setStageArn(String stageArn) {
            this.stageArn = stageArn;
        }

        @Override
        public final Builder stageArn(String stageArn) {
            this.stageArn = stageArn;
            return this;
        }

        public final String getParticipantId() {
            return this.participantId;
        }

        public final void setParticipantId(String participantId) {
            this.participantId = participantId;
        }

        @Override
        public final Builder participantId(String participantId) {
            this.participantId = participantId;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(IngestConfigurationState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final Map<String, String> getAttributes() {
            if (this.attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = ParticipantAttributesCopier.copy(attributes);
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = ParticipantAttributesCopier.copy(attributes);
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public IngestConfiguration build() {
            return new IngestConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IngestConfiguration> {
        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder ingestProtocol(String var1);

        public Builder ingestProtocol(IngestProtocol var1);

        public Builder streamKey(String var1);

        public Builder stageArn(String var1);

        public Builder participantId(String var1);

        public Builder state(String var1);

        public Builder state(IngestConfigurationState var1);

        public Builder userId(String var1);

        public Builder attributes(Map<String, String> var1);

        public Builder tags(Map<String, String> var1);
    }
}

