/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivsrealtime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ivsrealtime.model.IvsRealTimeResponse;
import software.amazon.awssdk.services.ivsrealtime.model.PublicKeyListCopier;
import software.amazon.awssdk.services.ivsrealtime.model.PublicKeySummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPublicKeysResponse
extends IvsRealTimeResponse
implements ToCopyableBuilder<Builder, ListPublicKeysResponse> {
    private static final SdkField<List<PublicKeySummary>> PUBLIC_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("publicKeys").getter(ListPublicKeysResponse.getter(ListPublicKeysResponse::publicKeys)).setter(ListPublicKeysResponse.setter(Builder::publicKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PublicKeySummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListPublicKeysResponse.getter(ListPublicKeysResponse::nextToken)).setter(ListPublicKeysResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PUBLIC_KEYS_FIELD, NEXT_TOKEN_FIELD));
    private final List<PublicKeySummary> publicKeys;
    private final String nextToken;

    private ListPublicKeysResponse(BuilderImpl builder) {
        super(builder);
        this.publicKeys = builder.publicKeys;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasPublicKeys() {
        return this.publicKeys != null && !(this.publicKeys instanceof SdkAutoConstructList);
    }

    public final List<PublicKeySummary> publicKeys() {
        return this.publicKeys;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPublicKeys() ? this.publicKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPublicKeysResponse)) {
            return false;
        }
        ListPublicKeysResponse other = (ListPublicKeysResponse)((Object)obj);
        return this.hasPublicKeys() == other.hasPublicKeys() && Objects.equals(this.publicKeys(), other.publicKeys()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListPublicKeysResponse").add("PublicKeys", this.hasPublicKeys() ? this.publicKeys() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "publicKeys": {
                return Optional.ofNullable(clazz.cast(this.publicKeys()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPublicKeysResponse, T> g) {
        return obj -> g.apply((ListPublicKeysResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IvsRealTimeResponse.BuilderImpl
    implements Builder {
        private List<PublicKeySummary> publicKeys = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPublicKeysResponse model) {
            super(model);
            this.publicKeys(model.publicKeys);
            this.nextToken(model.nextToken);
        }

        public final List<PublicKeySummary.Builder> getPublicKeys() {
            List<PublicKeySummary.Builder> result = PublicKeyListCopier.copyToBuilder(this.publicKeys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPublicKeys(Collection<PublicKeySummary.BuilderImpl> publicKeys) {
            this.publicKeys = PublicKeyListCopier.copyFromBuilder(publicKeys);
        }

        @Override
        public final Builder publicKeys(Collection<PublicKeySummary> publicKeys) {
            this.publicKeys = PublicKeyListCopier.copy(publicKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder publicKeys(PublicKeySummary ... publicKeys) {
            this.publicKeys(Arrays.asList(publicKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder publicKeys(Consumer<PublicKeySummary.Builder> ... publicKeys) {
            this.publicKeys(Stream.of(publicKeys).map(c -> (PublicKeySummary)((PublicKeySummary.Builder)PublicKeySummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPublicKeysResponse build() {
            return new ListPublicKeysResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IvsRealTimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPublicKeysResponse> {
        public Builder publicKeys(Collection<PublicKeySummary> var1);

        public Builder publicKeys(PublicKeySummary ... var1);

        public Builder publicKeys(Consumer<PublicKeySummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

