/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivsrealtime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ivsrealtime.model.IvsRealTimeResponse;
import software.amazon.awssdk.services.ivsrealtime.model.StorageConfigurationSummary;
import software.amazon.awssdk.services.ivsrealtime.model.StorageConfigurationSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListStorageConfigurationsResponse
extends IvsRealTimeResponse
implements ToCopyableBuilder<Builder, ListStorageConfigurationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListStorageConfigurationsResponse.getter(ListStorageConfigurationsResponse::nextToken)).setter(ListStorageConfigurationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<StorageConfigurationSummary>> STORAGE_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("storageConfigurations").getter(ListStorageConfigurationsResponse.getter(ListStorageConfigurationsResponse::storageConfigurations)).setter(ListStorageConfigurationsResponse.setter(Builder::storageConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StorageConfigurationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, STORAGE_CONFIGURATIONS_FIELD));
    private final String nextToken;
    private final List<StorageConfigurationSummary> storageConfigurations;

    private ListStorageConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.storageConfigurations = builder.storageConfigurations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasStorageConfigurations() {
        return this.storageConfigurations != null && !(this.storageConfigurations instanceof SdkAutoConstructList);
    }

    public final List<StorageConfigurationSummary> storageConfigurations() {
        return this.storageConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStorageConfigurations() ? this.storageConfigurations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStorageConfigurationsResponse)) {
            return false;
        }
        ListStorageConfigurationsResponse other = (ListStorageConfigurationsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasStorageConfigurations() == other.hasStorageConfigurations() && Objects.equals(this.storageConfigurations(), other.storageConfigurations());
    }

    public final String toString() {
        return ToString.builder((String)"ListStorageConfigurationsResponse").add("NextToken", (Object)this.nextToken()).add("StorageConfigurations", this.hasStorageConfigurations() ? this.storageConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "storageConfigurations": {
                return Optional.ofNullable(clazz.cast(this.storageConfigurations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListStorageConfigurationsResponse, T> g) {
        return obj -> g.apply((ListStorageConfigurationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IvsRealTimeResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<StorageConfigurationSummary> storageConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListStorageConfigurationsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.storageConfigurations(model.storageConfigurations);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<StorageConfigurationSummary.Builder> getStorageConfigurations() {
            List<StorageConfigurationSummary.Builder> result = StorageConfigurationSummaryListCopier.copyToBuilder(this.storageConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStorageConfigurations(Collection<StorageConfigurationSummary.BuilderImpl> storageConfigurations) {
            this.storageConfigurations = StorageConfigurationSummaryListCopier.copyFromBuilder(storageConfigurations);
        }

        @Override
        public final Builder storageConfigurations(Collection<StorageConfigurationSummary> storageConfigurations) {
            this.storageConfigurations = StorageConfigurationSummaryListCopier.copy(storageConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageConfigurations(StorageConfigurationSummary ... storageConfigurations) {
            this.storageConfigurations(Arrays.asList(storageConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageConfigurations(Consumer<StorageConfigurationSummary.Builder> ... storageConfigurations) {
            this.storageConfigurations(Stream.of(storageConfigurations).map(c -> (StorageConfigurationSummary)((StorageConfigurationSummary.Builder)StorageConfigurationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListStorageConfigurationsResponse build() {
            return new ListStorageConfigurationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IvsRealTimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListStorageConfigurationsResponse> {
        public Builder nextToken(String var1);

        public Builder storageConfigurations(Collection<StorageConfigurationSummary> var1);

        public Builder storageConfigurations(StorageConfigurationSummary ... var1);

        public Builder storageConfigurations(Consumer<StorageConfigurationSummary.Builder> ... var1);
    }
}

