/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivsrealtime.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ivsrealtime.model.ParticipantAttributesCopier;
import software.amazon.awssdk.services.ivsrealtime.model.ParticipantState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Participant
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Participant> {
    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("attributes").getter(Participant.getter(Participant::attributes)).setter(Participant.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> BROWSER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("browserName").getter(Participant.getter(Participant::browserName)).setter(Participant.setter(Builder::browserName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("browserName").build()}).build();
    private static final SdkField<String> BROWSER_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("browserVersion").getter(Participant.getter(Participant::browserVersion)).setter(Participant.setter(Builder::browserVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("browserVersion").build()}).build();
    private static final SdkField<Instant> FIRST_JOIN_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("firstJoinTime").getter(Participant.getter(Participant::firstJoinTime)).setter(Participant.setter(Builder::firstJoinTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firstJoinTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> ISP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ispName").getter(Participant.getter(Participant::ispName)).setter(Participant.setter(Builder::ispName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ispName").build()}).build();
    private static final SdkField<String> OS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("osName").getter(Participant.getter(Participant::osName)).setter(Participant.setter(Builder::osName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("osName").build()}).build();
    private static final SdkField<String> OS_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("osVersion").getter(Participant.getter(Participant::osVersion)).setter(Participant.setter(Builder::osVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("osVersion").build()}).build();
    private static final SdkField<String> PARTICIPANT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("participantId").getter(Participant.getter(Participant::participantId)).setter(Participant.setter(Builder::participantId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("participantId").build()}).build();
    private static final SdkField<Boolean> PUBLISHED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("published").getter(Participant.getter(Participant::published)).setter(Participant.setter(Builder::published)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("published").build()}).build();
    private static final SdkField<String> SDK_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sdkVersion").getter(Participant.getter(Participant::sdkVersion)).setter(Participant.setter(Builder::sdkVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sdkVersion").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(Participant.getter(Participant::stateAsString)).setter(Participant.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userId").getter(Participant.getter(Participant::userId)).setter(Participant.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTES_FIELD, BROWSER_NAME_FIELD, BROWSER_VERSION_FIELD, FIRST_JOIN_TIME_FIELD, ISP_NAME_FIELD, OS_NAME_FIELD, OS_VERSION_FIELD, PARTICIPANT_ID_FIELD, PUBLISHED_FIELD, SDK_VERSION_FIELD, STATE_FIELD, USER_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final Map<String, String> attributes;
    private final String browserName;
    private final String browserVersion;
    private final Instant firstJoinTime;
    private final String ispName;
    private final String osName;
    private final String osVersion;
    private final String participantId;
    private final Boolean published;
    private final String sdkVersion;
    private final String state;
    private final String userId;

    private Participant(BuilderImpl builder) {
        this.attributes = builder.attributes;
        this.browserName = builder.browserName;
        this.browserVersion = builder.browserVersion;
        this.firstJoinTime = builder.firstJoinTime;
        this.ispName = builder.ispName;
        this.osName = builder.osName;
        this.osVersion = builder.osVersion;
        this.participantId = builder.participantId;
        this.published = builder.published;
        this.sdkVersion = builder.sdkVersion;
        this.state = builder.state;
        this.userId = builder.userId;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> attributes() {
        return this.attributes;
    }

    public final String browserName() {
        return this.browserName;
    }

    public final String browserVersion() {
        return this.browserVersion;
    }

    public final Instant firstJoinTime() {
        return this.firstJoinTime;
    }

    public final String ispName() {
        return this.ispName;
    }

    public final String osName() {
        return this.osName;
    }

    public final String osVersion() {
        return this.osVersion;
    }

    public final String participantId() {
        return this.participantId;
    }

    public final Boolean published() {
        return this.published;
    }

    public final String sdkVersion() {
        return this.sdkVersion;
    }

    public final ParticipantState state() {
        return ParticipantState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String userId() {
        return this.userId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.browserName());
        hashCode = 31 * hashCode + Objects.hashCode(this.browserVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.firstJoinTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.ispName());
        hashCode = 31 * hashCode + Objects.hashCode(this.osName());
        hashCode = 31 * hashCode + Objects.hashCode(this.osVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.participantId());
        hashCode = 31 * hashCode + Objects.hashCode(this.published());
        hashCode = 31 * hashCode + Objects.hashCode(this.sdkVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Participant)) {
            return false;
        }
        Participant other = (Participant)obj;
        return this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.browserName(), other.browserName()) && Objects.equals(this.browserVersion(), other.browserVersion()) && Objects.equals(this.firstJoinTime(), other.firstJoinTime()) && Objects.equals(this.ispName(), other.ispName()) && Objects.equals(this.osName(), other.osName()) && Objects.equals(this.osVersion(), other.osVersion()) && Objects.equals(this.participantId(), other.participantId()) && Objects.equals(this.published(), other.published()) && Objects.equals(this.sdkVersion(), other.sdkVersion()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.userId(), other.userId());
    }

    public final String toString() {
        return ToString.builder((String)"Participant").add("Attributes", this.hasAttributes() ? this.attributes() : null).add("BrowserName", (Object)this.browserName()).add("BrowserVersion", (Object)this.browserVersion()).add("FirstJoinTime", (Object)this.firstJoinTime()).add("IspName", (Object)this.ispName()).add("OsName", (Object)this.osName()).add("OsVersion", (Object)this.osVersion()).add("ParticipantId", (Object)this.participantId()).add("Published", (Object)this.published()).add("SdkVersion", (Object)this.sdkVersion()).add("State", (Object)this.stateAsString()).add("UserId", (Object)this.userId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "browserName": {
                return Optional.ofNullable(clazz.cast(this.browserName()));
            }
            case "browserVersion": {
                return Optional.ofNullable(clazz.cast(this.browserVersion()));
            }
            case "firstJoinTime": {
                return Optional.ofNullable(clazz.cast(this.firstJoinTime()));
            }
            case "ispName": {
                return Optional.ofNullable(clazz.cast(this.ispName()));
            }
            case "osName": {
                return Optional.ofNullable(clazz.cast(this.osName()));
            }
            case "osVersion": {
                return Optional.ofNullable(clazz.cast(this.osVersion()));
            }
            case "participantId": {
                return Optional.ofNullable(clazz.cast(this.participantId()));
            }
            case "published": {
                return Optional.ofNullable(clazz.cast(this.published()));
            }
            case "sdkVersion": {
                return Optional.ofNullable(clazz.cast(this.sdkVersion()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "userId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Participant, T> g) {
        return obj -> g.apply((Participant)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();
        private String browserName;
        private String browserVersion;
        private Instant firstJoinTime;
        private String ispName;
        private String osName;
        private String osVersion;
        private String participantId;
        private Boolean published;
        private String sdkVersion;
        private String state;
        private String userId;

        private BuilderImpl() {
        }

        private BuilderImpl(Participant model) {
            this.attributes(model.attributes);
            this.browserName(model.browserName);
            this.browserVersion(model.browserVersion);
            this.firstJoinTime(model.firstJoinTime);
            this.ispName(model.ispName);
            this.osName(model.osName);
            this.osVersion(model.osVersion);
            this.participantId(model.participantId);
            this.published(model.published);
            this.sdkVersion(model.sdkVersion);
            this.state(model.state);
            this.userId(model.userId);
        }

        public final Map<String, String> getAttributes() {
            if (this.attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = ParticipantAttributesCopier.copy(attributes);
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = ParticipantAttributesCopier.copy(attributes);
            return this;
        }

        public final String getBrowserName() {
            return this.browserName;
        }

        public final void setBrowserName(String browserName) {
            this.browserName = browserName;
        }

        @Override
        public final Builder browserName(String browserName) {
            this.browserName = browserName;
            return this;
        }

        public final String getBrowserVersion() {
            return this.browserVersion;
        }

        public final void setBrowserVersion(String browserVersion) {
            this.browserVersion = browserVersion;
        }

        @Override
        public final Builder browserVersion(String browserVersion) {
            this.browserVersion = browserVersion;
            return this;
        }

        public final Instant getFirstJoinTime() {
            return this.firstJoinTime;
        }

        public final void setFirstJoinTime(Instant firstJoinTime) {
            this.firstJoinTime = firstJoinTime;
        }

        @Override
        public final Builder firstJoinTime(Instant firstJoinTime) {
            this.firstJoinTime = firstJoinTime;
            return this;
        }

        public final String getIspName() {
            return this.ispName;
        }

        public final void setIspName(String ispName) {
            this.ispName = ispName;
        }

        @Override
        public final Builder ispName(String ispName) {
            this.ispName = ispName;
            return this;
        }

        public final String getOsName() {
            return this.osName;
        }

        public final void setOsName(String osName) {
            this.osName = osName;
        }

        @Override
        public final Builder osName(String osName) {
            this.osName = osName;
            return this;
        }

        public final String getOsVersion() {
            return this.osVersion;
        }

        public final void setOsVersion(String osVersion) {
            this.osVersion = osVersion;
        }

        @Override
        public final Builder osVersion(String osVersion) {
            this.osVersion = osVersion;
            return this;
        }

        public final String getParticipantId() {
            return this.participantId;
        }

        public final void setParticipantId(String participantId) {
            this.participantId = participantId;
        }

        @Override
        public final Builder participantId(String participantId) {
            this.participantId = participantId;
            return this;
        }

        public final Boolean getPublished() {
            return this.published;
        }

        public final void setPublished(Boolean published) {
            this.published = published;
        }

        @Override
        public final Builder published(Boolean published) {
            this.published = published;
            return this;
        }

        public final String getSdkVersion() {
            return this.sdkVersion;
        }

        public final void setSdkVersion(String sdkVersion) {
            this.sdkVersion = sdkVersion;
        }

        @Override
        public final Builder sdkVersion(String sdkVersion) {
            this.sdkVersion = sdkVersion;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ParticipantState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public Participant build() {
            return new Participant(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Participant> {
        public Builder attributes(Map<String, String> var1);

        public Builder browserName(String var1);

        public Builder browserVersion(String var1);

        public Builder firstJoinTime(Instant var1);

        public Builder ispName(String var1);

        public Builder osName(String var1);

        public Builder osVersion(String var1);

        public Builder participantId(String var1);

        public Builder published(Boolean var1);

        public Builder sdkVersion(String var1);

        public Builder state(String var1);

        public Builder state(ParticipantState var1);

        public Builder userId(String var1);
    }
}

