/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivsrealtime.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ivsrealtime.model.ParticipantState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ParticipantSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ParticipantSummary> {
    private static final SdkField<Instant> FIRST_JOIN_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("firstJoinTime").getter(ParticipantSummary.getter(ParticipantSummary::firstJoinTime)).setter(ParticipantSummary.setter(Builder::firstJoinTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firstJoinTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> PARTICIPANT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("participantId").getter(ParticipantSummary.getter(ParticipantSummary::participantId)).setter(ParticipantSummary.setter(Builder::participantId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("participantId").build()}).build();
    private static final SdkField<Boolean> PUBLISHED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("published").getter(ParticipantSummary.getter(ParticipantSummary::published)).setter(ParticipantSummary.setter(Builder::published)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("published").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(ParticipantSummary.getter(ParticipantSummary::stateAsString)).setter(ParticipantSummary.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userId").getter(ParticipantSummary.getter(ParticipantSummary::userId)).setter(ParticipantSummary.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIRST_JOIN_TIME_FIELD, PARTICIPANT_ID_FIELD, PUBLISHED_FIELD, STATE_FIELD, USER_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant firstJoinTime;
    private final String participantId;
    private final Boolean published;
    private final String state;
    private final String userId;

    private ParticipantSummary(BuilderImpl builder) {
        this.firstJoinTime = builder.firstJoinTime;
        this.participantId = builder.participantId;
        this.published = builder.published;
        this.state = builder.state;
        this.userId = builder.userId;
    }

    public final Instant firstJoinTime() {
        return this.firstJoinTime;
    }

    public final String participantId() {
        return this.participantId;
    }

    public final Boolean published() {
        return this.published;
    }

    public final ParticipantState state() {
        return ParticipantState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String userId() {
        return this.userId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.firstJoinTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.participantId());
        hashCode = 31 * hashCode + Objects.hashCode(this.published());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParticipantSummary)) {
            return false;
        }
        ParticipantSummary other = (ParticipantSummary)obj;
        return Objects.equals(this.firstJoinTime(), other.firstJoinTime()) && Objects.equals(this.participantId(), other.participantId()) && Objects.equals(this.published(), other.published()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.userId(), other.userId());
    }

    public final String toString() {
        return ToString.builder((String)"ParticipantSummary").add("FirstJoinTime", (Object)this.firstJoinTime()).add("ParticipantId", (Object)this.participantId()).add("Published", (Object)this.published()).add("State", (Object)this.stateAsString()).add("UserId", (Object)this.userId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "firstJoinTime": {
                return Optional.ofNullable(clazz.cast(this.firstJoinTime()));
            }
            case "participantId": {
                return Optional.ofNullable(clazz.cast(this.participantId()));
            }
            case "published": {
                return Optional.ofNullable(clazz.cast(this.published()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "userId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ParticipantSummary, T> g) {
        return obj -> g.apply((ParticipantSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant firstJoinTime;
        private String participantId;
        private Boolean published;
        private String state;
        private String userId;

        private BuilderImpl() {
        }

        private BuilderImpl(ParticipantSummary model) {
            this.firstJoinTime(model.firstJoinTime);
            this.participantId(model.participantId);
            this.published(model.published);
            this.state(model.state);
            this.userId(model.userId);
        }

        public final Instant getFirstJoinTime() {
            return this.firstJoinTime;
        }

        public final void setFirstJoinTime(Instant firstJoinTime) {
            this.firstJoinTime = firstJoinTime;
        }

        @Override
        public final Builder firstJoinTime(Instant firstJoinTime) {
            this.firstJoinTime = firstJoinTime;
            return this;
        }

        public final String getParticipantId() {
            return this.participantId;
        }

        public final void setParticipantId(String participantId) {
            this.participantId = participantId;
        }

        @Override
        public final Builder participantId(String participantId) {
            this.participantId = participantId;
            return this;
        }

        public final Boolean getPublished() {
            return this.published;
        }

        public final void setPublished(Boolean published) {
            this.published = published;
        }

        @Override
        public final Builder published(Boolean published) {
            this.published = published;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ParticipantState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public ParticipantSummary build() {
            return new ParticipantSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ParticipantSummary> {
        public Builder firstJoinTime(Instant var1);

        public Builder participantId(String var1);

        public Builder published(Boolean var1);

        public Builder state(String var1);

        public Builder state(ParticipantState var1);

        public Builder userId(String var1);
    }
}

