/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivsrealtime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetStageSessionResponse extends IvsRealTimeResponse implements
        ToCopyableBuilder<GetStageSessionResponse.Builder, GetStageSessionResponse> {
    private static final SdkField<StageSession> STAGE_SESSION_FIELD = SdkField.<StageSession> builder(MarshallingType.SDK_POJO)
            .memberName("stageSession").getter(getter(GetStageSessionResponse::stageSession))
            .setter(setter(Builder::stageSession)).constructor(StageSession::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stageSession").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STAGE_SESSION_FIELD));

    private final StageSession stageSession;

    private GetStageSessionResponse(BuilderImpl builder) {
        super(builder);
        this.stageSession = builder.stageSession;
    }

    /**
     * <p>
     * The stage session that is returned.
     * </p>
     * 
     * @return The stage session that is returned.
     */
    public final StageSession stageSession() {
        return stageSession;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stageSession());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetStageSessionResponse)) {
            return false;
        }
        GetStageSessionResponse other = (GetStageSessionResponse) obj;
        return Objects.equals(stageSession(), other.stageSession());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetStageSessionResponse").add("StageSession", stageSession()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stageSession":
            return Optional.ofNullable(clazz.cast(stageSession()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetStageSessionResponse, T> g) {
        return obj -> g.apply((GetStageSessionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IvsRealTimeResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetStageSessionResponse> {
        /**
         * <p>
         * The stage session that is returned.
         * </p>
         * 
         * @param stageSession
         *        The stage session that is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageSession(StageSession stageSession);

        /**
         * <p>
         * The stage session that is returned.
         * </p>
         * This is a convenience method that creates an instance of the {@link StageSession.Builder} avoiding the need
         * to create one manually via {@link StageSession#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StageSession.Builder#build()} is called immediately and its
         * result is passed to {@link #stageSession(StageSession)}.
         * 
         * @param stageSession
         *        a consumer that will call methods on {@link StageSession.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stageSession(StageSession)
         */
        default Builder stageSession(Consumer<StageSession.Builder> stageSession) {
            return stageSession(StageSession.builder().applyMutation(stageSession).build());
        }
    }

    static final class BuilderImpl extends IvsRealTimeResponse.BuilderImpl implements Builder {
        private StageSession stageSession;

        private BuilderImpl() {
        }

        private BuilderImpl(GetStageSessionResponse model) {
            super(model);
            stageSession(model.stageSession);
        }

        public final StageSession.Builder getStageSession() {
            return stageSession != null ? stageSession.toBuilder() : null;
        }

        public final void setStageSession(StageSession.BuilderImpl stageSession) {
            this.stageSession = stageSession != null ? stageSession.build() : null;
        }

        @Override
        public final Builder stageSession(StageSession stageSession) {
            this.stageSession = stageSession;
            return this;
        }

        @Override
        public GetStageSessionResponse build() {
            return new GetStageSessionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
