/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivsrealtime.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ivsrealtime.IvsRealTimeClient;
import software.amazon.awssdk.services.ivsrealtime.model.ListParticipantsRequest;
import software.amazon.awssdk.services.ivsrealtime.model.ListParticipantsResponse;

public class ListParticipantsIterable
implements SdkIterable<ListParticipantsResponse> {
    private final IvsRealTimeClient client;
    private final ListParticipantsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListParticipantsIterable(IvsRealTimeClient client, ListParticipantsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListParticipantsResponseFetcher();
    }

    public Iterator<ListParticipantsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListParticipantsResponseFetcher
    implements SyncPageFetcher<ListParticipantsResponse> {
        private ListParticipantsResponseFetcher() {
        }

        public boolean hasNextPage(ListParticipantsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListParticipantsResponse nextPage(ListParticipantsResponse previousPage) {
            if (previousPage == null) {
                return ListParticipantsIterable.this.client.listParticipants(ListParticipantsIterable.this.firstRequest);
            }
            return ListParticipantsIterable.this.client.listParticipants((ListParticipantsRequest)((Object)ListParticipantsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

