/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivschat.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ivschat.model.CreateLoggingConfigurationState;
import software.amazon.awssdk.services.ivschat.model.DestinationConfiguration;
import software.amazon.awssdk.services.ivschat.model.IvschatResponse;
import software.amazon.awssdk.services.ivschat.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateLoggingConfigurationResponse
extends IvschatResponse
implements ToCopyableBuilder<Builder, CreateLoggingConfigurationResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(CreateLoggingConfigurationResponse.getter(CreateLoggingConfigurationResponse::arn)).setter(CreateLoggingConfigurationResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(CreateLoggingConfigurationResponse.getter(CreateLoggingConfigurationResponse::id)).setter(CreateLoggingConfigurationResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createTime").getter(CreateLoggingConfigurationResponse.getter(CreateLoggingConfigurationResponse::createTime)).setter(CreateLoggingConfigurationResponse.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updateTime").getter(CreateLoggingConfigurationResponse.getter(CreateLoggingConfigurationResponse::updateTime)).setter(CreateLoggingConfigurationResponse.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateLoggingConfigurationResponse.getter(CreateLoggingConfigurationResponse::name)).setter(CreateLoggingConfigurationResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<DestinationConfiguration> DESTINATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("destinationConfiguration").getter(CreateLoggingConfigurationResponse.getter(CreateLoggingConfigurationResponse::destinationConfiguration)).setter(CreateLoggingConfigurationResponse.setter(Builder::destinationConfiguration)).constructor(DestinationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationConfiguration").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(CreateLoggingConfigurationResponse.getter(CreateLoggingConfigurationResponse::stateAsString)).setter(CreateLoggingConfigurationResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateLoggingConfigurationResponse.getter(CreateLoggingConfigurationResponse::tags)).setter(CreateLoggingConfigurationResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD, CREATE_TIME_FIELD, UPDATE_TIME_FIELD, NAME_FIELD, DESTINATION_CONFIGURATION_FIELD, STATE_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateLoggingConfigurationResponse.memberNameToFieldInitializer();
    private final String arn;
    private final String id;
    private final Instant createTime;
    private final Instant updateTime;
    private final String name;
    private final DestinationConfiguration destinationConfiguration;
    private final String state;
    private final Map<String, String> tags;

    private CreateLoggingConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.id = builder.id;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.name = builder.name;
        this.destinationConfiguration = builder.destinationConfiguration;
        this.state = builder.state;
        this.tags = builder.tags;
    }

    public final String arn() {
        return this.arn;
    }

    public final String id() {
        return this.id;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public final String name() {
        return this.name;
    }

    public final DestinationConfiguration destinationConfiguration() {
        return this.destinationConfiguration;
    }

    public final CreateLoggingConfigurationState state() {
        return CreateLoggingConfigurationState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLoggingConfigurationResponse)) {
            return false;
        }
        CreateLoggingConfigurationResponse other = (CreateLoggingConfigurationResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.updateTime(), other.updateTime()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.destinationConfiguration(), other.destinationConfiguration()) && Objects.equals(this.stateAsString(), other.stateAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateLoggingConfigurationResponse").add("Arn", (Object)this.arn()).add("Id", (Object)this.id()).add("CreateTime", (Object)this.createTime()).add("UpdateTime", (Object)this.updateTime()).add("Name", (Object)this.name()).add("DestinationConfiguration", (Object)this.destinationConfiguration()).add("State", (Object)this.stateAsString()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "createTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "updateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "destinationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.destinationConfiguration()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("id", ID_FIELD);
        map.put("createTime", CREATE_TIME_FIELD);
        map.put("updateTime", UPDATE_TIME_FIELD);
        map.put("name", NAME_FIELD);
        map.put("destinationConfiguration", DESTINATION_CONFIGURATION_FIELD);
        map.put("state", STATE_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateLoggingConfigurationResponse, T> g) {
        return obj -> g.apply((CreateLoggingConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IvschatResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String id;
        private Instant createTime;
        private Instant updateTime;
        private String name;
        private DestinationConfiguration destinationConfiguration;
        private String state;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLoggingConfigurationResponse model) {
            super(model);
            this.arn(model.arn);
            this.id(model.id);
            this.createTime(model.createTime);
            this.updateTime(model.updateTime);
            this.name(model.name);
            this.destinationConfiguration(model.destinationConfiguration);
            this.state(model.state);
            this.tags(model.tags);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final DestinationConfiguration.Builder getDestinationConfiguration() {
            return this.destinationConfiguration != null ? this.destinationConfiguration.toBuilder() : null;
        }

        public final void setDestinationConfiguration(DestinationConfiguration.BuilderImpl destinationConfiguration) {
            this.destinationConfiguration = destinationConfiguration != null ? destinationConfiguration.build() : null;
        }

        @Override
        public final Builder destinationConfiguration(DestinationConfiguration destinationConfiguration) {
            this.destinationConfiguration = destinationConfiguration;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CreateLoggingConfigurationState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public CreateLoggingConfigurationResponse build() {
            return new CreateLoggingConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IvschatResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateLoggingConfigurationResponse> {
        public Builder arn(String var1);

        public Builder id(String var1);

        public Builder createTime(Instant var1);

        public Builder updateTime(Instant var1);

        public Builder name(String var1);

        public Builder destinationConfiguration(DestinationConfiguration var1);

        default public Builder destinationConfiguration(Consumer<DestinationConfiguration.Builder> destinationConfiguration) {
            return this.destinationConfiguration((DestinationConfiguration)((DestinationConfiguration.Builder)DestinationConfiguration.builder().applyMutation(destinationConfiguration)).build());
        }

        public Builder state(String var1);

        public Builder state(CreateLoggingConfigurationState var1);

        public Builder tags(Map<String, String> var1);
    }
}

