/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivschat.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ivschat.model.FallbackResult;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MessageReviewHandler
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MessageReviewHandler> {
    private static final SdkField<String> URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("uri").getter(MessageReviewHandler.getter(MessageReviewHandler::uri)).setter(MessageReviewHandler.setter(Builder::uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uri").build()}).build();
    private static final SdkField<String> FALLBACK_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fallbackResult").getter(MessageReviewHandler.getter(MessageReviewHandler::fallbackResultAsString)).setter(MessageReviewHandler.setter(Builder::fallbackResult)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fallbackResult").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(URI_FIELD, FALLBACK_RESULT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MessageReviewHandler.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String uri;
    private final String fallbackResult;

    private MessageReviewHandler(BuilderImpl builder) {
        this.uri = builder.uri;
        this.fallbackResult = builder.fallbackResult;
    }

    public final String uri() {
        return this.uri;
    }

    public final FallbackResult fallbackResult() {
        return FallbackResult.fromValue(this.fallbackResult);
    }

    public final String fallbackResultAsString() {
        return this.fallbackResult;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.fallbackResultAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageReviewHandler)) {
            return false;
        }
        MessageReviewHandler other = (MessageReviewHandler)obj;
        return Objects.equals(this.uri(), other.uri()) && Objects.equals(this.fallbackResultAsString(), other.fallbackResultAsString());
    }

    public final String toString() {
        return ToString.builder((String)"MessageReviewHandler").add("Uri", (Object)this.uri()).add("FallbackResult", (Object)this.fallbackResultAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "uri": {
                return Optional.ofNullable(clazz.cast(this.uri()));
            }
            case "fallbackResult": {
                return Optional.ofNullable(clazz.cast(this.fallbackResultAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("uri", URI_FIELD);
        map.put("fallbackResult", FALLBACK_RESULT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MessageReviewHandler, T> g) {
        return obj -> g.apply((MessageReviewHandler)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String uri;
        private String fallbackResult;

        private BuilderImpl() {
        }

        private BuilderImpl(MessageReviewHandler model) {
            this.uri(model.uri);
            this.fallbackResult(model.fallbackResult);
        }

        public final String getUri() {
            return this.uri;
        }

        public final void setUri(String uri) {
            this.uri = uri;
        }

        @Override
        public final Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public final String getFallbackResult() {
            return this.fallbackResult;
        }

        public final void setFallbackResult(String fallbackResult) {
            this.fallbackResult = fallbackResult;
        }

        @Override
        public final Builder fallbackResult(String fallbackResult) {
            this.fallbackResult = fallbackResult;
            return this;
        }

        @Override
        public final Builder fallbackResult(FallbackResult fallbackResult) {
            this.fallbackResult(fallbackResult == null ? null : fallbackResult.toString());
            return this;
        }

        public MessageReviewHandler build() {
            return new MessageReviewHandler(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MessageReviewHandler> {
        public Builder uri(String var1);

        public Builder fallbackResult(String var1);

        public Builder fallbackResult(FallbackResult var1);
    }
}

