/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivschat.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ivschat.model.ChatTokenAttributesCopier;
import software.amazon.awssdk.services.ivschat.model.ChatTokenCapabilitiesCopier;
import software.amazon.awssdk.services.ivschat.model.ChatTokenCapability;
import software.amazon.awssdk.services.ivschat.model.IvschatRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateChatTokenRequest
extends IvschatRequest
implements ToCopyableBuilder<Builder, CreateChatTokenRequest> {
    private static final SdkField<String> ROOM_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roomIdentifier").getter(CreateChatTokenRequest.getter(CreateChatTokenRequest::roomIdentifier)).setter(CreateChatTokenRequest.setter(Builder::roomIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roomIdentifier").build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userId").getter(CreateChatTokenRequest.getter(CreateChatTokenRequest::userId)).setter(CreateChatTokenRequest.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userId").build()}).build();
    private static final SdkField<List<String>> CAPABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("capabilities").getter(CreateChatTokenRequest.getter(CreateChatTokenRequest::capabilitiesAsStrings)).setter(CreateChatTokenRequest.setter(Builder::capabilitiesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capabilities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> SESSION_DURATION_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("sessionDurationInMinutes").getter(CreateChatTokenRequest.getter(CreateChatTokenRequest::sessionDurationInMinutes)).setter(CreateChatTokenRequest.setter(Builder::sessionDurationInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionDurationInMinutes").build()}).build();
    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("attributes").getter(CreateChatTokenRequest.getter(CreateChatTokenRequest::attributes)).setter(CreateChatTokenRequest.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROOM_IDENTIFIER_FIELD, USER_ID_FIELD, CAPABILITIES_FIELD, SESSION_DURATION_IN_MINUTES_FIELD, ATTRIBUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("roomIdentifier", ROOM_IDENTIFIER_FIELD);
            this.put("userId", USER_ID_FIELD);
            this.put("capabilities", CAPABILITIES_FIELD);
            this.put("sessionDurationInMinutes", SESSION_DURATION_IN_MINUTES_FIELD);
            this.put("attributes", ATTRIBUTES_FIELD);
        }
    });
    private final String roomIdentifier;
    private final String userId;
    private final List<String> capabilities;
    private final Integer sessionDurationInMinutes;
    private final Map<String, String> attributes;

    private CreateChatTokenRequest(BuilderImpl builder) {
        super(builder);
        this.roomIdentifier = builder.roomIdentifier;
        this.userId = builder.userId;
        this.capabilities = builder.capabilities;
        this.sessionDurationInMinutes = builder.sessionDurationInMinutes;
        this.attributes = builder.attributes;
    }

    public final String roomIdentifier() {
        return this.roomIdentifier;
    }

    public final String userId() {
        return this.userId;
    }

    public final List<ChatTokenCapability> capabilities() {
        return ChatTokenCapabilitiesCopier.copyStringToEnum(this.capabilities);
    }

    public final boolean hasCapabilities() {
        return this.capabilities != null && !(this.capabilities instanceof SdkAutoConstructList);
    }

    public final List<String> capabilitiesAsStrings() {
        return this.capabilities;
    }

    public final Integer sessionDurationInMinutes() {
        return this.sessionDurationInMinutes;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> attributes() {
        return this.attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.roomIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCapabilities() ? this.capabilitiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionDurationInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateChatTokenRequest)) {
            return false;
        }
        CreateChatTokenRequest other = (CreateChatTokenRequest)((Object)obj);
        return Objects.equals(this.roomIdentifier(), other.roomIdentifier()) && Objects.equals(this.userId(), other.userId()) && this.hasCapabilities() == other.hasCapabilities() && Objects.equals(this.capabilitiesAsStrings(), other.capabilitiesAsStrings()) && Objects.equals(this.sessionDurationInMinutes(), other.sessionDurationInMinutes()) && this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes());
    }

    public final String toString() {
        return ToString.builder((String)"CreateChatTokenRequest").add("RoomIdentifier", (Object)this.roomIdentifier()).add("UserId", (Object)(this.userId() == null ? null : "*** Sensitive Data Redacted ***")).add("Capabilities", this.hasCapabilities() ? this.capabilitiesAsStrings() : null).add("SessionDurationInMinutes", (Object)this.sessionDurationInMinutes()).add("Attributes", (Object)(this.attributes() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "roomIdentifier": {
                return Optional.ofNullable(clazz.cast(this.roomIdentifier()));
            }
            case "userId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "capabilities": {
                return Optional.ofNullable(clazz.cast(this.capabilitiesAsStrings()));
            }
            case "sessionDurationInMinutes": {
                return Optional.ofNullable(clazz.cast(this.sessionDurationInMinutes()));
            }
            case "attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateChatTokenRequest, T> g) {
        return obj -> g.apply((CreateChatTokenRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IvschatRequest.BuilderImpl
    implements Builder {
        private String roomIdentifier;
        private String userId;
        private List<String> capabilities = DefaultSdkAutoConstructList.getInstance();
        private Integer sessionDurationInMinutes;
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateChatTokenRequest model) {
            super(model);
            this.roomIdentifier(model.roomIdentifier);
            this.userId(model.userId);
            this.capabilitiesWithStrings(model.capabilities);
            this.sessionDurationInMinutes(model.sessionDurationInMinutes);
            this.attributes(model.attributes);
        }

        public final String getRoomIdentifier() {
            return this.roomIdentifier;
        }

        public final void setRoomIdentifier(String roomIdentifier) {
            this.roomIdentifier = roomIdentifier;
        }

        @Override
        public final Builder roomIdentifier(String roomIdentifier) {
            this.roomIdentifier = roomIdentifier;
            return this;
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final Collection<String> getCapabilities() {
            if (this.capabilities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.capabilities;
        }

        public final void setCapabilities(Collection<String> capabilities) {
            this.capabilities = ChatTokenCapabilitiesCopier.copy(capabilities);
        }

        @Override
        public final Builder capabilitiesWithStrings(Collection<String> capabilities) {
            this.capabilities = ChatTokenCapabilitiesCopier.copy(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilitiesWithStrings(String ... capabilities) {
            this.capabilitiesWithStrings(Arrays.asList(capabilities));
            return this;
        }

        @Override
        public final Builder capabilities(Collection<ChatTokenCapability> capabilities) {
            this.capabilities = ChatTokenCapabilitiesCopier.copyEnumToString(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(ChatTokenCapability ... capabilities) {
            this.capabilities(Arrays.asList(capabilities));
            return this;
        }

        public final Integer getSessionDurationInMinutes() {
            return this.sessionDurationInMinutes;
        }

        public final void setSessionDurationInMinutes(Integer sessionDurationInMinutes) {
            this.sessionDurationInMinutes = sessionDurationInMinutes;
        }

        @Override
        public final Builder sessionDurationInMinutes(Integer sessionDurationInMinutes) {
            this.sessionDurationInMinutes = sessionDurationInMinutes;
            return this;
        }

        public final Map<String, String> getAttributes() {
            if (this.attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = ChatTokenAttributesCopier.copy(attributes);
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = ChatTokenAttributesCopier.copy(attributes);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateChatTokenRequest build() {
            return new CreateChatTokenRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IvschatRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateChatTokenRequest> {
        public Builder roomIdentifier(String var1);

        public Builder userId(String var1);

        public Builder capabilitiesWithStrings(Collection<String> var1);

        public Builder capabilitiesWithStrings(String ... var1);

        public Builder capabilities(Collection<ChatTokenCapability> var1);

        public Builder capabilities(ChatTokenCapability ... var1);

        public Builder sessionDurationInMinutes(Integer var1);

        public Builder attributes(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

