/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivschat.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ivschat.model.IvschatRequest;
import software.amazon.awssdk.services.ivschat.model.LoggingConfigurationIdentifierListCopier;
import software.amazon.awssdk.services.ivschat.model.MessageReviewHandler;
import software.amazon.awssdk.services.ivschat.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateRoomRequest
extends IvschatRequest
implements ToCopyableBuilder<Builder, CreateRoomRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateRoomRequest.getter(CreateRoomRequest::name)).setter(CreateRoomRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Integer> MAXIMUM_MESSAGE_RATE_PER_SECOND_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maximumMessageRatePerSecond").getter(CreateRoomRequest.getter(CreateRoomRequest::maximumMessageRatePerSecond)).setter(CreateRoomRequest.setter(Builder::maximumMessageRatePerSecond)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumMessageRatePerSecond").build()}).build();
    private static final SdkField<Integer> MAXIMUM_MESSAGE_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maximumMessageLength").getter(CreateRoomRequest.getter(CreateRoomRequest::maximumMessageLength)).setter(CreateRoomRequest.setter(Builder::maximumMessageLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumMessageLength").build()}).build();
    private static final SdkField<MessageReviewHandler> MESSAGE_REVIEW_HANDLER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("messageReviewHandler").getter(CreateRoomRequest.getter(CreateRoomRequest::messageReviewHandler)).setter(CreateRoomRequest.setter(Builder::messageReviewHandler)).constructor(MessageReviewHandler::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageReviewHandler").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateRoomRequest.getter(CreateRoomRequest::tags)).setter(CreateRoomRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<String>> LOGGING_CONFIGURATION_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("loggingConfigurationIdentifiers").getter(CreateRoomRequest.getter(CreateRoomRequest::loggingConfigurationIdentifiers)).setter(CreateRoomRequest.setter(Builder::loggingConfigurationIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loggingConfigurationIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, MAXIMUM_MESSAGE_RATE_PER_SECOND_FIELD, MAXIMUM_MESSAGE_LENGTH_FIELD, MESSAGE_REVIEW_HANDLER_FIELD, TAGS_FIELD, LOGGING_CONFIGURATION_IDENTIFIERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("name", NAME_FIELD);
            this.put("maximumMessageRatePerSecond", MAXIMUM_MESSAGE_RATE_PER_SECOND_FIELD);
            this.put("maximumMessageLength", MAXIMUM_MESSAGE_LENGTH_FIELD);
            this.put("messageReviewHandler", MESSAGE_REVIEW_HANDLER_FIELD);
            this.put("tags", TAGS_FIELD);
            this.put("loggingConfigurationIdentifiers", LOGGING_CONFIGURATION_IDENTIFIERS_FIELD);
        }
    });
    private final String name;
    private final Integer maximumMessageRatePerSecond;
    private final Integer maximumMessageLength;
    private final MessageReviewHandler messageReviewHandler;
    private final Map<String, String> tags;
    private final List<String> loggingConfigurationIdentifiers;

    private CreateRoomRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.maximumMessageRatePerSecond = builder.maximumMessageRatePerSecond;
        this.maximumMessageLength = builder.maximumMessageLength;
        this.messageReviewHandler = builder.messageReviewHandler;
        this.tags = builder.tags;
        this.loggingConfigurationIdentifiers = builder.loggingConfigurationIdentifiers;
    }

    public final String name() {
        return this.name;
    }

    public final Integer maximumMessageRatePerSecond() {
        return this.maximumMessageRatePerSecond;
    }

    public final Integer maximumMessageLength() {
        return this.maximumMessageLength;
    }

    public final MessageReviewHandler messageReviewHandler() {
        return this.messageReviewHandler;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final boolean hasLoggingConfigurationIdentifiers() {
        return this.loggingConfigurationIdentifiers != null && !(this.loggingConfigurationIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<String> loggingConfigurationIdentifiers() {
        return this.loggingConfigurationIdentifiers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumMessageRatePerSecond());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumMessageLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageReviewHandler());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLoggingConfigurationIdentifiers() ? this.loggingConfigurationIdentifiers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRoomRequest)) {
            return false;
        }
        CreateRoomRequest other = (CreateRoomRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.maximumMessageRatePerSecond(), other.maximumMessageRatePerSecond()) && Objects.equals(this.maximumMessageLength(), other.maximumMessageLength()) && Objects.equals(this.messageReviewHandler(), other.messageReviewHandler()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasLoggingConfigurationIdentifiers() == other.hasLoggingConfigurationIdentifiers() && Objects.equals(this.loggingConfigurationIdentifiers(), other.loggingConfigurationIdentifiers());
    }

    public final String toString() {
        return ToString.builder((String)"CreateRoomRequest").add("Name", (Object)this.name()).add("MaximumMessageRatePerSecond", (Object)this.maximumMessageRatePerSecond()).add("MaximumMessageLength", (Object)this.maximumMessageLength()).add("MessageReviewHandler", (Object)this.messageReviewHandler()).add("Tags", this.hasTags() ? this.tags() : null).add("LoggingConfigurationIdentifiers", this.hasLoggingConfigurationIdentifiers() ? this.loggingConfigurationIdentifiers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "maximumMessageRatePerSecond": {
                return Optional.ofNullable(clazz.cast(this.maximumMessageRatePerSecond()));
            }
            case "maximumMessageLength": {
                return Optional.ofNullable(clazz.cast(this.maximumMessageLength()));
            }
            case "messageReviewHandler": {
                return Optional.ofNullable(clazz.cast(this.messageReviewHandler()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "loggingConfigurationIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.loggingConfigurationIdentifiers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateRoomRequest, T> g) {
        return obj -> g.apply((CreateRoomRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IvschatRequest.BuilderImpl
    implements Builder {
        private String name;
        private Integer maximumMessageRatePerSecond;
        private Integer maximumMessageLength;
        private MessageReviewHandler messageReviewHandler;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private List<String> loggingConfigurationIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRoomRequest model) {
            super(model);
            this.name(model.name);
            this.maximumMessageRatePerSecond(model.maximumMessageRatePerSecond);
            this.maximumMessageLength(model.maximumMessageLength);
            this.messageReviewHandler(model.messageReviewHandler);
            this.tags(model.tags);
            this.loggingConfigurationIdentifiers(model.loggingConfigurationIdentifiers);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getMaximumMessageRatePerSecond() {
            return this.maximumMessageRatePerSecond;
        }

        public final void setMaximumMessageRatePerSecond(Integer maximumMessageRatePerSecond) {
            this.maximumMessageRatePerSecond = maximumMessageRatePerSecond;
        }

        @Override
        public final Builder maximumMessageRatePerSecond(Integer maximumMessageRatePerSecond) {
            this.maximumMessageRatePerSecond = maximumMessageRatePerSecond;
            return this;
        }

        public final Integer getMaximumMessageLength() {
            return this.maximumMessageLength;
        }

        public final void setMaximumMessageLength(Integer maximumMessageLength) {
            this.maximumMessageLength = maximumMessageLength;
        }

        @Override
        public final Builder maximumMessageLength(Integer maximumMessageLength) {
            this.maximumMessageLength = maximumMessageLength;
            return this;
        }

        public final MessageReviewHandler.Builder getMessageReviewHandler() {
            return this.messageReviewHandler != null ? this.messageReviewHandler.toBuilder() : null;
        }

        public final void setMessageReviewHandler(MessageReviewHandler.BuilderImpl messageReviewHandler) {
            this.messageReviewHandler = messageReviewHandler != null ? messageReviewHandler.build() : null;
        }

        @Override
        public final Builder messageReviewHandler(MessageReviewHandler messageReviewHandler) {
            this.messageReviewHandler = messageReviewHandler;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final Collection<String> getLoggingConfigurationIdentifiers() {
            if (this.loggingConfigurationIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.loggingConfigurationIdentifiers;
        }

        public final void setLoggingConfigurationIdentifiers(Collection<String> loggingConfigurationIdentifiers) {
            this.loggingConfigurationIdentifiers = LoggingConfigurationIdentifierListCopier.copy(loggingConfigurationIdentifiers);
        }

        @Override
        public final Builder loggingConfigurationIdentifiers(Collection<String> loggingConfigurationIdentifiers) {
            this.loggingConfigurationIdentifiers = LoggingConfigurationIdentifierListCopier.copy(loggingConfigurationIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loggingConfigurationIdentifiers(String ... loggingConfigurationIdentifiers) {
            this.loggingConfigurationIdentifiers(Arrays.asList(loggingConfigurationIdentifiers));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRoomRequest build() {
            return new CreateRoomRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IvschatRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateRoomRequest> {
        public Builder name(String var1);

        public Builder maximumMessageRatePerSecond(Integer var1);

        public Builder maximumMessageLength(Integer var1);

        public Builder messageReviewHandler(MessageReviewHandler var1);

        default public Builder messageReviewHandler(Consumer<MessageReviewHandler.Builder> messageReviewHandler) {
            return this.messageReviewHandler((MessageReviewHandler)((MessageReviewHandler.Builder)MessageReviewHandler.builder().applyMutation(messageReviewHandler)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder loggingConfigurationIdentifiers(Collection<String> var1);

        public Builder loggingConfigurationIdentifiers(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

