/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivschat.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ivschat.IvschatClient;
import software.amazon.awssdk.services.ivschat.model.ListRoomsRequest;
import software.amazon.awssdk.services.ivschat.model.ListRoomsResponse;

public class ListRoomsIterable
implements SdkIterable<ListRoomsResponse> {
    private final IvschatClient client;
    private final ListRoomsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRoomsIterable(IvschatClient client, ListRoomsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListRoomsResponseFetcher();
    }

    public Iterator<ListRoomsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListRoomsResponseFetcher
    implements SyncPageFetcher<ListRoomsResponse> {
        private ListRoomsResponseFetcher() {
        }

        public boolean hasNextPage(ListRoomsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRoomsResponse nextPage(ListRoomsResponse previousPage) {
            if (previousPage == null) {
                return ListRoomsIterable.this.client.listRooms(ListRoomsIterable.this.firstRequest);
            }
            return ListRoomsIterable.this.client.listRooms((ListRoomsRequest)((Object)ListRoomsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

