/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ivs.model.IvsResponse;
import software.amazon.awssdk.services.ivs.model.PlaybackRestrictionPolicyListCopier;
import software.amazon.awssdk.services.ivs.model.PlaybackRestrictionPolicySummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPlaybackRestrictionPoliciesResponse
extends IvsResponse
implements ToCopyableBuilder<Builder, ListPlaybackRestrictionPoliciesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListPlaybackRestrictionPoliciesResponse.getter(ListPlaybackRestrictionPoliciesResponse::nextToken)).setter(ListPlaybackRestrictionPoliciesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<PlaybackRestrictionPolicySummary>> PLAYBACK_RESTRICTION_POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("playbackRestrictionPolicies").getter(ListPlaybackRestrictionPoliciesResponse.getter(ListPlaybackRestrictionPoliciesResponse::playbackRestrictionPolicies)).setter(ListPlaybackRestrictionPoliciesResponse.setter(Builder::playbackRestrictionPolicies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("playbackRestrictionPolicies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PlaybackRestrictionPolicySummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, PLAYBACK_RESTRICTION_POLICIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListPlaybackRestrictionPoliciesResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<PlaybackRestrictionPolicySummary> playbackRestrictionPolicies;

    private ListPlaybackRestrictionPoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.playbackRestrictionPolicies = builder.playbackRestrictionPolicies;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasPlaybackRestrictionPolicies() {
        return this.playbackRestrictionPolicies != null && !(this.playbackRestrictionPolicies instanceof SdkAutoConstructList);
    }

    public final List<PlaybackRestrictionPolicySummary> playbackRestrictionPolicies() {
        return this.playbackRestrictionPolicies;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPlaybackRestrictionPolicies() ? this.playbackRestrictionPolicies() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPlaybackRestrictionPoliciesResponse)) {
            return false;
        }
        ListPlaybackRestrictionPoliciesResponse other = (ListPlaybackRestrictionPoliciesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasPlaybackRestrictionPolicies() == other.hasPlaybackRestrictionPolicies() && Objects.equals(this.playbackRestrictionPolicies(), other.playbackRestrictionPolicies());
    }

    public final String toString() {
        return ToString.builder((String)"ListPlaybackRestrictionPoliciesResponse").add("NextToken", (Object)this.nextToken()).add("PlaybackRestrictionPolicies", this.hasPlaybackRestrictionPolicies() ? this.playbackRestrictionPolicies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "playbackRestrictionPolicies": {
                return Optional.ofNullable(clazz.cast(this.playbackRestrictionPolicies()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("playbackRestrictionPolicies", PLAYBACK_RESTRICTION_POLICIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPlaybackRestrictionPoliciesResponse, T> g) {
        return obj -> g.apply((ListPlaybackRestrictionPoliciesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IvsResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<PlaybackRestrictionPolicySummary> playbackRestrictionPolicies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListPlaybackRestrictionPoliciesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.playbackRestrictionPolicies(model.playbackRestrictionPolicies);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<PlaybackRestrictionPolicySummary.Builder> getPlaybackRestrictionPolicies() {
            List<PlaybackRestrictionPolicySummary.Builder> result = PlaybackRestrictionPolicyListCopier.copyToBuilder(this.playbackRestrictionPolicies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPlaybackRestrictionPolicies(Collection<PlaybackRestrictionPolicySummary.BuilderImpl> playbackRestrictionPolicies) {
            this.playbackRestrictionPolicies = PlaybackRestrictionPolicyListCopier.copyFromBuilder(playbackRestrictionPolicies);
        }

        @Override
        public final Builder playbackRestrictionPolicies(Collection<PlaybackRestrictionPolicySummary> playbackRestrictionPolicies) {
            this.playbackRestrictionPolicies = PlaybackRestrictionPolicyListCopier.copy(playbackRestrictionPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder playbackRestrictionPolicies(PlaybackRestrictionPolicySummary ... playbackRestrictionPolicies) {
            this.playbackRestrictionPolicies(Arrays.asList(playbackRestrictionPolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder playbackRestrictionPolicies(Consumer<PlaybackRestrictionPolicySummary.Builder> ... playbackRestrictionPolicies) {
            this.playbackRestrictionPolicies(Stream.of(playbackRestrictionPolicies).map(c -> (PlaybackRestrictionPolicySummary)((PlaybackRestrictionPolicySummary.Builder)PlaybackRestrictionPolicySummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListPlaybackRestrictionPoliciesResponse build() {
            return new ListPlaybackRestrictionPoliciesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IvsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPlaybackRestrictionPoliciesResponse> {
        public Builder nextToken(String var1);

        public Builder playbackRestrictionPolicies(Collection<PlaybackRestrictionPolicySummary> var1);

        public Builder playbackRestrictionPolicies(PlaybackRestrictionPolicySummary ... var1);

        public Builder playbackRestrictionPolicies(Consumer<PlaybackRestrictionPolicySummary.Builder> ... var1);
    }
}

