/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ivs.model.AudioConfiguration;
import software.amazon.awssdk.services.ivs.model.AudioConfigurationListCopier;
import software.amazon.awssdk.services.ivs.model.VideoConfiguration;
import software.amazon.awssdk.services.ivs.model.VideoConfigurationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IngestConfigurations
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IngestConfigurations> {
    private static final SdkField<List<AudioConfiguration>> AUDIO_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("audioConfigurations").getter(IngestConfigurations.getter(IngestConfigurations::audioConfigurations)).setter(IngestConfigurations.setter(Builder::audioConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AudioConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<VideoConfiguration>> VIDEO_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("videoConfigurations").getter(IngestConfigurations.getter(IngestConfigurations::videoConfigurations)).setter(IngestConfigurations.setter(Builder::videoConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("videoConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VideoConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_CONFIGURATIONS_FIELD, VIDEO_CONFIGURATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IngestConfigurations.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<AudioConfiguration> audioConfigurations;
    private final List<VideoConfiguration> videoConfigurations;

    private IngestConfigurations(BuilderImpl builder) {
        this.audioConfigurations = builder.audioConfigurations;
        this.videoConfigurations = builder.videoConfigurations;
    }

    public final boolean hasAudioConfigurations() {
        return this.audioConfigurations != null && !(this.audioConfigurations instanceof SdkAutoConstructList);
    }

    public final List<AudioConfiguration> audioConfigurations() {
        return this.audioConfigurations;
    }

    public final boolean hasVideoConfigurations() {
        return this.videoConfigurations != null && !(this.videoConfigurations instanceof SdkAutoConstructList);
    }

    public final List<VideoConfiguration> videoConfigurations() {
        return this.videoConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAudioConfigurations() ? this.audioConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVideoConfigurations() ? this.videoConfigurations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IngestConfigurations)) {
            return false;
        }
        IngestConfigurations other = (IngestConfigurations)obj;
        return this.hasAudioConfigurations() == other.hasAudioConfigurations() && Objects.equals(this.audioConfigurations(), other.audioConfigurations()) && this.hasVideoConfigurations() == other.hasVideoConfigurations() && Objects.equals(this.videoConfigurations(), other.videoConfigurations());
    }

    public final String toString() {
        return ToString.builder((String)"IngestConfigurations").add("AudioConfigurations", this.hasAudioConfigurations() ? this.audioConfigurations() : null).add("VideoConfigurations", this.hasVideoConfigurations() ? this.videoConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "audioConfigurations": {
                return Optional.ofNullable(clazz.cast(this.audioConfigurations()));
            }
            case "videoConfigurations": {
                return Optional.ofNullable(clazz.cast(this.videoConfigurations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("audioConfigurations", AUDIO_CONFIGURATIONS_FIELD);
        map.put("videoConfigurations", VIDEO_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IngestConfigurations, T> g) {
        return obj -> g.apply((IngestConfigurations)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AudioConfiguration> audioConfigurations = DefaultSdkAutoConstructList.getInstance();
        private List<VideoConfiguration> videoConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IngestConfigurations model) {
            this.audioConfigurations(model.audioConfigurations);
            this.videoConfigurations(model.videoConfigurations);
        }

        public final List<AudioConfiguration.Builder> getAudioConfigurations() {
            List<AudioConfiguration.Builder> result = AudioConfigurationListCopier.copyToBuilder(this.audioConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAudioConfigurations(Collection<AudioConfiguration.BuilderImpl> audioConfigurations) {
            this.audioConfigurations = AudioConfigurationListCopier.copyFromBuilder(audioConfigurations);
        }

        @Override
        public final Builder audioConfigurations(Collection<AudioConfiguration> audioConfigurations) {
            this.audioConfigurations = AudioConfigurationListCopier.copy(audioConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audioConfigurations(AudioConfiguration ... audioConfigurations) {
            this.audioConfigurations(Arrays.asList(audioConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audioConfigurations(Consumer<AudioConfiguration.Builder> ... audioConfigurations) {
            this.audioConfigurations(Stream.of(audioConfigurations).map(c -> (AudioConfiguration)((AudioConfiguration.Builder)AudioConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<VideoConfiguration.Builder> getVideoConfigurations() {
            List<VideoConfiguration.Builder> result = VideoConfigurationListCopier.copyToBuilder(this.videoConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVideoConfigurations(Collection<VideoConfiguration.BuilderImpl> videoConfigurations) {
            this.videoConfigurations = VideoConfigurationListCopier.copyFromBuilder(videoConfigurations);
        }

        @Override
        public final Builder videoConfigurations(Collection<VideoConfiguration> videoConfigurations) {
            this.videoConfigurations = VideoConfigurationListCopier.copy(videoConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder videoConfigurations(VideoConfiguration ... videoConfigurations) {
            this.videoConfigurations(Arrays.asList(videoConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder videoConfigurations(Consumer<VideoConfiguration.Builder> ... videoConfigurations) {
            this.videoConfigurations(Stream.of(videoConfigurations).map(c -> (VideoConfiguration)((VideoConfiguration.Builder)VideoConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public IngestConfigurations build() {
            return new IngestConfigurations(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IngestConfigurations> {
        public Builder audioConfigurations(Collection<AudioConfiguration> var1);

        public Builder audioConfigurations(AudioConfiguration ... var1);

        public Builder audioConfigurations(Consumer<AudioConfiguration.Builder> ... var1);

        public Builder videoConfigurations(Collection<VideoConfiguration> var1);

        public Builder videoConfigurations(VideoConfiguration ... var1);

        public Builder videoConfigurations(Consumer<VideoConfiguration.Builder> ... var1);
    }
}

