/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ivs.model.IvsResponse;
import software.amazon.awssdk.services.ivs.model.StreamSessionListCopier;
import software.amazon.awssdk.services.ivs.model.StreamSessionSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListStreamSessionsResponse
extends IvsResponse
implements ToCopyableBuilder<Builder, ListStreamSessionsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListStreamSessionsResponse.getter(ListStreamSessionsResponse::nextToken)).setter(ListStreamSessionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<StreamSessionSummary>> STREAM_SESSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("streamSessions").getter(ListStreamSessionsResponse.getter(ListStreamSessionsResponse::streamSessions)).setter(ListStreamSessionsResponse.setter(Builder::streamSessions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamSessions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StreamSessionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, STREAM_SESSIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("streamSessions", STREAM_SESSIONS_FIELD);
        }
    });
    private final String nextToken;
    private final List<StreamSessionSummary> streamSessions;

    private ListStreamSessionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.streamSessions = builder.streamSessions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasStreamSessions() {
        return this.streamSessions != null && !(this.streamSessions instanceof SdkAutoConstructList);
    }

    public final List<StreamSessionSummary> streamSessions() {
        return this.streamSessions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStreamSessions() ? this.streamSessions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStreamSessionsResponse)) {
            return false;
        }
        ListStreamSessionsResponse other = (ListStreamSessionsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasStreamSessions() == other.hasStreamSessions() && Objects.equals(this.streamSessions(), other.streamSessions());
    }

    public final String toString() {
        return ToString.builder((String)"ListStreamSessionsResponse").add("NextToken", (Object)this.nextToken()).add("StreamSessions", this.hasStreamSessions() ? this.streamSessions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "streamSessions": {
                return Optional.ofNullable(clazz.cast(this.streamSessions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListStreamSessionsResponse, T> g) {
        return obj -> g.apply((ListStreamSessionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IvsResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<StreamSessionSummary> streamSessions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListStreamSessionsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.streamSessions(model.streamSessions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<StreamSessionSummary.Builder> getStreamSessions() {
            List<StreamSessionSummary.Builder> result = StreamSessionListCopier.copyToBuilder(this.streamSessions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStreamSessions(Collection<StreamSessionSummary.BuilderImpl> streamSessions) {
            this.streamSessions = StreamSessionListCopier.copyFromBuilder(streamSessions);
        }

        @Override
        public final Builder streamSessions(Collection<StreamSessionSummary> streamSessions) {
            this.streamSessions = StreamSessionListCopier.copy(streamSessions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder streamSessions(StreamSessionSummary ... streamSessions) {
            this.streamSessions(Arrays.asList(streamSessions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder streamSessions(Consumer<StreamSessionSummary.Builder> ... streamSessions) {
            this.streamSessions(Stream.of(streamSessions).map(c -> (StreamSessionSummary)((StreamSessionSummary.Builder)StreamSessionSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListStreamSessionsResponse build() {
            return new ListStreamSessionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IvsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListStreamSessionsResponse> {
        public Builder nextToken(String var1);

        public Builder streamSessions(Collection<StreamSessionSummary> var1);

        public Builder streamSessions(StreamSessionSummary ... var1);

        public Builder streamSessions(Consumer<StreamSessionSummary.Builder> ... var1);
    }
}

