/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ivs.model.AudioConfiguration;
import software.amazon.awssdk.services.ivs.model.VideoConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IngestConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IngestConfiguration> {
    private static final SdkField<VideoConfiguration> VIDEO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("video").getter(IngestConfiguration.getter(IngestConfiguration::video)).setter(IngestConfiguration.setter(Builder::video)).constructor(VideoConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("video").build()}).build();
    private static final SdkField<AudioConfiguration> AUDIO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("audio").getter(IngestConfiguration.getter(IngestConfiguration::audio)).setter(IngestConfiguration.setter(Builder::audio)).constructor(AudioConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audio").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIDEO_FIELD, AUDIO_FIELD));
    private static final long serialVersionUID = 1L;
    private final VideoConfiguration video;
    private final AudioConfiguration audio;

    private IngestConfiguration(BuilderImpl builder) {
        this.video = builder.video;
        this.audio = builder.audio;
    }

    public final VideoConfiguration video() {
        return this.video;
    }

    public final AudioConfiguration audio() {
        return this.audio;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.video());
        hashCode = 31 * hashCode + Objects.hashCode(this.audio());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IngestConfiguration)) {
            return false;
        }
        IngestConfiguration other = (IngestConfiguration)obj;
        return Objects.equals(this.video(), other.video()) && Objects.equals(this.audio(), other.audio());
    }

    public final String toString() {
        return ToString.builder((String)"IngestConfiguration").add("Video", (Object)this.video()).add("Audio", (Object)this.audio()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "video": {
                return Optional.ofNullable(clazz.cast(this.video()));
            }
            case "audio": {
                return Optional.ofNullable(clazz.cast(this.audio()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IngestConfiguration, T> g) {
        return obj -> g.apply((IngestConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private VideoConfiguration video;
        private AudioConfiguration audio;

        private BuilderImpl() {
        }

        private BuilderImpl(IngestConfiguration model) {
            this.video(model.video);
            this.audio(model.audio);
        }

        public final VideoConfiguration.Builder getVideo() {
            return this.video != null ? this.video.toBuilder() : null;
        }

        public final void setVideo(VideoConfiguration.BuilderImpl video) {
            this.video = video != null ? video.build() : null;
        }

        @Override
        public final Builder video(VideoConfiguration video) {
            this.video = video;
            return this;
        }

        public final AudioConfiguration.Builder getAudio() {
            return this.audio != null ? this.audio.toBuilder() : null;
        }

        public final void setAudio(AudioConfiguration.BuilderImpl audio) {
            this.audio = audio != null ? audio.build() : null;
        }

        @Override
        public final Builder audio(AudioConfiguration audio) {
            this.audio = audio;
            return this;
        }

        public IngestConfiguration build() {
            return new IngestConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IngestConfiguration> {
        public Builder video(VideoConfiguration var1);

        default public Builder video(Consumer<VideoConfiguration.Builder> video) {
            return this.video((VideoConfiguration)((VideoConfiguration.Builder)VideoConfiguration.builder().applyMutation(video)).build());
        }

        public Builder audio(AudioConfiguration var1);

        default public Builder audio(Consumer<AudioConfiguration.Builder> audio) {
            return this.audio((AudioConfiguration)((AudioConfiguration.Builder)AudioConfiguration.builder().applyMutation(audio)).build());
        }
    }
}

