/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ivs.model.Channel;
import software.amazon.awssdk.services.ivs.model.IngestConfiguration;
import software.amazon.awssdk.services.ivs.model.RecordingConfiguration;
import software.amazon.awssdk.services.ivs.model.StreamEvent;
import software.amazon.awssdk.services.ivs.model.StreamEventsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StreamSession
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StreamSession> {
    private static final SdkField<String> STREAM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("streamId").getter(StreamSession.getter(StreamSession::streamId)).setter(StreamSession.setter(Builder::streamId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamId").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(StreamSession.getter(StreamSession::startTime)).setter(StreamSession.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(StreamSession.getter(StreamSession::endTime)).setter(StreamSession.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Channel> CHANNEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("channel").getter(StreamSession.getter(StreamSession::channel)).setter(StreamSession.setter(Builder::channel)).constructor(Channel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channel").build()}).build();
    private static final SdkField<IngestConfiguration> INGEST_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ingestConfiguration").getter(StreamSession.getter(StreamSession::ingestConfiguration)).setter(StreamSession.setter(Builder::ingestConfiguration)).constructor(IngestConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingestConfiguration").build()}).build();
    private static final SdkField<RecordingConfiguration> RECORDING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("recordingConfiguration").getter(StreamSession.getter(StreamSession::recordingConfiguration)).setter(StreamSession.setter(Builder::recordingConfiguration)).constructor(RecordingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordingConfiguration").build()}).build();
    private static final SdkField<List<StreamEvent>> TRUNCATED_EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("truncatedEvents").getter(StreamSession.getter(StreamSession::truncatedEvents)).setter(StreamSession.setter(Builder::truncatedEvents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("truncatedEvents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StreamEvent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_ID_FIELD, START_TIME_FIELD, END_TIME_FIELD, CHANNEL_FIELD, INGEST_CONFIGURATION_FIELD, RECORDING_CONFIGURATION_FIELD, TRUNCATED_EVENTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String streamId;
    private final Instant startTime;
    private final Instant endTime;
    private final Channel channel;
    private final IngestConfiguration ingestConfiguration;
    private final RecordingConfiguration recordingConfiguration;
    private final List<StreamEvent> truncatedEvents;

    private StreamSession(BuilderImpl builder) {
        this.streamId = builder.streamId;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.channel = builder.channel;
        this.ingestConfiguration = builder.ingestConfiguration;
        this.recordingConfiguration = builder.recordingConfiguration;
        this.truncatedEvents = builder.truncatedEvents;
    }

    public final String streamId() {
        return this.streamId;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final Channel channel() {
        return this.channel;
    }

    public final IngestConfiguration ingestConfiguration() {
        return this.ingestConfiguration;
    }

    public final RecordingConfiguration recordingConfiguration() {
        return this.recordingConfiguration;
    }

    public final boolean hasTruncatedEvents() {
        return this.truncatedEvents != null && !(this.truncatedEvents instanceof SdkAutoConstructList);
    }

    public final List<StreamEvent> truncatedEvents() {
        return this.truncatedEvents;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.streamId());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.channel());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingestConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTruncatedEvents() ? this.truncatedEvents() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamSession)) {
            return false;
        }
        StreamSession other = (StreamSession)obj;
        return Objects.equals(this.streamId(), other.streamId()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.channel(), other.channel()) && Objects.equals(this.ingestConfiguration(), other.ingestConfiguration()) && Objects.equals(this.recordingConfiguration(), other.recordingConfiguration()) && this.hasTruncatedEvents() == other.hasTruncatedEvents() && Objects.equals(this.truncatedEvents(), other.truncatedEvents());
    }

    public final String toString() {
        return ToString.builder((String)"StreamSession").add("StreamId", (Object)this.streamId()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("Channel", (Object)this.channel()).add("IngestConfiguration", (Object)this.ingestConfiguration()).add("RecordingConfiguration", (Object)this.recordingConfiguration()).add("TruncatedEvents", this.hasTruncatedEvents() ? this.truncatedEvents() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "streamId": {
                return Optional.ofNullable(clazz.cast(this.streamId()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "channel": {
                return Optional.ofNullable(clazz.cast(this.channel()));
            }
            case "ingestConfiguration": {
                return Optional.ofNullable(clazz.cast(this.ingestConfiguration()));
            }
            case "recordingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.recordingConfiguration()));
            }
            case "truncatedEvents": {
                return Optional.ofNullable(clazz.cast(this.truncatedEvents()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StreamSession, T> g) {
        return obj -> g.apply((StreamSession)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String streamId;
        private Instant startTime;
        private Instant endTime;
        private Channel channel;
        private IngestConfiguration ingestConfiguration;
        private RecordingConfiguration recordingConfiguration;
        private List<StreamEvent> truncatedEvents = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StreamSession model) {
            this.streamId(model.streamId);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.channel(model.channel);
            this.ingestConfiguration(model.ingestConfiguration);
            this.recordingConfiguration(model.recordingConfiguration);
            this.truncatedEvents(model.truncatedEvents);
        }

        public final String getStreamId() {
            return this.streamId;
        }

        public final void setStreamId(String streamId) {
            this.streamId = streamId;
        }

        @Override
        public final Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Channel.Builder getChannel() {
            return this.channel != null ? this.channel.toBuilder() : null;
        }

        public final void setChannel(Channel.BuilderImpl channel) {
            this.channel = channel != null ? channel.build() : null;
        }

        @Override
        public final Builder channel(Channel channel) {
            this.channel = channel;
            return this;
        }

        public final IngestConfiguration.Builder getIngestConfiguration() {
            return this.ingestConfiguration != null ? this.ingestConfiguration.toBuilder() : null;
        }

        public final void setIngestConfiguration(IngestConfiguration.BuilderImpl ingestConfiguration) {
            this.ingestConfiguration = ingestConfiguration != null ? ingestConfiguration.build() : null;
        }

        @Override
        public final Builder ingestConfiguration(IngestConfiguration ingestConfiguration) {
            this.ingestConfiguration = ingestConfiguration;
            return this;
        }

        public final RecordingConfiguration.Builder getRecordingConfiguration() {
            return this.recordingConfiguration != null ? this.recordingConfiguration.toBuilder() : null;
        }

        public final void setRecordingConfiguration(RecordingConfiguration.BuilderImpl recordingConfiguration) {
            this.recordingConfiguration = recordingConfiguration != null ? recordingConfiguration.build() : null;
        }

        @Override
        public final Builder recordingConfiguration(RecordingConfiguration recordingConfiguration) {
            this.recordingConfiguration = recordingConfiguration;
            return this;
        }

        public final List<StreamEvent.Builder> getTruncatedEvents() {
            List<StreamEvent.Builder> result = StreamEventsCopier.copyToBuilder(this.truncatedEvents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTruncatedEvents(Collection<StreamEvent.BuilderImpl> truncatedEvents) {
            this.truncatedEvents = StreamEventsCopier.copyFromBuilder(truncatedEvents);
        }

        @Override
        public final Builder truncatedEvents(Collection<StreamEvent> truncatedEvents) {
            this.truncatedEvents = StreamEventsCopier.copy(truncatedEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder truncatedEvents(StreamEvent ... truncatedEvents) {
            this.truncatedEvents(Arrays.asList(truncatedEvents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder truncatedEvents(Consumer<StreamEvent.Builder> ... truncatedEvents) {
            this.truncatedEvents(Stream.of(truncatedEvents).map(c -> (StreamEvent)((StreamEvent.Builder)StreamEvent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public StreamSession build() {
            return new StreamSession(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StreamSession> {
        public Builder streamId(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder channel(Channel var1);

        default public Builder channel(Consumer<Channel.Builder> channel) {
            return this.channel((Channel)((Channel.Builder)Channel.builder().applyMutation(channel)).build());
        }

        public Builder ingestConfiguration(IngestConfiguration var1);

        default public Builder ingestConfiguration(Consumer<IngestConfiguration.Builder> ingestConfiguration) {
            return this.ingestConfiguration((IngestConfiguration)((IngestConfiguration.Builder)IngestConfiguration.builder().applyMutation(ingestConfiguration)).build());
        }

        public Builder recordingConfiguration(RecordingConfiguration var1);

        default public Builder recordingConfiguration(Consumer<RecordingConfiguration.Builder> recordingConfiguration) {
            return this.recordingConfiguration((RecordingConfiguration)((RecordingConfiguration.Builder)RecordingConfiguration.builder().applyMutation(recordingConfiguration)).build());
        }

        public Builder truncatedEvents(Collection<StreamEvent> var1);

        public Builder truncatedEvents(StreamEvent ... var1);

        public Builder truncatedEvents(Consumer<StreamEvent.Builder> ... var1);
    }
}

