/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AudioConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AudioConfiguration> {
    private static final SdkField<String> CODEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("codec").getter(AudioConfiguration.getter(AudioConfiguration::codec)).setter(AudioConfiguration.setter(Builder::codec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codec").build()}).build();
    private static final SdkField<Long> TARGET_BITRATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("targetBitrate").getter(AudioConfiguration.getter(AudioConfiguration::targetBitrate)).setter(AudioConfiguration.setter(Builder::targetBitrate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetBitrate").build()}).build();
    private static final SdkField<Long> SAMPLE_RATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("sampleRate").getter(AudioConfiguration.getter(AudioConfiguration::sampleRate)).setter(AudioConfiguration.setter(Builder::sampleRate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleRate").build()}).build();
    private static final SdkField<Long> CHANNELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("channels").getter(AudioConfiguration.getter(AudioConfiguration::channels)).setter(AudioConfiguration.setter(Builder::channels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channels").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODEC_FIELD, TARGET_BITRATE_FIELD, SAMPLE_RATE_FIELD, CHANNELS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String codec;
    private final Long targetBitrate;
    private final Long sampleRate;
    private final Long channels;

    private AudioConfiguration(BuilderImpl builder) {
        this.codec = builder.codec;
        this.targetBitrate = builder.targetBitrate;
        this.sampleRate = builder.sampleRate;
        this.channels = builder.channels;
    }

    public final String codec() {
        return this.codec;
    }

    public final Long targetBitrate() {
        return this.targetBitrate;
    }

    public final Long sampleRate() {
        return this.sampleRate;
    }

    public final Long channels() {
        return this.channels;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.codec());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleRate());
        hashCode = 31 * hashCode + Objects.hashCode(this.channels());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioConfiguration)) {
            return false;
        }
        AudioConfiguration other = (AudioConfiguration)obj;
        return Objects.equals(this.codec(), other.codec()) && Objects.equals(this.targetBitrate(), other.targetBitrate()) && Objects.equals(this.sampleRate(), other.sampleRate()) && Objects.equals(this.channels(), other.channels());
    }

    public final String toString() {
        return ToString.builder((String)"AudioConfiguration").add("Codec", (Object)this.codec()).add("TargetBitrate", (Object)this.targetBitrate()).add("SampleRate", (Object)this.sampleRate()).add("Channels", (Object)this.channels()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "codec": {
                return Optional.ofNullable(clazz.cast(this.codec()));
            }
            case "targetBitrate": {
                return Optional.ofNullable(clazz.cast(this.targetBitrate()));
            }
            case "sampleRate": {
                return Optional.ofNullable(clazz.cast(this.sampleRate()));
            }
            case "channels": {
                return Optional.ofNullable(clazz.cast(this.channels()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AudioConfiguration, T> g) {
        return obj -> g.apply((AudioConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String codec;
        private Long targetBitrate;
        private Long sampleRate;
        private Long channels;

        private BuilderImpl() {
        }

        private BuilderImpl(AudioConfiguration model) {
            this.codec(model.codec);
            this.targetBitrate(model.targetBitrate);
            this.sampleRate(model.sampleRate);
            this.channels(model.channels);
        }

        public final String getCodec() {
            return this.codec;
        }

        public final void setCodec(String codec) {
            this.codec = codec;
        }

        @Override
        public final Builder codec(String codec) {
            this.codec = codec;
            return this;
        }

        public final Long getTargetBitrate() {
            return this.targetBitrate;
        }

        public final void setTargetBitrate(Long targetBitrate) {
            this.targetBitrate = targetBitrate;
        }

        @Override
        public final Builder targetBitrate(Long targetBitrate) {
            this.targetBitrate = targetBitrate;
            return this;
        }

        public final Long getSampleRate() {
            return this.sampleRate;
        }

        public final void setSampleRate(Long sampleRate) {
            this.sampleRate = sampleRate;
        }

        @Override
        public final Builder sampleRate(Long sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public final Long getChannels() {
            return this.channels;
        }

        public final void setChannels(Long channels) {
            this.channels = channels;
        }

        @Override
        public final Builder channels(Long channels) {
            this.channels = channels;
            return this;
        }

        public AudioConfiguration build() {
            return new AudioConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AudioConfiguration> {
        public Builder codec(String var1);

        public Builder targetBitrate(Long var1);

        public Builder sampleRate(Long var1);

        public Builder channels(Long var1);
    }
}

