/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivs.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ivs.IvsAsyncClient;
import software.amazon.awssdk.services.ivs.internal.UserAgentUtils;
import software.amazon.awssdk.services.ivs.model.ListRecordingConfigurationsRequest;
import software.amazon.awssdk.services.ivs.model.ListRecordingConfigurationsResponse;

public class ListRecordingConfigurationsPublisher
implements SdkPublisher<ListRecordingConfigurationsResponse> {
    private final IvsAsyncClient client;
    private final ListRecordingConfigurationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRecordingConfigurationsPublisher(IvsAsyncClient client, ListRecordingConfigurationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRecordingConfigurationsPublisher(IvsAsyncClient client, ListRecordingConfigurationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRecordingConfigurationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRecordingConfigurationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListRecordingConfigurationsResponseFetcher
    implements AsyncPageFetcher<ListRecordingConfigurationsResponse> {
        private ListRecordingConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListRecordingConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRecordingConfigurationsResponse> nextPage(ListRecordingConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListRecordingConfigurationsPublisher.this.client.listRecordingConfigurations(ListRecordingConfigurationsPublisher.this.firstRequest);
            }
            return ListRecordingConfigurationsPublisher.this.client.listRecordingConfigurations((ListRecordingConfigurationsRequest)((Object)ListRecordingConfigurationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

