/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivs;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.ivs.DefaultIvsAsyncClient;
import software.amazon.awssdk.services.ivs.DefaultIvsBaseClientBuilder;
import software.amazon.awssdk.services.ivs.IvsAsyncClient;
import software.amazon.awssdk.services.ivs.IvsAsyncClientBuilder;
import software.amazon.awssdk.services.ivs.IvsServiceClientConfiguration;
import software.amazon.awssdk.services.ivs.endpoints.IvsEndpointProvider;

@SdkInternalApi
final class DefaultIvsAsyncClientBuilder
extends DefaultIvsBaseClientBuilder<IvsAsyncClientBuilder, IvsAsyncClient>
implements IvsAsyncClientBuilder {
    DefaultIvsAsyncClientBuilder() {
    }

    @Override
    public DefaultIvsAsyncClientBuilder endpointProvider(IvsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final IvsAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultIvsAsyncClientBuilder.validateClientOptions(clientConfiguration);
        IvsServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultIvsAsyncClient client = new DefaultIvsAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private IvsServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return IvsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

