/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ivs.model.Channel;
import software.amazon.awssdk.services.ivs.model.IvsResponse;
import software.amazon.awssdk.services.ivs.model.StreamKey;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateChannelResponse
extends IvsResponse
implements ToCopyableBuilder<Builder, CreateChannelResponse> {
    private static final SdkField<Channel> CHANNEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("channel").getter(CreateChannelResponse.getter(CreateChannelResponse::channel)).setter(CreateChannelResponse.setter(Builder::channel)).constructor(Channel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channel").build()}).build();
    private static final SdkField<StreamKey> STREAM_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("streamKey").getter(CreateChannelResponse.getter(CreateChannelResponse::streamKey)).setter(CreateChannelResponse.setter(Builder::streamKey)).constructor(StreamKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamKey").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_FIELD, STREAM_KEY_FIELD));
    private final Channel channel;
    private final StreamKey streamKey;

    private CreateChannelResponse(BuilderImpl builder) {
        super(builder);
        this.channel = builder.channel;
        this.streamKey = builder.streamKey;
    }

    public final Channel channel() {
        return this.channel;
    }

    public final StreamKey streamKey() {
        return this.streamKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.channel());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamKey());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateChannelResponse)) {
            return false;
        }
        CreateChannelResponse other = (CreateChannelResponse)((Object)obj);
        return Objects.equals(this.channel(), other.channel()) && Objects.equals(this.streamKey(), other.streamKey());
    }

    public final String toString() {
        return ToString.builder((String)"CreateChannelResponse").add("Channel", (Object)this.channel()).add("StreamKey", (Object)this.streamKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "channel": {
                return Optional.ofNullable(clazz.cast(this.channel()));
            }
            case "streamKey": {
                return Optional.ofNullable(clazz.cast(this.streamKey()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateChannelResponse, T> g) {
        return obj -> g.apply((CreateChannelResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IvsResponse.BuilderImpl
    implements Builder {
        private Channel channel;
        private StreamKey streamKey;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateChannelResponse model) {
            super(model);
            this.channel(model.channel);
            this.streamKey(model.streamKey);
        }

        public final Channel.Builder getChannel() {
            return this.channel != null ? this.channel.toBuilder() : null;
        }

        public final void setChannel(Channel.BuilderImpl channel) {
            this.channel = channel != null ? channel.build() : null;
        }

        @Override
        public final Builder channel(Channel channel) {
            this.channel = channel;
            return this;
        }

        public final StreamKey.Builder getStreamKey() {
            return this.streamKey != null ? this.streamKey.toBuilder() : null;
        }

        public final void setStreamKey(StreamKey.BuilderImpl streamKey) {
            this.streamKey = streamKey != null ? streamKey.build() : null;
        }

        @Override
        public final Builder streamKey(StreamKey streamKey) {
            this.streamKey = streamKey;
            return this;
        }

        @Override
        public CreateChannelResponse build() {
            return new CreateChannelResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IvsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateChannelResponse> {
        public Builder channel(Channel var1);

        default public Builder channel(Consumer<Channel.Builder> channel) {
            return this.channel((Channel)((Channel.Builder)Channel.builder().applyMutation(channel)).build());
        }

        public Builder streamKey(StreamKey var1);

        default public Builder streamKey(Consumer<StreamKey.Builder> streamKey) {
            return this.streamKey((StreamKey)((StreamKey.Builder)StreamKey.builder().applyMutation(streamKey)).build());
        }
    }
}

