/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivs;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.ivs.DefaultIvsBaseClientBuilder;
import software.amazon.awssdk.services.ivs.DefaultIvsClient;
import software.amazon.awssdk.services.ivs.IvsClient;
import software.amazon.awssdk.services.ivs.IvsClientBuilder;
import software.amazon.awssdk.services.ivs.IvsServiceClientConfiguration;
import software.amazon.awssdk.services.ivs.endpoints.IvsEndpointProvider;

@SdkInternalApi
final class DefaultIvsClientBuilder
extends DefaultIvsBaseClientBuilder<IvsClientBuilder, IvsClient>
implements IvsClientBuilder {
    DefaultIvsClientBuilder() {
    }

    @Override
    public DefaultIvsClientBuilder endpointProvider(IvsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final IvsClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultIvsClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        IvsServiceClientConfiguration serviceClientConfiguration = IvsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultIvsClient(serviceClientConfiguration, clientConfiguration);
    }
}

