/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRecordingConfigurationsResponse extends IvsResponse implements
        ToCopyableBuilder<ListRecordingConfigurationsResponse.Builder, ListRecordingConfigurationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListRecordingConfigurationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<RecordingConfigurationSummary>> RECORDING_CONFIGURATIONS_FIELD = SdkField
            .<List<RecordingConfigurationSummary>> builder(MarshallingType.LIST)
            .memberName("recordingConfigurations")
            .getter(getter(ListRecordingConfigurationsResponse::recordingConfigurations))
            .setter(setter(Builder::recordingConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordingConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RecordingConfigurationSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(RecordingConfigurationSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            RECORDING_CONFIGURATIONS_FIELD));

    private final String nextToken;

    private final List<RecordingConfigurationSummary> recordingConfigurations;

    private ListRecordingConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.recordingConfigurations = builder.recordingConfigurations;
    }

    /**
     * <p>
     * If there are more recording configurations than <code>maxResults</code>, use <code>nextToken</code> in the
     * request to get the next set.
     * </p>
     * 
     * @return If there are more recording configurations than <code>maxResults</code>, use <code>nextToken</code> in
     *         the request to get the next set.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the RecordingConfigurations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRecordingConfigurations() {
        return recordingConfigurations != null && !(recordingConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of the matching recording configurations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRecordingConfigurations} method.
     * </p>
     * 
     * @return List of the matching recording configurations.
     */
    public final List<RecordingConfigurationSummary> recordingConfigurations() {
        return recordingConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasRecordingConfigurations() ? recordingConfigurations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRecordingConfigurationsResponse)) {
            return false;
        }
        ListRecordingConfigurationsResponse other = (ListRecordingConfigurationsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && hasRecordingConfigurations() == other.hasRecordingConfigurations()
                && Objects.equals(recordingConfigurations(), other.recordingConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListRecordingConfigurationsResponse").add("NextToken", nextToken())
                .add("RecordingConfigurations", hasRecordingConfigurations() ? recordingConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "recordingConfigurations":
            return Optional.ofNullable(clazz.cast(recordingConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRecordingConfigurationsResponse, T> g) {
        return obj -> g.apply((ListRecordingConfigurationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IvsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListRecordingConfigurationsResponse> {
        /**
         * <p>
         * If there are more recording configurations than <code>maxResults</code>, use <code>nextToken</code> in the
         * request to get the next set.
         * </p>
         * 
         * @param nextToken
         *        If there are more recording configurations than <code>maxResults</code>, use <code>nextToken</code> in
         *        the request to get the next set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * List of the matching recording configurations.
         * </p>
         * 
         * @param recordingConfigurations
         *        List of the matching recording configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordingConfigurations(Collection<RecordingConfigurationSummary> recordingConfigurations);

        /**
         * <p>
         * List of the matching recording configurations.
         * </p>
         * 
         * @param recordingConfigurations
         *        List of the matching recording configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordingConfigurations(RecordingConfigurationSummary... recordingConfigurations);

        /**
         * <p>
         * List of the matching recording configurations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ivs.model.RecordingConfigurationSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.ivs.model.RecordingConfigurationSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ivs.model.RecordingConfigurationSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #recordingConfigurations(List<RecordingConfigurationSummary>)}.
         * 
         * @param recordingConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ivs.model.RecordingConfigurationSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recordingConfigurations(java.util.Collection<RecordingConfigurationSummary>)
         */
        Builder recordingConfigurations(Consumer<RecordingConfigurationSummary.Builder>... recordingConfigurations);
    }

    static final class BuilderImpl extends IvsResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<RecordingConfigurationSummary> recordingConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListRecordingConfigurationsResponse model) {
            super(model);
            nextToken(model.nextToken);
            recordingConfigurations(model.recordingConfigurations);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<RecordingConfigurationSummary.Builder> getRecordingConfigurations() {
            List<RecordingConfigurationSummary.Builder> result = RecordingConfigurationListCopier
                    .copyToBuilder(this.recordingConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecordingConfigurations(Collection<RecordingConfigurationSummary.BuilderImpl> recordingConfigurations) {
            this.recordingConfigurations = RecordingConfigurationListCopier.copyFromBuilder(recordingConfigurations);
        }

        @Override
        public final Builder recordingConfigurations(Collection<RecordingConfigurationSummary> recordingConfigurations) {
            this.recordingConfigurations = RecordingConfigurationListCopier.copy(recordingConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recordingConfigurations(RecordingConfigurationSummary... recordingConfigurations) {
            recordingConfigurations(Arrays.asList(recordingConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recordingConfigurations(Consumer<RecordingConfigurationSummary.Builder>... recordingConfigurations) {
            recordingConfigurations(Stream.of(recordingConfigurations)
                    .map(c -> RecordingConfigurationSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListRecordingConfigurationsResponse build() {
            return new ListRecordingConfigurationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
