/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivs.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ivs.IvsClient;
import software.amazon.awssdk.services.ivs.model.ListRecordingConfigurationsRequest;
import software.amazon.awssdk.services.ivs.model.ListRecordingConfigurationsResponse;

public class ListRecordingConfigurationsIterable
implements SdkIterable<ListRecordingConfigurationsResponse> {
    private final IvsClient client;
    private final ListRecordingConfigurationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRecordingConfigurationsIterable(IvsClient client, ListRecordingConfigurationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListRecordingConfigurationsResponseFetcher();
    }

    public Iterator<ListRecordingConfigurationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListRecordingConfigurationsResponseFetcher
    implements SyncPageFetcher<ListRecordingConfigurationsResponse> {
        private ListRecordingConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListRecordingConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRecordingConfigurationsResponse nextPage(ListRecordingConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListRecordingConfigurationsIterable.this.client.listRecordingConfigurations(ListRecordingConfigurationsIterable.this.firstRequest);
            }
            return ListRecordingConfigurationsIterable.this.client.listRecordingConfigurations((ListRecordingConfigurationsRequest)((Object)ListRecordingConfigurationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

